/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.content.x509;

import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;

public class XMLX509SKITest
extends TestCase {
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private CertificateFactory cf;
    static /* synthetic */ Class class$org$apache$xml$security$test$keys$content$x509$XMLX509SKITest;

    public XMLX509SKITest() {
        super("XMLX509SKITest");
    }

    public XMLX509SKITest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$keys$content$x509$XMLX509SKITest == null ? (class$org$apache$xml$security$test$keys$content$x509$XMLX509SKITest = XMLX509SKITest.class$("org.apache.xml.security.test.keys.content.x509.XMLX509SKITest")) : class$org$apache$xml$security$test$keys$content$x509$XMLX509SKITest);
    }

    public void setUp() throws Exception {
        this.cf = CertificateFactory.getInstance("X.509");
    }

    public void testGetSKIBytesFromCert() throws Exception {
        File file = null;
        file = BASEDIR != null && !"".equals(BASEDIR) ? new File(BASEDIR + SEP + "data/ie/baltimore/merlin-examples/merlin-xmldsig-twenty-three/certs/lugh.crt") : new File("data/ie/baltimore/merlin-examples/merlin-xmldsig-twenty-three/certs/lugh.crt");
        FileInputStream fileInputStream = new FileInputStream(file);
        X509Certificate x509Certificate = (X509Certificate)this.cf.generateCertificate(fileInputStream);
        byte[] byArray = XMLX509SKI.getSKIBytesFromCert((X509Certificate)x509Certificate);
        X509CertSelector x509CertSelector = new X509CertSelector();
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = 4;
        byArray2[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        x509CertSelector.setSubjectKeyIdentifier(byArray2);
        CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singleton(x509Certificate)));
        Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
        XMLX509SKITest.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

