/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.util.LangUtils;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservedInstancesConfigurationDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ModifyReservedInstances
extends BaseCmd {
    private static final String RESERVED_INSTANCE = "reserved-instance";
    private static final String TARGET_CONFIGURATION = "target-configuration";
    private static final String TARGET_CONFIGURATION_SHORT_OPTION = "c";
    private static final String TARGET_CONFIGURATION_ARG = "TARGET-CONFIGURATION";
    private static final String[] TARGET_CONFIGURATION_DESC = new String[]{"New configuration settings for the Reserved Instances.", "Each configuration is specified by comma-separated, key-value pairs", "in double quotes. Key names are zone, count, platform, and instance-type.", "Zone and count are required. Platform is optional if your account supports", "EC2-VPC; it must be specified if your account supports EC2-Classic.", "Instance type must be of the same instance family as the input Reserved Instances", "and defaults to the instance type of the input Reserved Instances", "when not specified. Refer to the latest Developer's Guide for valid values.", "", "Example 1 (modifying a Reserved Instance to one configuration):", "  ec2mri <RESERVED-INSTANCES-ID> -c \"zone=us-east-1a,count=1,platform=EC2-VPC,instance-type=m1.medium\"", "", "Example 2 (modifying multiple Reserved Instances to multiple configurations):", "  ec2mri <RESERVED-INSTANCES-ID-1> <RESERVED-INSTANCES-ID-2>", "     -c \"zone=us-east-1a,count=1,platform=EC2-VPC,instance-type=m1.medium\"", "     -c \"zone=us-east-1b,count=2,platform=EC2-Classic,instance-type=m1.small\""};
    private static final String CLIENT_TOKEN_PREFIX = "token-";
    private static final String[] CLIENT_TOKEN_DESC = new String[]{"The client token for this request to make the call idempotent.", "A random client token will be generated if this is not provided."};
    private static final String KEY_AVAILABILITY_ZONE = "zone";
    private static final String KEY_INSTANCE_COUNT = "count";
    private static final String KEY_PLATFORM = "platform";
    private static final String KEY_INSTANCE_TYPE = "instance-type";
    private static final String DELIMITER_FIELD = ",";
    private static final String DELIMITER_VALUE = "=";

    public ModifyReservedInstances(String[] args) {
        super("ec2mri", "ec2-modify-reserved-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)TARGET_CONFIGURATION);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)TARGET_CONFIGURATION_ARG);
        OptionBuilder.withDescription((String)ModifyReservedInstances.joinDescription(TARGET_CONFIGURATION_DESC));
        options.addOption(OptionBuilder.create((String)TARGET_CONFIGURATION_SHORT_OPTION));
        OptionBuilder.withLongOpt((String)"client-token");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TOKEN");
        OptionBuilder.withDescription((String)ModifyReservedInstances.joinDescription(CLIENT_TOKEN_DESC));
        options.addOption(OptionBuilder.create(null));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modifies the Availability Zone, instance count, network platform");
        System.out.println("     (EC2-Classic or EC2-VPC), or instance type of your Reserved Instances.");
        System.out.println("     RESERVED-INSTANCES-IDs are the IDs of Reserved Instances to modify.");
        System.out.println("     These IDs must refer to Reserved Instances that are identical,");
        System.out.println("     except for Availability Zone, network platform, and instance type.");
    }

    @Override
    protected String getOptionString() {
        return "RESERVED-INSTANCES-ID [RESERVED-INSTANCES-ID [...]] [--client-token TOKEN] -c TARGET-CONFIGURATION [-c TARGET-CONFIGURATION [...]]";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("client-token");
        this.printOption(TARGET_CONFIGURATION);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet(RESERVED_INSTANCE);
        this.assertOptionSet(TARGET_CONFIGURATION);
        String clientToken = this.isOptionSet("client-token") ? this.getOptionValue("client-token") : CLIENT_TOKEN_PREFIX + UUID.randomUUID();
        List<ReservedInstancesConfigurationDescription> targetConfigs = ModifyReservedInstances.parseConfigs(this.getOptionValues(TARGET_CONFIGURATION));
        RequestResultPair rsp = jec2.modifyReservedInstances(Arrays.asList(this.getNonOptions()), targetConfigs, clientToken);
        out.outputReservedInstancesModification(System.out, (String)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new ModifyReservedInstances(args).invoke();
    }

    static List<ReservedInstancesConfigurationDescription> parseConfigs(String[] optionValues) {
        ArrayList<ReservedInstancesConfigurationDescription> configs = new ArrayList<ReservedInstancesConfigurationDescription>();
        for (String optionValue : optionValues) {
            configs.add(ModifyReservedInstances.parseConfig(optionValue));
        }
        return configs;
    }

    private static ReservedInstancesConfigurationDescription parseConfig(String optionValue) {
        String[] keyValues;
        if (optionValue == null) {
            ModifyReservedInstances.throwInvalidFormatError(optionValue);
        }
        if ((keyValues = optionValue.split(DELIMITER_FIELD, -1)) == null || keyValues.length == 0) {
            ModifyReservedInstances.throwInvalidFormatError(optionValue);
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String keyValue : keyValues) {
            String[] keyValuePair;
            if (keyValue == null) {
                ModifyReservedInstances.throwInvalidFormatError(optionValue);
            }
            if ((keyValuePair = keyValue.split(DELIMITER_VALUE, -1)) == null || keyValuePair.length != 2) {
                ModifyReservedInstances.throwInvalidFormatError(optionValue);
            }
            String key = LangUtils.trimToEmpty(keyValuePair[0]).toLowerCase();
            String value = LangUtils.trimToEmpty(keyValuePair[1]);
            if (key.isEmpty()) {
                ModifyReservedInstances.throwInvalidFormatError(optionValue);
            }
            if (keyValueMap.put(key, value) == null) continue;
            ModifyReservedInstances.throwDuplicateConfigKeyError(optionValue);
        }
        String zoneValue = (String)keyValueMap.remove(KEY_AVAILABILITY_ZONE);
        String countValue = (String)keyValueMap.remove(KEY_INSTANCE_COUNT);
        String platformValue = (String)keyValueMap.remove(KEY_PLATFORM);
        String instanceTypeValue = (String)keyValueMap.remove(KEY_INSTANCE_TYPE);
        if (!keyValueMap.isEmpty()) {
            ModifyReservedInstances.throwUnknownConfigKeyError((String)keyValueMap.keySet().iterator().next());
        }
        if (LangUtils.isEmpty(zoneValue)) {
            ModifyReservedInstances.throwMissingConfigValueError(KEY_AVAILABILITY_ZONE);
        }
        if (LangUtils.isEmpty(countValue)) {
            ModifyReservedInstances.throwMissingConfigValueError(KEY_INSTANCE_COUNT);
        }
        return new ReservedInstancesConfigurationDescription(zoneValue, LangUtils.isEmpty(platformValue) ? null : platformValue, ModifyReservedInstances.parseInstanceCount(countValue), instanceTypeValue);
    }

    private static int parseInstanceCount(String countValue) {
        Integer parsedCount = null;
        try {
            parsedCount = Integer.parseInt(countValue);
        }
        catch (Exception e) {
            ModifyReservedInstances.throwInstanceCountInvalidFormatError(countValue);
        }
        return parsedCount;
    }

    private static void throwInvalidFormatError(String optionValue) {
        throw new GeneralError("Target configuration must be specified in key=value format, but found '" + optionValue + "'.");
    }

    private static void throwDuplicateConfigKeyError(String key) {
        throw new GeneralError("The specified key '" + key + "' is a duplicate.");
    }

    private static void throwUnknownConfigKeyError(String key) {
        throw new GeneralError("The key '" + key + "' is not recognized.");
    }

    private static void throwMissingConfigValueError(String key) {
        throw new GeneralError("A value must be specified for key '" + key + "'.");
    }

    private static void throwInstanceCountInvalidFormatError(String countValue) {
        throw new GeneralError("The instance count must be an integer, but found '" + countValue + "'.");
    }
}

