/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.KeyPairInfo;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ImportKeyPair
extends BaseCmd {
    private static final String PUBLIC_KEY_FILE = "public-key-file";
    private static final String PUBLIC_KEY_FILE_ARG = "FILE";
    private static final String PUBLIC_KEY_FILE_DESC = "Path to a file containing the public key material to import.";

    public ImportKeyPair(String[] args) {
        super("ec2ikey", "ec2-import-keypair");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Imports the public key for a key pair. ");
    }

    @Override
    protected String getOptionString() {
        return "KEY_NAME --public-key-file KEY_FILE";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(PUBLIC_KEY_FILE);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)PUBLIC_KEY_FILE);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)PUBLIC_KEY_FILE_ARG);
        OptionBuilder.withDescription((String)PUBLIC_KEY_FILE_DESC);
        o.addOption(OptionBuilder.create((String)"f"));
        return o;
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("KEY_NAME");
        this.assertOptionSet(PUBLIC_KEY_FILE);
        String keyFile = this.getOptionValue(PUBLIC_KEY_FILE);
        if (this.getNonOptions().length > 1) {
            throw new Exception("Only one KEY_NAME can be specified.");
        }
        String keyName = this.getNonOptions()[0];
        byte[] publicKeyMaterial = this.getUserDataFileUnencoded(keyFile);
        RequestResultPair rsp = jec2.importKeyPair(keyName, publicKeyMaterial);
        out.outputKeyPair(System.out, ((KeyPairInfo)rsp.getResponse()).keyName, ((KeyPairInfo)rsp.getResponse()).keyFingerprint);
        return true;
    }

    public static void main(String[] args) {
        new ImportKeyPair(args).invoke();
    }
}

