/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkInterfaceDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.cli.Options;

public class CreateNetworkInterface
extends BaseCmd {
    private static final String[] DESCRIPTION_DESC = new String[]{"Set the description of the network interface."};
    private static final String[] PRIVATE_IP_ADDRESS_DESC = new String[]{"Specifies the primary private IP address of the network interface.", "This is optional"};
    private static final String[] GROUP_DESC = new String[]{"Adds a security group to the network interface.", "This is optional. It can be used multiple times to add multiple groups."};
    private static final String[] SECONDARY_PRIVATE_IP_ADDRESS_DESC = new String[]{"The secondary private IP address to assign to the network interface."};
    private static final String[] SECONDARY_PRIVATE_IP_ADDRESS_COUNT_DESC = new String[]{"The number of secondary private IP addresses to be automatically", "assigned to the network interface."};
    private String description;
    private String subnetId;
    private String primaryPrivateIpAddress;
    private Collection<String> securityGroupIds;
    private Collection<String> secondaryPrivateIpAddresses;
    private Integer secondaryPrivateIpCount;

    public CreateNetworkInterface(String[] args) {
        super("ec2addnic", "ec2-create-network-interface");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "SUBNET";
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(CreateNetworkInterface.createOptionWithArgs("d", "description", DESCRIPTION_DESC, "DESCRIPTION"));
        result.addOption(CreateNetworkInterface.createOptionWithArgs(null, "private-ip-address", PRIVATE_IP_ADDRESS_DESC, "IP_ADDRESS"));
        result.addOption(CreateNetworkInterface.createOptionWithArgs("g", "group", GROUP_DESC, "GROUP"));
        result.addOption(CreateNetworkInterface.createOptionWithArgs(null, "secondary-private-ip-address", SECONDARY_PRIVATE_IP_ADDRESS_DESC, "SECONDARY-PRIVATE-IP-ADDRESS"));
        result.addOption(CreateNetworkInterface.createOptionWithArgs(null, "secondary-private-ip-address-count", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_DESC, "SECONDARY-PRIVATE-ADDRESS-COUNT"));
        return result;
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("description");
        this.printOption("private-ip-address");
        this.printOption("group");
        this.printOption("secondary-private-ip-address");
        this.printOption("secondary-private-ip-address-count");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a network interface in the subnet that you specify.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.createNetworkInterface(this.subnetId, this.description, this.securityGroupIds, this.primaryPrivateIpAddress, this.secondaryPrivateIpAddresses, this.secondaryPrivateIpCount);
        out.output(System.out, (NetworkInterfaceDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() throws Exception {
        String count;
        this.assertNonOptionSet("SUBNET");
        this.subnetId = this.getNonOptions()[0];
        this.description = this.getOptionValue("description");
        this.securityGroupIds = Arrays.asList(this.getOptionValues("group"));
        this.primaryPrivateIpAddress = this.getOptionValue("private-ip-address");
        this.secondaryPrivateIpAddresses = Arrays.asList(this.getOptionValues("secondary-private-ip-address"));
        if (this.secondaryPrivateIpAddresses.size() == 0) {
            this.secondaryPrivateIpAddresses = null;
        }
        if (null != (count = this.getOptionValue("secondary-private-ip-address-count")) && !"".equals(count)) {
            this.secondaryPrivateIpCount = Integer.parseInt(count);
        }
        if (null != this.secondaryPrivateIpCount && null != this.secondaryPrivateIpAddresses) {
            throw new InvalidArgumentCombination("Cannot specify both a secondary private ip address count and secondary private ip addresses.");
        }
        this.warnIfTooManyNonOptions();
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new CreateNetworkInterface(args).invoke();
    }
}

