/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CancelExportTask
extends BaseCmd {
    public CancelExportTask(String[] args) {
        super("ec2cxt", "ec2-cancel-export-task");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    protected String getOptionString() {
        return "EXPORT-TASK";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Cancels an active export task.");
        System.out.println("     The EXPORT-TASK parameter identifies the export task to cancel.");
        System.out.println("     Deletes any temporary resources (such as AMIs or snapshots) which were");
        System.out.println("     created by the task.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String exportTaskId = null;
        try {
            exportTaskId = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
        }
        catch (ArrayIndexOutOfBoundsException ax) {
            throw new GeneralError("Required Argument 'EXPORT-TASK' missing (-h for usage). ");
        }
        RequestResultPair rsp = jec2.cancelExportTask(exportTaskId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputExportTask(System.out, exportTaskId);
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CancelExportTask(args).invoke();
    }
}

