/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class XmlUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toXmlString(Document doc, boolean omitXMLDeclaration) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            XmlUtils.toXml(doc, writer, omitXMLDeclaration);
            String string = writer.toString();
            return string;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ignored) {}
        }
    }

    public static void toXml(Document doc, Writer writer, boolean omitXMLDeclaration) throws IOException {
        OutputFormat format = new OutputFormat(doc);
        format.setOmitXMLDeclaration(omitXMLDeclaration);
        XMLSerializer serializer = new XMLSerializer(writer, format);
        serializer.asDOMSerializer();
        serializer.serialize(doc);
    }

    public static Document readXmlFromUri(String uri) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(uri);
    }

    public static Document readXml(byte[] data) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(data));
    }

    public static String getTextFromDocument(Document document, String exp) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xpath.evaluate(exp, document, XPathConstants.NODE);
            return node.getTextContent();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setTextInDocument(Document document, String exp, String text) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xpath.evaluate(exp, document, XPathConstants.NODE);
            node.setTextContent(text);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Could not update document, because xpath is invalid: " + xpath, e);
        }
    }

    public static String getXmlPartAsString(Document document, String exp) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xpath.evaluate(exp, document, XPathConstants.NODE);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document nodeDoc = documentBuilder.newDocument();
            nodeDoc.appendChild(nodeDoc.importNode(node, true));
            return XmlUtils.toXmlString(nodeDoc, true);
        }
        catch (Exception e) {
            return null;
        }
    }
}

