/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxws;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.jaxws.Endpoint;
import org.codehaus.xfire.jaxws.JAXWSHelper;
import org.codehaus.xfire.jaxws.ServiceDelegate;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;

public class Provider
extends javax.xml.ws.spi.Provider {
    private static final Log log = LogFactory.getLog(Provider.class);

    public javax.xml.ws.spi.ServiceDelegate createServiceDelegate(URL wsdlLocation, QName serviceName, Class serviceClass) {
        log.debug((Object)("Creating service delegate " + serviceName + " for service class " + serviceClass.getName()));
        return new ServiceDelegate(wsdlLocation, serviceName, serviceClass);
    }

    public javax.xml.ws.Endpoint createEndpoint(String bindingId, Object implementor) {
        Endpoint endpoint = new Endpoint(bindingId, implementor);
        return endpoint;
    }

    public javax.xml.ws.Endpoint createAndPublishEndpoint(String address, Object implementor) {
        String bindingId;
        if (address.startsWith("http:") || address.startsWith("https:")) {
            bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        } else {
            TransportManager transportManager = JAXWSHelper.getInstance().getTransportManager();
            Transport t = transportManager.getTransportForUri(address);
            bindingId = t.getSupportedBindings()[0];
        }
        Endpoint endpoint = new Endpoint(bindingId, implementor);
        endpoint.publish(address);
        return endpoint;
    }
}

