/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxws;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlType;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.stax.ElementReader;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.jaxb2.JaxbType;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class JAXWSOperationBinding
implements MessageSerializer {
    private MessageSerializer delegate;
    private boolean processInput = false;
    private List inputPDs = new ArrayList();
    private Class inputClass;
    private boolean processOutput = false;
    private List outputPDs = new ArrayList();
    private Class outputClass;

    public JAXWSOperationBinding(OperationInfo op, MessageSerializer delegate) {
        int i;
        PropertyDescriptor[] pds;
        RequestWrapper wrapper;
        this.delegate = delegate;
        Method declared = op.getMethod();
        if (declared.isAnnotationPresent(RequestWrapper.class)) {
            this.processInput = true;
            wrapper = op.getMethod().getAnnotation(RequestWrapper.class);
            try {
                this.inputClass = ClassLoaderUtils.loadClass(wrapper.className(), this.getClass());
                String[] inputOrder = this.inputClass.getAnnotation(XmlType.class).propOrder();
                BeanInfo inputBeanInfo = Introspector.getBeanInfo(this.inputClass);
                pds = inputBeanInfo.getPropertyDescriptors();
                for (i = 0; i < inputOrder.length; ++i) {
                    this.inputPDs.add(this.getPropertyDescriptor(pds, inputOrder[i]));
                }
            }
            catch (ClassNotFoundException e) {
                throw new XFireRuntimeException("Could not load request class for operation " + op.getName(), e);
            }
            catch (IntrospectionException e) {
                throw new XFireRuntimeException("Could introspect request class for operation " + op.getName(), e);
            }
        }
        if (declared.isAnnotationPresent(ResponseWrapper.class)) {
            this.processOutput = true;
            wrapper = op.getMethod().getAnnotation(ResponseWrapper.class);
            try {
                this.outputClass = ClassLoaderUtils.loadClass(wrapper.className(), this.getClass());
                String[] outputOrder = this.outputClass.getAnnotation(XmlType.class).propOrder();
                BeanInfo outputBeanInfo = Introspector.getBeanInfo(this.outputClass);
                pds = outputBeanInfo.getPropertyDescriptors();
                for (i = 0; i < outputOrder.length; ++i) {
                    this.outputPDs.add(this.getPropertyDescriptor(pds, outputOrder[i]));
                }
            }
            catch (ClassNotFoundException e) {
                throw new XFireRuntimeException("Could not load response class for operation " + op.getName(), e);
            }
            catch (IntrospectionException e) {
                throw new XFireRuntimeException("Could introspect response class for operation " + op.getName(), e);
            }
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] descriptors, String name) {
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return descriptors[i];
        }
        return null;
    }

    public void readMessage(InMessage message, MessageContext context) throws XFireFault {
        if (AbstractBinding.isClientModeOn(context)) {
            if (this.processOutput) {
                Service service = context.getService();
                AegisBindingProvider provider = (AegisBindingProvider)service.getBindingProvider();
                Type type = provider.getType(service, this.outputClass);
                Object in = type.readObject(new ElementReader(message.getXMLStreamReader()), context);
                ArrayList<Object> parameters = new ArrayList<Object>();
                for (PropertyDescriptor pd : this.outputPDs) {
                    try {
                        Object val = this.getReadMethod(this.outputClass, pd).invoke(in, new Object[0]);
                        parameters.add(val);
                    }
                    catch (Exception e) {
                        throw new XFireRuntimeException("Couldn't read property " + pd.getName(), e);
                    }
                }
                message.setBody(parameters);
            } else {
                this.delegate.readMessage(message, context);
            }
        } else if (this.processInput) {
            Service service = context.getService();
            AegisBindingProvider provider = (AegisBindingProvider)service.getBindingProvider();
            Type type = provider.getType(service, this.inputClass);
            Object in = type.readObject(new ElementReader(message.getXMLStreamReader()), context);
            ArrayList<Object> parameters = new ArrayList<Object>();
            for (PropertyDescriptor pd : this.inputPDs) {
                try {
                    Object val = this.getReadMethod(this.inputClass, pd).invoke(in, new Object[0]);
                    parameters.add(val);
                }
                catch (Exception e) {
                    throw new XFireRuntimeException("Couldn't read property " + pd.getName(), e);
                }
            }
            message.setBody(parameters);
        } else {
            this.delegate.readMessage(message, context);
        }
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        if (this.processOutput) {
            Object out;
            Object[] params = (Object[])message.getBody();
            Service service = context.getService();
            AegisBindingProvider provider = (AegisBindingProvider)service.getBindingProvider();
            Type type = provider.getType(service, this.outputClass);
            try {
                out = this.outputClass.newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not instantiate resposne class " + this.outputClass.getName(), e);
            }
            for (int i = 0; i < this.outputPDs.size(); ++i) {
                PropertyDescriptor pd = (PropertyDescriptor)this.outputPDs.get(i);
                Object val = params[i];
                if (val == null) continue;
                try {
                    this.getWriteMethod(pd).invoke(out, val);
                    continue;
                }
                catch (Exception e) {
                    throw new XFireRuntimeException("Couldn't read property " + pd.getName(), e);
                }
            }
            ((JaxbType)type).writeObject(out, new ElementWriter(writer), context);
        } else {
            this.delegate.writeMessage(message, writer, context);
        }
    }

    protected Method getReadMethod(Class clazz, PropertyDescriptor pd) {
        Method mth = pd.getReadMethod();
        if (mth == null && pd.getPropertyType() == Boolean.class) {
            String name = pd.getName();
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            name = "is" + name;
            try {
                mth = clazz.getMethod(name, new Class[0]);
                if (mth != null) {
                    pd.setReadMethod(mth);
                }
            }
            catch (IntrospectionException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return mth;
    }

    protected Method getWriteMethod(PropertyDescriptor pd) {
        return pd.getWriteMethod();
    }
}

