/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.filemonitoring;

import com.almworks.tracklink.filemonitoring.FileMapper;
import com.almworks.tracklink.filemonitoring.FileMapperImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileMapperManager {
    private static final String MANAGER_ELEM = "TrackLink.FileMapperManager";
    private static final String MAPPER_ELEM = "FileMapper";
    private static final String DEFAULT_PROJECT_URL = "default";
    private static final String PROJECT_ATTR = "projectURL";
    public Map<String, FileMapper> myMap = new HashMap();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileMapper getFileMapper(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileMapperManager.getFileMapper must not be null");
        }
        VirtualFile baseDir = project.getBaseDir();
        String projectUrl = baseDir == null ? DEFAULT_PROJECT_URL : baseDir.getUrl();
        FileMapper mapper = this.myMap.get(projectUrl);
        if (mapper == null) {
            mapper = new FileMapperImpl(projectUrl);
            this.myMap.put(projectUrl, mapper);
        }
        FileMapper fileMapper = mapper;
        if (fileMapper == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/filemonitoring/FileMapperManager.getFileMapper must not return null");
        }
        return fileMapper;
    }

    public void loadState(FileMapperManager state) {
        this.myMap.putAll(state.myMap);
    }
}

