/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink;

import com.almworks.tracklink.CheckinOptions;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.ModelCache;
import com.almworks.tracklink.PatternIndexer;
import com.almworks.tracklink.TrackLinkCaches;
import com.almworks.tracklink.codelinks.highlight.CodeParser;
import com.almworks.tracklink.filemonitoring.FileEditorWatcher;
import com.almworks.tracklink.filemonitoring.FileEditorWatcherImpl;
import com.almworks.tracklink.settings.ReferenceSettingsPanelForm;
import com.almworks.tracklink.settings.wizards.PatternSettingsWizard;
import com.almworks.tracklink.settings.wizards.impl.BugzillaSettingsWizard;
import com.almworks.tracklink.settings.wizards.impl.JIRASettingsWizard;
import com.almworks.tracklink.settings.wizards.impl.SunSettingsWizard;
import com.almworks.tracklink.util.PluginIcons;
import com.almworks.tracklink.util.StringBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.DetachComposite;
import org.almworks.util.detach.Lifespan;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="TL_PLUGIN", storages={@Storage(id="TL_PLUGIN", file="$PROJECT_FILE$")})
public class TrackLinkPlugin
implements ProjectComponent,
Configurable,
PersistentStateComponent<TrackLinkPlugin> {
    private final List<PatternSettingsWizard> myWizardList = Arrays.asList(new BugzillaSettingsWizard(), new JIRASettingsWizard(), new SunSettingsWizard());
    private FileEditorWatcherImpl myEditorWatcher;
    private ReferenceSettingsPanelForm mySettingsPanel;
    private PatternIndexer myPatternIndexer;
    @Nullable
    private Project myProject;
    private final DetachComposite myLifespan = new DetachComposite();
    public IssueLinkModel myModel = new IssueLinkModel();
    public CheckinOptions myCheckinOptions = new CheckinOptions();
    private final CodeParser myParser = new CodeParser(this.myModel);

    public TrackLinkPlugin() {
    }

    public TrackLinkPlugin(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getComponentName() {
        if ("TL_PLUGIN" == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/TrackLinkPlugin.getComponentName must not return null");
        }
        return "TL_PLUGIN";
    }

    public void projectOpened() {
        final Project project = this.myProject;
        if (project == null) {
            assert (false) : this;
            return;
        }
        FileEditorManager.getInstance((Project)project).addFileEditorManagerListener((FileEditorManagerListener)this.myEditorWatcher);
        ModelCache.getInstance().addModel(project, this.myModel, (Lifespan)this.myLifespan);
        this.myLifespan.add(new Detach(){

            protected void doDetach() {
                FileEditorManager.getInstance((Project)project).removeFileEditorManagerListener((FileEditorManagerListener)TrackLinkPlugin.this.myEditorWatcher);
                TrackLinkPlugin.this.myEditorWatcher.projectClosed();
            }
        });
    }

    public void projectClosed() {
        this.myLifespan.detach();
        this.myProject = null;
    }

    public void initComponent() {
        TrackLinkCaches caches = TrackLinkCaches.getInstance();
        if (caches == null) {
            return;
        }
        this.myEditorWatcher = new FileEditorWatcherImpl(this.myProject, this.myParser, caches.getArtifactInfoCache());
    }

    public void disposeComponent() {
    }

    public TrackLinkPlugin getState() {
        return this;
    }

    public void loadState(TrackLinkPlugin state) {
        this.getIssueModel().loadState(state.myModel);
        this.myCheckinOptions.loadState(state.getCheckinOptions());
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    public CheckinOptions getCheckinOptions() {
        return this.myCheckinOptions;
    }

    public String getDisplayName() {
        return StringBundle.get("plugin.name", new Object[0]);
    }

    public Icon getIcon() {
        return PluginIcons.LOGO;
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.mySettingsPanel = new ReferenceSettingsPanelForm(this.myModel, this.myWizardList.toArray(new PatternSettingsWizard[this.myWizardList.size()]));
        return this.mySettingsPanel.getComponent();
    }

    public void showConfigurationDialog(Component owner) {
        ShowSettingsUtil.getInstance().editConfigurable(owner, (Configurable)this);
    }

    public boolean isModified() {
        return this.myModel.isModified();
    }

    public void apply() {
        if (this.myModel.apply()) {
            this.myEditorWatcher.checkOpenEditors();
        }
    }

    public void reset() {
        this.myModel.reset();
        if (this.mySettingsPanel != null) {
            this.mySettingsPanel.refresh();
        }
    }

    public void disposeUIResources() {
        if (this.mySettingsPanel != null) {
            this.mySettingsPanel.detachListeners();
        }
    }

    public List<PatternSettingsWizard> getWizards() {
        return this.myWizardList;
    }

    public CodeParser getParser() {
        return this.myParser;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public IssueLinkModel getIssueModel() {
        IssueLinkModel issueLinkModel = this.myModel;
        if (issueLinkModel == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/TrackLinkPlugin.getIssueModel must not return null");
        }
        return issueLinkModel;
    }

    public void setPatternIndexer(PatternIndexer patternIndexer) {
        this.myPatternIndexer = patternIndexer;
    }

    public PatternIndexer getPatternIndexer() {
        return this.myPatternIndexer;
    }

    public FileEditorWatcher getEditorWatcher() {
        return this.myEditorWatcher;
    }

    public static TrackLinkPlugin getInstance(Project project) {
        return (TrackLinkPlugin)project.getComponent(TrackLinkPlugin.class);
    }

    @NonNls
    public static File getSystemHome() {
        return new File(PathManager.getSystemPath(), "Tracklink");
    }
}

