/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.plexus.Hints;

public final class Roles {
    private static final String MISSING_COMPONENT_ERROR = "No implementation for %s was bound.";
    private static final String MISSING_COMPONENT_WITH_HINT_ERROR = "No implementation for %s annotated with @Named(value=%s) was bound.";

    private Roles() {
    }

    public static String canonicalRoleHint(String role, String hint) {
        return Hints.isDefaultHint(hint) ? role : String.valueOf(role) + ':' + hint;
    }

    public static String canonicalRoleHint(Component component) {
        return Roles.canonicalRoleHint(component.role().getName(), component.hint());
    }

    public static TypeLiteral<?> roleType(Requirement requirement, TypeLiteral<?> asType) {
        Class<?> role = requirement.role();
        if (role != Object.class && role != Map.class && role != List.class) {
            return TypeLiteral.get(role);
        }
        Class<?> rawType = asType.getRawType();
        if (Map.class == rawType) {
            return TypeArguments.get(asType, 1);
        }
        if (List.class == rawType) {
            return TypeArguments.get(asType, 0);
        }
        return asType;
    }

    public static Key<?> componentKey(Component component) {
        return Roles.componentKey(component.role(), component.hint());
    }

    public static <T> Key<T> componentKey(Class<T> role, String hint) {
        if (Hints.isDefaultHint(hint)) {
            return Key.get(role);
        }
        return Key.get(role, (Annotation)Names.named(Hints.canonicalHint(hint)));
    }

    public static <T> Key<T> componentKey(TypeLiteral<T> role, String hint) {
        return Roles.componentKey(role.getRawType(), hint);
    }

    public static <T> T throwMissingComponentException(TypeLiteral<T> role, String hint) {
        if (Hints.isDefaultHint(hint)) {
            throw new ProvisionException(String.format(MISSING_COMPONENT_ERROR, role));
        }
        throw new ProvisionException(String.format(MISSING_COMPONENT_WITH_HINT_ERROR, role, hint));
    }

    public static String camelizeName(String name2) {
        StringBuilder buf = null;
        int length = name2.length();
        int i = 0;
        while (i < length) {
            if ('-' == name2.charAt(i)) {
                buf = new StringBuilder(name2.substring(0, i));
                break;
            }
            ++i;
        }
        if (buf == null) {
            return name2;
        }
        boolean capitalize2 = true;
        int i2 = buf.length() + 1;
        while (i2 < length) {
            char c = name2.charAt(i2);
            if ('-' == c) {
                capitalize2 = true;
            } else if (capitalize2) {
                buf.append(Character.toTitleCase(c));
                capitalize2 = false;
            } else {
                buf.append(c);
            }
            ++i2;
        }
        return buf.toString();
    }
}

