/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class ArrayConverter
extends AbstractCollectionConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return type2.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator);
        if (type2.isInstance(value)) {
            return value;
        }
        try {
            Collection<Object> elements;
            Class<?> elementType = type2.getComponentType();
            if (value == null) {
                elements = this.fromChildren(lookup, configuration, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof String) {
                PlexusConfiguration xml2 = ArrayConverter.csvToXml(configuration, (String)value);
                elements = this.fromChildren(lookup, xml2, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof Collection) {
                elements = (Collection<Object>)value;
            } else {
                this.failIfNotTypeCompatible(value, type2, configuration);
                elements = Collections.emptyList();
            }
            return elements.toArray((Object[])Array.newInstance(elementType, elements.size()));
        }
        catch (ComponentConfigurationException e2) {
            if (e2.getFailedConfiguration() == null) {
                e2.setFailedConfiguration(configuration);
            }
            throw e2;
        }
        catch (ArrayStoreException e3) {
            throw new ComponentConfigurationException(configuration, "Cannot store value into array", e3);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type2, ClassLoader loader) {
        return new ArrayList<Object>(configuration.getChildCount());
    }
}

