/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.Locale;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    public CookieOrigin(String host, int port, String path2, boolean secure) {
        Args.notBlank(host, "Host");
        Args.notNegative(port, "Port");
        Args.notNull(path2, "Path");
        this.host = host.toLowerCase(Locale.ROOT);
        this.port = port;
        this.path = !TextUtils.isBlank(path2) ? path2 : "/";
        this.secure = secure;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append('[');
        if (this.secure) {
            buffer2.append("(secure)");
        }
        buffer2.append(this.host);
        buffer2.append(':');
        buffer2.append(Integer.toString(this.port));
        buffer2.append(this.path);
        buffer2.append(']');
        return buffer2.toString();
    }
}

