/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.BigInt;
import clojure.lang.Compiler;
import clojure.lang.IExceptionInfo;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IRecord;
import clojure.lang.IReference;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Namespace;
import clojure.lang.Numbers;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentTreeMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.ReaderConditional;
import clojure.lang.Reflector;
import clojure.lang.Symbol;
import clojure.lang.TaggedLiteral;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LispReader {
    static final Symbol QUOTE = Symbol.intern("quote");
    static final Symbol THE_VAR = Symbol.intern("var");
    static Symbol UNQUOTE = Symbol.intern("clojure.core", "unquote");
    static Symbol UNQUOTE_SPLICING = Symbol.intern("clojure.core", "unquote-splicing");
    static Symbol CONCAT = Symbol.intern("clojure.core", "concat");
    static Symbol SEQ = Symbol.intern("clojure.core", "seq");
    static Symbol LIST = Symbol.intern("clojure.core", "list");
    static Symbol APPLY = Symbol.intern("clojure.core", "apply");
    static Symbol HASHMAP = Symbol.intern("clojure.core", "hash-map");
    static Symbol HASHSET = Symbol.intern("clojure.core", "hash-set");
    static Symbol VECTOR = Symbol.intern("clojure.core", "vector");
    static Symbol WITH_META = Symbol.intern("clojure.core", "with-meta");
    static Symbol META = Symbol.intern("clojure.core", "meta");
    static Symbol DEREF = Symbol.intern("clojure.core", "deref");
    static Symbol READ_COND = Symbol.intern("clojure.core", "read-cond");
    static Symbol READ_COND_SPLICING = Symbol.intern("clojure.core", "read-cond-splicing");
    static Keyword UNKNOWN = Keyword.intern(null, "unknown");
    static IFn[] macros = new IFn[256];
    static IFn[] dispatchMacros = new IFn[256];
    static Pattern symbolPat = Pattern.compile("[:]?([\\D&&[^/]].*/)?(/|[\\D&&[^/]][^/]*)");
    static Pattern intPat = Pattern.compile("([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
    static Pattern ratioPat = Pattern.compile("([-+]?[0-9]+)/([0-9]+)");
    static Pattern floatPat = Pattern.compile("([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
    static Var GENSYM_ENV = Var.create(null).setDynamic();
    static Var ARG_ENV = Var.create(null).setDynamic();
    static IFn ctorReader = new CtorReader();
    static Var READ_COND_ENV = Var.create(null).setDynamic();
    public static final Keyword OPT_EOF;
    public static final Keyword OPT_FEATURES;
    public static final Keyword OPT_READ_COND;
    public static final Keyword EOFTHROW;
    private static final Keyword PLATFORM_KEY;
    private static final Object PLATFORM_FEATURES;
    public static final Keyword COND_ALLOW;
    public static final Keyword COND_PRESERVE;
    private static final Object READ_EOF;
    private static final Object READ_FINISHED;

    static boolean isWhitespace(int ch) {
        return Character.isWhitespace(ch) || ch == 44;
    }

    static void unread(PushbackReader r, int ch) {
        if (ch != -1) {
            try {
                r.unread(ch);
            }
            catch (IOException e2) {
                throw Util.sneakyThrow(e2);
            }
        }
    }

    public static int read1(Reader r) {
        try {
            return r.read();
        }
        catch (IOException e2) {
            throw Util.sneakyThrow(e2);
        }
    }

    public static Object read(PushbackReader r, Object opts) {
        Object eof;
        boolean eofIsError = true;
        Object eofValue = null;
        if (opts != null && opts instanceof IPersistentMap && !EOFTHROW.equals(eof = ((IPersistentMap)opts).valAt(OPT_EOF, EOFTHROW))) {
            eofIsError = false;
            eofValue = eof;
        }
        return LispReader.read(r, eofIsError, eofValue, false, opts);
    }

    public static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive) {
        return LispReader.read(r, eofIsError, eofValue, isRecursive, PersistentHashMap.EMPTY);
    }

    public static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive, Object opts) {
        return LispReader.read(r, eofIsError, eofValue, null, null, isRecursive, opts, null, (Resolver)RT.READER_RESOLVER.deref());
    }

    private static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive, Object opts, Object pendingForms) {
        return LispReader.read(r, eofIsError, eofValue, null, null, isRecursive, opts, LispReader.ensurePending(pendingForms), (Resolver)RT.READER_RESOLVER.deref());
    }

    private static Object ensurePending(Object pendingForms) {
        if (pendingForms == null) {
            return new LinkedList();
        }
        return pendingForms;
    }

    private static Object installPlatformFeature(Object opts) {
        if (opts == null) {
            return RT.mapUniqueKeys(OPT_FEATURES, PLATFORM_FEATURES);
        }
        IPersistentMap mopts = (IPersistentMap)opts;
        Object features = mopts.valAt(OPT_FEATURES);
        if (features == null) {
            return mopts.assoc(OPT_FEATURES, PLATFORM_FEATURES);
        }
        return mopts.assoc(OPT_FEATURES, RT.conj((IPersistentSet)features, PLATFORM_KEY));
    }

    private static Object read(PushbackReader r, boolean eofIsError, Object eofValue, Character returnOn, Object returnOnValue, boolean isRecursive, Object opts, Object pendingForms, Resolver resolver2) {
        if (RT.READEVAL.deref() == UNKNOWN) {
            throw Util.runtimeException("Reading disallowed - *read-eval* bound to :unknown");
        }
        opts = LispReader.installPlatformFeature(opts);
        try {
            int ch;
            block13: {
                IFn macroFn;
                Object ret;
                do {
                    if (pendingForms instanceof List && !((List)pendingForms).isEmpty()) {
                        return ((List)pendingForms).remove(0);
                    }
                    ch = LispReader.read1(r);
                    while (LispReader.isWhitespace(ch)) {
                        ch = LispReader.read1(r);
                    }
                    if (ch == -1) {
                        if (eofIsError) {
                            throw Util.runtimeException("EOF while reading");
                        }
                        return eofValue;
                    }
                    if (returnOn != null && returnOn.charValue() == ch) {
                        return returnOnValue;
                    }
                    if (Character.isDigit(ch)) {
                        Object n = LispReader.readNumber(r, (char)ch);
                        return n;
                    }
                    macroFn = LispReader.getMacro(ch);
                    if (macroFn == null) break block13;
                } while ((ret = macroFn.invoke(r, Character.valueOf((char)ch), opts, pendingForms)) == r);
                return ret;
            }
            if (ch == 43 || ch == 45) {
                int ch2 = LispReader.read1(r);
                if (Character.isDigit(ch2)) {
                    LispReader.unread(r, ch2);
                    Object n = LispReader.readNumber(r, (char)ch);
                    return n;
                }
                LispReader.unread(r, ch2);
            }
            String token = LispReader.readToken(r, (char)ch);
            return LispReader.interpretToken(token, resolver2);
        }
        catch (Exception e2) {
            if (isRecursive || !(r instanceof LineNumberingPushbackReader)) {
                throw Util.sneakyThrow(e2);
            }
            LineNumberingPushbackReader rdr = (LineNumberingPushbackReader)r;
            throw new ReaderException(rdr.getLineNumber(), rdr.getColumnNumber(), e2);
        }
    }

    private static String readToken(PushbackReader r, char initch) {
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            int ch;
            if ((ch = LispReader.read1(r)) == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                LispReader.unread(r, ch);
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    private static Object readNumber(PushbackReader r, char initch) {
        int ch;
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            if ((ch = LispReader.read1(r)) == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) break;
            sb.append((char)ch);
        }
        LispReader.unread(r, ch);
        String s2 = sb.toString();
        Object n = LispReader.matchNumber(s2);
        if (n == null) {
            throw new NumberFormatException("Invalid number: " + s2);
        }
        return n;
    }

    private static int readUnicodeChar(String token, int offset, int length, int base) {
        if (token.length() != offset + length) {
            throw new IllegalArgumentException("Invalid unicode character: \\" + token);
        }
        int uc = 0;
        for (int i = offset; i < offset + length; ++i) {
            int d = Character.digit(token.charAt(i), base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + token.charAt(i));
            }
            uc = uc * base + d;
        }
        return (char)uc;
    }

    private static int readUnicodeChar(PushbackReader r, int initch, int base, int length, boolean exact) {
        int i;
        int uc = Character.digit(initch, base);
        if (uc == -1) {
            throw new IllegalArgumentException("Invalid digit: " + (char)initch);
        }
        for (i = 1; i < length; ++i) {
            int ch = LispReader.read1(r);
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) {
                LispReader.unread(r, ch);
                break;
            }
            int d = Character.digit(ch, base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)ch);
            }
            uc = uc * base + d;
        }
        if (i != length && exact) {
            throw new IllegalArgumentException("Invalid character length: " + i + ", should be: " + length);
        }
        return uc;
    }

    private static Object interpretToken(String s2, Resolver resolver2) {
        if (s2.equals("nil")) {
            return null;
        }
        if (s2.equals("true")) {
            return RT.T;
        }
        if (s2.equals("false")) {
            return RT.F;
        }
        Object ret = null;
        ret = LispReader.matchSymbol(s2, resolver2);
        if (ret != null) {
            return ret;
        }
        throw Util.runtimeException("Invalid token: " + s2);
    }

    private static Object matchSymbol(String s2, Resolver resolver2) {
        Matcher m3 = symbolPat.matcher(s2);
        if (m3.matches()) {
            int gc = m3.groupCount();
            String ns2 = m3.group(1);
            String name2 = m3.group(2);
            if (ns2 != null && ns2.endsWith(":/") || name2.endsWith(":") || s2.indexOf("::", 1) != -1) {
                return null;
            }
            if (s2.startsWith("::")) {
                Symbol ks = Symbol.intern(s2.substring(2));
                if (resolver2 != null) {
                    Symbol nsym = ks.ns != null ? resolver2.resolveAlias(Symbol.intern(ks.ns)) : resolver2.currentNS();
                    if (nsym != null) {
                        return Keyword.intern(nsym.name, ks.name);
                    }
                    return null;
                }
                Namespace kns = ks.ns != null ? Compiler.currentNS().lookupAlias(Symbol.intern(ks.ns)) : Compiler.currentNS();
                if (kns != null) {
                    return Keyword.intern(kns.name.name, ks.name);
                }
                return null;
            }
            boolean isKeyword = s2.charAt(0) == ':';
            Symbol sym = Symbol.intern(s2.substring(isKeyword ? 1 : 0));
            if (isKeyword) {
                return Keyword.intern(sym);
            }
            return sym;
        }
        return null;
    }

    private static Object matchNumber(String s2) {
        Matcher m3 = intPat.matcher(s2);
        if (m3.matches()) {
            if (m3.group(2) != null) {
                if (m3.group(8) != null) {
                    return BigInt.ZERO;
                }
                return Numbers.num(0L);
            }
            boolean negate = m3.group(1).equals("-");
            int radix = 10;
            String n = m3.group(3);
            if (n != null) {
                radix = 10;
            } else {
                n = m3.group(4);
                if (n != null) {
                    radix = 16;
                } else {
                    n = m3.group(5);
                    if (n != null) {
                        radix = 8;
                    } else {
                        n = m3.group(7);
                        if (n != null) {
                            radix = Integer.parseInt(m3.group(6));
                        }
                    }
                }
            }
            if (n == null) {
                return null;
            }
            BigInteger bn = new BigInteger(n, radix);
            if (negate) {
                bn = bn.negate();
            }
            if (m3.group(8) != null) {
                return BigInt.fromBigInteger(bn);
            }
            return bn.bitLength() < 64 ? Numbers.num(bn.longValue()) : BigInt.fromBigInteger(bn);
        }
        m3 = floatPat.matcher(s2);
        if (m3.matches()) {
            if (m3.group(4) != null) {
                return new BigDecimal(m3.group(1));
            }
            return Double.parseDouble(s2);
        }
        m3 = ratioPat.matcher(s2);
        if (m3.matches()) {
            String numerator2 = m3.group(1);
            if (numerator2.startsWith("+")) {
                numerator2 = numerator2.substring(1);
            }
            return Numbers.divide((Object)Numbers.reduceBigInt(BigInt.fromBigInteger(new BigInteger(numerator2))), (Object)Numbers.reduceBigInt(BigInt.fromBigInteger(new BigInteger(m3.group(2)))));
        }
        return null;
    }

    private static IFn getMacro(int ch) {
        if (ch < macros.length) {
            return macros[ch];
        }
        return null;
    }

    private static boolean isMacro(int ch) {
        return ch < macros.length && macros[ch] != null;
    }

    private static boolean isTerminatingMacro(int ch) {
        return ch != 35 && ch != 39 && ch != 37 && LispReader.isMacro(ch);
    }

    static Symbol garg(int n) {
        return Symbol.intern(null, (n == -1 ? "rest" : "p" + n) + "__" + RT.nextID() + "#");
    }

    static Symbol registerArg(int n) {
        PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
        if (argsyms == null) {
            throw new IllegalStateException("arg literal not in #()");
        }
        Symbol ret = (Symbol)argsyms.valAt(n);
        if (ret == null) {
            ret = LispReader.garg(n);
            ARG_ENV.set(argsyms.assoc(n, ret));
        }
        return ret;
    }

    static boolean isUnquoteSplicing(Object form2) {
        return form2 instanceof ISeq && Util.equals(RT.first(form2), UNQUOTE_SPLICING);
    }

    static boolean isUnquote(Object form2) {
        return form2 instanceof ISeq && Util.equals(RT.first(form2), UNQUOTE);
    }

    public static List readDelimitedList(char delim, PushbackReader r, boolean isRecursive, Object opts, Object pendingForms) {
        int firstline = r instanceof LineNumberingPushbackReader ? ((LineNumberingPushbackReader)r).getLineNumber() : -1;
        ArrayList<Object> a = new ArrayList<Object>();
        Resolver resolver2 = (Resolver)RT.READER_RESOLVER.deref();
        while (true) {
            Object form2;
            if ((form2 = LispReader.read(r, false, READ_EOF, Character.valueOf(delim), READ_FINISHED, isRecursive, opts, pendingForms, resolver2)) == READ_EOF) {
                if (firstline < 0) {
                    throw Util.runtimeException("EOF while reading");
                }
                throw Util.runtimeException("EOF while reading, starting at line " + firstline);
            }
            if (form2 == READ_FINISHED) {
                return a;
            }
            a.add(form2);
        }
    }

    static boolean isPreserveReadCond(Object opts) {
        if (RT.booleanCast(READ_COND_ENV.deref()) && opts instanceof IPersistentMap) {
            Object readCond = ((IPersistentMap)opts).valAt(OPT_READ_COND);
            return COND_PRESERVE.equals(readCond);
        }
        return false;
    }

    static {
        LispReader.macros[34] = new StringReader();
        LispReader.macros[59] = new CommentReader();
        LispReader.macros[39] = new WrappingReader(QUOTE);
        LispReader.macros[64] = new WrappingReader(DEREF);
        LispReader.macros[94] = new MetaReader();
        LispReader.macros[96] = new SyntaxQuoteReader();
        LispReader.macros[126] = new UnquoteReader();
        LispReader.macros[40] = new ListReader();
        LispReader.macros[41] = new UnmatchedDelimiterReader();
        LispReader.macros[91] = new VectorReader();
        LispReader.macros[93] = new UnmatchedDelimiterReader();
        LispReader.macros[123] = new MapReader();
        LispReader.macros[125] = new UnmatchedDelimiterReader();
        LispReader.macros[92] = new CharacterReader();
        LispReader.macros[37] = new ArgReader();
        LispReader.macros[35] = new DispatchReader();
        LispReader.dispatchMacros[94] = new MetaReader();
        LispReader.dispatchMacros[35] = new SymbolicValueReader();
        LispReader.dispatchMacros[39] = new VarReader();
        LispReader.dispatchMacros[34] = new RegexReader();
        LispReader.dispatchMacros[40] = new FnReader();
        LispReader.dispatchMacros[123] = new SetReader();
        LispReader.dispatchMacros[61] = new EvalReader();
        LispReader.dispatchMacros[33] = new CommentReader();
        LispReader.dispatchMacros[60] = new UnreadableReader();
        LispReader.dispatchMacros[95] = new DiscardReader();
        LispReader.dispatchMacros[63] = new ConditionalReader();
        LispReader.dispatchMacros[58] = new NamespaceMapReader();
        OPT_EOF = Keyword.intern(null, "eof");
        OPT_FEATURES = Keyword.intern(null, "features");
        OPT_READ_COND = Keyword.intern(null, "read-cond");
        EOFTHROW = Keyword.intern(null, "eofthrow");
        PLATFORM_KEY = Keyword.intern(null, "clj");
        PLATFORM_FEATURES = PersistentHashSet.create(PLATFORM_KEY);
        COND_ALLOW = Keyword.intern(null, "allow");
        COND_PRESERVE = Keyword.intern(null, "preserve");
        READ_EOF = new Object();
        READ_FINISHED = new Object();
    }

    public static class ConditionalReader
    extends AFn {
        private static final Object READ_STARTED = new Object();
        public static final Keyword DEFAULT_FEATURE = Keyword.intern(null, "default");
        public static final IPersistentSet RESERVED_FEATURES = RT.set(Keyword.intern(null, "else"), Keyword.intern(null, "none"));

        public static boolean hasFeature(Object feature, Object opts) {
            if (!(feature instanceof Keyword)) {
                throw Util.runtimeException("Feature should be a keyword: " + feature);
            }
            if (DEFAULT_FEATURE.equals(feature)) {
                return true;
            }
            IPersistentSet custom = (IPersistentSet)((IPersistentMap)opts).valAt(OPT_FEATURES);
            return custom != null && custom.contains(feature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object readCondDelimited(PushbackReader r, boolean splicing, Object opts, Object pendingForms) {
            int firstline;
            Object result = READ_STARTED;
            boolean toplevel = pendingForms == null;
            pendingForms = LispReader.ensurePending(pendingForms);
            int n = firstline = r instanceof LineNumberingPushbackReader ? ((LineNumberingPushbackReader)r).getLineNumber() : -1;
            while (true) {
                Object form2;
                if (result == READ_STARTED) {
                    form2 = LispReader.read(r, false, READ_EOF, Character.valueOf(')'), READ_FINISHED, true, opts, pendingForms, null);
                    if (form2 == READ_EOF) {
                        if (firstline < 0) {
                            throw Util.runtimeException("EOF while reading");
                        }
                        throw Util.runtimeException("EOF while reading, starting at line " + firstline);
                    }
                    if (form2 == READ_FINISHED) break;
                    if (RESERVED_FEATURES.contains(form2)) {
                        throw Util.runtimeException("Feature name " + form2 + " is reserved.");
                    }
                    if (ConditionalReader.hasFeature(form2, opts)) {
                        form2 = LispReader.read(r, false, READ_EOF, Character.valueOf(')'), READ_FINISHED, true, opts, pendingForms, (Resolver)RT.READER_RESOLVER.deref());
                        if (form2 == READ_EOF) {
                            if (firstline < 0) {
                                throw Util.runtimeException("EOF while reading");
                            }
                            throw Util.runtimeException("EOF while reading, starting at line " + firstline);
                        }
                        if (form2 == READ_FINISHED) {
                            if (firstline < 0) {
                                throw Util.runtimeException("read-cond requires an even number of forms.");
                            }
                            throw Util.runtimeException("read-cond starting on line " + firstline + " requires an even number of forms");
                        }
                        result = form2;
                    }
                }
                try {
                    Var.pushThreadBindings(RT.map(RT.SUPPRESS_READ, RT.T));
                    form2 = LispReader.read(r, false, READ_EOF, Character.valueOf(')'), READ_FINISHED, true, opts, pendingForms, (Resolver)RT.READER_RESOLVER.deref());
                    if (form2 == READ_EOF) {
                        if (firstline < 0) {
                            throw Util.runtimeException("EOF while reading");
                        }
                        throw Util.runtimeException("EOF while reading, starting at line " + firstline);
                    }
                    if (form2 != READ_FINISHED) continue;
                }
                finally {
                    Var.popThreadBindings();
                    continue;
                }
                break;
            }
            if (result == READ_STARTED) {
                return r;
            }
            if (splicing) {
                if (!(result instanceof List)) {
                    throw Util.runtimeException("Spliced form list in read-cond-splicing must implement java.util.List");
                }
                if (toplevel) {
                    throw Util.runtimeException("Reader conditional splicing not allowed at the top level.");
                }
                ((List)pendingForms).addAll(0, (List)result);
                return r;
            }
            return result;
        }

        private static void checkConditionalAllowed(Object opts) {
            IPersistentMap mopts = (IPersistentMap)opts;
            if (opts == null || !COND_ALLOW.equals(mopts.valAt(OPT_READ_COND)) && !COND_PRESERVE.equals(mopts.valAt(OPT_READ_COND))) {
                throw Util.runtimeException("Conditional read not allowed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object reader2, Object mode, Object opts, Object pendingForms) {
            ConditionalReader.checkConditionalAllowed(opts);
            PushbackReader r = (PushbackReader)reader2;
            int ch = LispReader.read1(r);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            boolean splicing = false;
            if (ch == 64) {
                splicing = true;
                ch = LispReader.read1(r);
            }
            while (LispReader.isWhitespace(ch)) {
                ch = LispReader.read1(r);
            }
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            if (ch != 40) {
                throw Util.runtimeException("read-cond body must be a list");
            }
            try {
                Var.pushThreadBindings(RT.map(READ_COND_ENV, RT.T));
                if (LispReader.isPreserveReadCond(opts)) {
                    IFn listReader = LispReader.getMacro(ch);
                    Object form2 = listReader.invoke(r, ch, opts, LispReader.ensurePending(pendingForms));
                    ReaderConditional readerConditional = ReaderConditional.create(form2, splicing);
                    return readerConditional;
                }
                Object object = ConditionalReader.readCondDelimited(r, splicing, opts, pendingForms);
                return object;
            }
            finally {
                Var.popThreadBindings();
            }
        }
    }

    public static class CtorReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object firstChar, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            Object name2 = LispReader.read(r, true, null, false, opts, pendingForms = LispReader.ensurePending(pendingForms));
            if (!(name2 instanceof Symbol)) {
                throw new RuntimeException("Reader tag must be a symbol");
            }
            Symbol sym = (Symbol)name2;
            Object form2 = LispReader.read(r, true, null, true, opts, pendingForms);
            if (LispReader.isPreserveReadCond(opts) || RT.suppressRead()) {
                return TaggedLiteral.create(sym, form2);
            }
            return sym.getName().contains(".") ? this.readRecord(form2, sym, opts, pendingForms) : this.readTagged(form2, sym, opts, pendingForms);
        }

        private Object readTagged(Object o, Symbol tag, Object opts, Object pendingForms) {
            ILookup data_readers = (ILookup)RT.DATA_READERS.deref();
            IFn data_reader = (IFn)RT.get(data_readers, tag);
            if (data_reader == null && (data_reader = (IFn)RT.get(data_readers = (ILookup)RT.DEFAULT_DATA_READERS.deref(), tag)) == null) {
                IFn default_reader = (IFn)RT.DEFAULT_DATA_READER_FN.deref();
                if (default_reader != null) {
                    return default_reader.invoke(tag, o);
                }
                throw new RuntimeException("No reader function for tag " + tag.toString());
            }
            return data_reader.invoke(o);
        }

        private Object readRecord(Object form2, Symbol recordName, Object opts, Object pendingForms) {
            boolean readeval = RT.booleanCast(RT.READEVAL.deref());
            if (!readeval) {
                throw Util.runtimeException("Record construction syntax can only be used when *read-eval* == true");
            }
            Class recordClass = RT.classForNameNonLoading(recordName.toString());
            boolean shortForm = true;
            if (form2 instanceof IPersistentMap) {
                shortForm = false;
            } else if (form2 instanceof IPersistentVector) {
                shortForm = true;
            } else {
                throw Util.runtimeException("Unreadable constructor form starting with \"#" + recordName + "\"");
            }
            Object ret = null;
            Constructor<?>[] allctors = recordClass.getConstructors();
            if (shortForm) {
                IPersistentVector recordEntries = (IPersistentVector)form2;
                boolean ctorFound = false;
                for (Constructor<?> ctor : allctors) {
                    if (ctor.getParameterTypes().length != recordEntries.count()) continue;
                    ctorFound = true;
                }
                if (!ctorFound) {
                    throw Util.runtimeException("Unexpected number of constructor arguments to " + recordClass.toString() + ": got " + recordEntries.count());
                }
                ret = Reflector.invokeConstructor(recordClass, RT.toArray(recordEntries));
            } else {
                IPersistentMap vals2 = (IPersistentMap)form2;
                for (ISeq s2 = RT.keys(vals2); s2 != null; s2 = s2.next()) {
                    if (s2.first() instanceof Keyword) continue;
                    throw Util.runtimeException("Unreadable defrecord form: key must be of type clojure.lang.Keyword, got " + s2.first().toString());
                }
                ret = Reflector.invokeStaticMethod(recordClass, "create", new Object[]{vals2});
            }
            return ret;
        }
    }

    public static class UnreadableReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftangle, Object opts, Object pendingForms) {
            throw Util.runtimeException("Unreadable form");
        }
    }

    public static class UnmatchedDelimiterReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object rightdelim, Object opts, Object pendingForms) {
            throw Util.runtimeException("Unmatched delimiter: " + rightdelim);
        }
    }

    public static class SetReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftbracket, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            return PersistentHashSet.createWithCheck(LispReader.readDelimitedList('}', r, true, opts, LispReader.ensurePending(pendingForms)));
        }
    }

    public static class MapReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftparen, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            Object[] a = LispReader.readDelimitedList('}', r, true, opts, LispReader.ensurePending(pendingForms)).toArray();
            if ((a.length & 1) == 1) {
                throw Util.runtimeException("Map literal must contain an even number of forms");
            }
            return RT.map(a);
        }
    }

    public static class VectorReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftparen, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            return LazilyPersistentVector.create(LispReader.readDelimitedList(']', r, true, opts, LispReader.ensurePending(pendingForms)));
        }
    }

    public static class EvalReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object eq, Object opts, Object pendingForms) {
            if (!RT.booleanCast(RT.READEVAL.deref())) {
                throw Util.runtimeException("EvalReader not allowed when *read-eval* is false.");
            }
            PushbackReader r = (PushbackReader)reader2;
            Object o = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
            if (o instanceof Symbol) {
                return RT.classForName(o.toString());
            }
            if (o instanceof IPersistentList) {
                Symbol fs = (Symbol)RT.first(o);
                if (fs.equals(THE_VAR)) {
                    Symbol vs = (Symbol)RT.second(o);
                    return RT.var(vs.ns, vs.name);
                }
                if (fs.name.endsWith(".")) {
                    Object[] args = RT.toArray(RT.next(o));
                    return Reflector.invokeConstructor(RT.classForName(fs.name.substring(0, fs.name.length() - 1)), args);
                }
                if (Compiler.namesStaticMember(fs)) {
                    Object[] args = RT.toArray(RT.next(o));
                    return Reflector.invokeStaticMethod(fs.ns, fs.name, args);
                }
                Object v = Compiler.maybeResolveIn(Compiler.currentNS(), fs);
                if (v instanceof Var) {
                    return ((IFn)v).applyTo(RT.next(o));
                }
                throw Util.runtimeException("Can't resolve " + fs);
            }
            throw new IllegalArgumentException("Unsupported #= form");
        }
    }

    public static class ListReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftparen, Object opts, Object pendingForms) {
            List list;
            PushbackReader r = (PushbackReader)reader2;
            int line = -1;
            int column = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
                column = ((LineNumberingPushbackReader)r).getColumnNumber() - 1;
            }
            if ((list = LispReader.readDelimitedList(')', r, true, opts, LispReader.ensurePending(pendingForms))).isEmpty()) {
                return PersistentList.EMPTY;
            }
            IObj s2 = (IObj)((Object)PersistentList.create(list));
            if (line != -1) {
                Associative meta = RT.meta(s2);
                meta = RT.assoc(meta, RT.LINE_KEY, RT.get(meta, RT.LINE_KEY, line));
                meta = RT.assoc(meta, RT.COLUMN_KEY, RT.get(meta, RT.COLUMN_KEY, column));
                return s2.withMeta((IPersistentMap)meta);
            }
            return s2;
        }
    }

    public static class CharacterReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object backslash, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            int ch = LispReader.read1(r);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            String token = LispReader.readToken(r, (char)ch);
            if (token.length() == 1) {
                return Character.valueOf(token.charAt(0));
            }
            if (token.equals("newline")) {
                return Character.valueOf('\n');
            }
            if (token.equals("space")) {
                return Character.valueOf(' ');
            }
            if (token.equals("tab")) {
                return Character.valueOf('\t');
            }
            if (token.equals("backspace")) {
                return Character.valueOf('\b');
            }
            if (token.equals("formfeed")) {
                return Character.valueOf('\f');
            }
            if (token.equals("return")) {
                return Character.valueOf('\r');
            }
            if (token.startsWith("u")) {
                char c = (char)LispReader.readUnicodeChar(token, 1, 4, 16);
                if (c >= '\ud800' && c <= '\udfff') {
                    throw Util.runtimeException("Invalid character constant: \\u" + Integer.toString(c, 16));
                }
                return Character.valueOf(c);
            }
            if (token.startsWith("o")) {
                int len = token.length() - 1;
                if (len > 3) {
                    throw Util.runtimeException("Invalid octal escape sequence length: " + len);
                }
                int uc = LispReader.readUnicodeChar(token, 1, len, 8);
                if (uc > 255) {
                    throw Util.runtimeException("Octal escape sequence must be in range [0, 377].");
                }
                return Character.valueOf((char)uc);
            }
            throw Util.runtimeException("Unsupported character: \\" + token);
        }
    }

    static class UnquoteReader
    extends AFn {
        UnquoteReader() {
        }

        @Override
        public Object invoke(Object reader2, Object comma, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            int ch = LispReader.read1(r);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            pendingForms = LispReader.ensurePending(pendingForms);
            if (ch == 64) {
                Object o = LispReader.read(r, true, null, true, opts, pendingForms);
                return RT.list(UNQUOTE_SPLICING, o);
            }
            LispReader.unread(r, ch);
            Object o = LispReader.read(r, true, null, true, opts, pendingForms);
            return RT.list(UNQUOTE, o);
        }
    }

    public static class SyntaxQuoteReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object reader2, Object backquote, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            try {
                Var.pushThreadBindings(RT.map(GENSYM_ENV, PersistentHashMap.EMPTY));
                Object form2 = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
                Object object = SyntaxQuoteReader.syntaxQuote(form2);
                return object;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Object syntaxQuote(Object form2) {
            IPersistentMap newMeta;
            Object ret;
            if (Compiler.isSpecial(form2)) {
                ret = RT.list(Compiler.QUOTE, form2);
            } else if (form2 instanceof Symbol) {
                Resolver resolver2 = (Resolver)RT.READER_RESOLVER.deref();
                Symbol sym = (Symbol)form2;
                if (sym.ns == null && sym.name.endsWith("#")) {
                    IPersistentMap gmap = (IPersistentMap)GENSYM_ENV.deref();
                    if (gmap == null) {
                        throw new IllegalStateException("Gensym literal not in syntax-quote");
                    }
                    Symbol gs = (Symbol)gmap.valAt(sym);
                    if (gs == null) {
                        gs = Symbol.intern(null, sym.name.substring(0, sym.name.length() - 1) + "__" + RT.nextID() + "__auto__");
                        GENSYM_ENV.set(gmap.assoc(sym, gs));
                    }
                    sym = gs;
                } else if (sym.ns == null && sym.name.endsWith(".")) {
                    Symbol csym = Symbol.intern(null, sym.name.substring(0, sym.name.length() - 1));
                    if (resolver2 != null) {
                        Symbol rc = resolver2.resolveClass(csym);
                        if (rc != null) {
                            csym = rc;
                        }
                    } else {
                        csym = Compiler.resolveSymbol(csym);
                    }
                    sym = Symbol.intern(null, csym.name.concat("."));
                } else if (sym.ns != null || !sym.name.startsWith(".")) {
                    if (resolver2 != null) {
                        Symbol alias2;
                        Symbol nsym = null;
                        if (sym.ns != null && (nsym = resolver2.resolveClass(alias2 = Symbol.intern(null, sym.ns))) == null) {
                            nsym = resolver2.resolveAlias(alias2);
                        }
                        if (nsym != null) {
                            sym = Symbol.intern(nsym.name, sym.name);
                        } else if (sym.ns == null) {
                            Symbol rsym = resolver2.resolveClass(sym);
                            if (rsym == null) {
                                rsym = resolver2.resolveVar(sym);
                            }
                            sym = rsym != null ? rsym : Symbol.intern(resolver2.currentNS().name, sym.name);
                        }
                    } else {
                        Object maybeClass = null;
                        if (sym.ns != null) {
                            maybeClass = Compiler.currentNS().getMapping(Symbol.intern(null, sym.ns));
                        }
                        sym = maybeClass instanceof Class ? Symbol.intern(((Class)maybeClass).getName(), sym.name) : Compiler.resolveSymbol(sym);
                    }
                }
                ret = RT.list(Compiler.QUOTE, sym);
            } else {
                if (LispReader.isUnquote(form2)) {
                    return RT.second(form2);
                }
                if (LispReader.isUnquoteSplicing(form2)) {
                    throw new IllegalStateException("splice not in list");
                }
                if (form2 instanceof IPersistentCollection) {
                    if (form2 instanceof IRecord) {
                        ret = form2;
                    } else if (form2 instanceof IPersistentMap) {
                        IPersistentVector keyvals = SyntaxQuoteReader.flattenMap(form2);
                        ret = RT.list(APPLY, HASHMAP, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(keyvals.seq()))));
                    } else if (form2 instanceof IPersistentVector) {
                        ret = RT.list(APPLY, VECTOR, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentVector)form2).seq()))));
                    } else if (form2 instanceof IPersistentSet) {
                        ret = RT.list(APPLY, HASHSET, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentSet)form2).seq()))));
                    } else {
                        if (!(form2 instanceof ISeq) && !(form2 instanceof IPersistentList)) throw new UnsupportedOperationException("Unknown Collection type");
                        ISeq seq = RT.seq(form2);
                        ret = seq == null ? RT.cons(LIST, null) : RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(seq)));
                    }
                } else {
                    ret = form2 instanceof Keyword || form2 instanceof Number || form2 instanceof Character || form2 instanceof String ? form2 : RT.list(Compiler.QUOTE, form2);
                }
            }
            if (!(form2 instanceof IObj) || RT.meta(form2) == null || (newMeta = ((IObj)form2).meta().without(RT.LINE_KEY).without(RT.COLUMN_KEY)).count() <= 0) return ret;
            return RT.list(WITH_META, ret, SyntaxQuoteReader.syntaxQuote(((IObj)form2).meta()));
        }

        private static ISeq sqExpandList(ISeq seq) {
            PersistentVector ret = PersistentVector.EMPTY;
            while (seq != null) {
                Object item = seq.first();
                ret = LispReader.isUnquote(item) ? ret.cons(RT.list(LIST, RT.second(item))) : (LispReader.isUnquoteSplicing(item) ? ret.cons(RT.second(item)) : ret.cons(RT.list(LIST, SyntaxQuoteReader.syntaxQuote(item))));
                seq = seq.next();
            }
            return ret.seq();
        }

        private static IPersistentVector flattenMap(Object form2) {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            for (ISeq s2 = RT.seq(form2); s2 != null; s2 = s2.next()) {
                IMapEntry e2 = (IMapEntry)s2.first();
                keyvals = keyvals.cons(e2.key());
                keyvals = keyvals.cons(e2.val());
            }
            return keyvals;
        }
    }

    public static class MetaReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object caret, Object opts, Object pendingForms) {
            Object meta;
            PushbackReader r = (PushbackReader)reader2;
            int line = -1;
            int column = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
                column = ((LineNumberingPushbackReader)r).getColumnNumber() - 1;
            }
            if ((meta = LispReader.read(r, true, null, true, opts, pendingForms = LispReader.ensurePending(pendingForms))) instanceof Symbol || meta instanceof String) {
                meta = RT.map(RT.TAG_KEY, meta);
            } else if (meta instanceof Keyword) {
                meta = RT.map(meta, RT.T);
            } else if (!(meta instanceof IPersistentMap)) {
                throw new IllegalArgumentException("Metadata must be Symbol,Keyword,String or Map");
            }
            Object o = LispReader.read(r, true, null, true, opts, pendingForms);
            if (o instanceof IMeta) {
                if (line != -1 && o instanceof ISeq) {
                    meta = RT.assoc(meta, RT.LINE_KEY, RT.get(meta, RT.LINE_KEY, line));
                    meta = RT.assoc(meta, RT.COLUMN_KEY, RT.get(meta, RT.COLUMN_KEY, column));
                }
                if (o instanceof IReference) {
                    ((IReference)o).resetMeta((IPersistentMap)meta);
                    return o;
                }
                Associative ometa = RT.meta(o);
                for (ISeq s2 = RT.seq(meta); s2 != null; s2 = s2.next()) {
                    IMapEntry kv = (IMapEntry)s2.first();
                    ometa = RT.assoc(ometa, kv.getKey(), kv.getValue());
                }
                return ((IObj)o).withMeta((IPersistentMap)ometa);
            }
            throw new IllegalArgumentException("Metadata can only be applied to IMetas");
        }
    }

    static class ArgReader
    extends AFn {
        ArgReader() {
        }

        @Override
        public Object invoke(Object reader2, Object pct, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            if (ARG_ENV.deref() == null) {
                return LispReader.interpretToken(LispReader.readToken(r, '%'), null);
            }
            int ch = LispReader.read1(r);
            LispReader.unread(r, ch);
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                return LispReader.registerArg(1);
            }
            Object n = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
            if (n.equals(Compiler._AMP_)) {
                return LispReader.registerArg(-1);
            }
            if (!(n instanceof Number)) {
                throw new IllegalStateException("arg literal must be %, %& or %integer");
            }
            return LispReader.registerArg(((Number)n).intValue());
        }
    }

    public static class FnReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object reader2, Object lparen, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            if (ARG_ENV.deref() != null) {
                throw new IllegalStateException("Nested #()s are not allowed");
            }
            try {
                Var.pushThreadBindings(RT.map(ARG_ENV, PersistentTreeMap.EMPTY));
                LispReader.unread(r, 40);
                Object form2 = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
                PersistentVector args = PersistentVector.EMPTY;
                PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
                ISeq rargs = argsyms.rseq();
                if (rargs != null) {
                    Object restsym;
                    int higharg = (Integer)((Map.Entry)rargs.first()).getKey();
                    if (higharg > 0) {
                        for (int i = 1; i <= higharg; ++i) {
                            Object sym = argsyms.valAt(i);
                            if (sym == null) {
                                sym = LispReader.garg(i);
                            }
                            args = args.cons(sym);
                        }
                    }
                    if ((restsym = argsyms.valAt(-1)) != null) {
                        args = args.cons(Compiler._AMP_);
                        args = args.cons(restsym);
                    }
                }
                ISeq iSeq = RT.list(Compiler.FN, args, form2);
                return iSeq;
            }
            finally {
                Var.popThreadBindings();
            }
        }
    }

    public static class DispatchReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object hash2, Object opts, Object pendingForms) {
            int ch = LispReader.read1((Reader)reader2);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            IFn fn2 = dispatchMacros[ch];
            if (fn2 == null) {
                LispReader.unread((PushbackReader)reader2, ch);
                pendingForms = LispReader.ensurePending(pendingForms);
                Object result = ctorReader.invoke(reader2, ch, opts, pendingForms);
                if (result != null) {
                    return result;
                }
                throw Util.runtimeException(String.format("No dispatch macro for: %c", Character.valueOf((char)ch)));
            }
            return fn2.invoke(reader2, ch, opts, pendingForms);
        }
    }

    public static class VarReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object quote, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            Object o = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
            return RT.list(THE_VAR, o);
        }
    }

    public static class DeprecatedWrappingReader
    extends AFn {
        final Symbol sym;
        final String macro;

        public DeprecatedWrappingReader(Symbol sym, String macro) {
            this.sym = sym;
            this.macro = macro;
        }

        @Override
        public Object invoke(Object reader2, Object quote, Object opts, Object pendingForms) {
            System.out.println("WARNING: reader macro " + this.macro + " is deprecated; use " + this.sym.getName() + " instead");
            PushbackReader r = (PushbackReader)reader2;
            Object o = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
            return RT.list(this.sym, o);
        }
    }

    public static class WrappingReader
    extends AFn {
        final Symbol sym;

        public WrappingReader(Symbol sym) {
            this.sym = sym;
        }

        @Override
        public Object invoke(Object reader2, Object quote, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            Object o = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
            return RT.list(this.sym, o);
        }
    }

    public static class SymbolicValueReader
    extends AFn {
        static IPersistentMap specials = PersistentHashMap.create(Symbol.intern("Inf"), Double.POSITIVE_INFINITY, Symbol.intern("-Inf"), Double.NEGATIVE_INFINITY, Symbol.intern("NaN"), Double.NaN);

        @Override
        public Object invoke(Object reader2, Object quote, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            Object o = LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
            if (!(o instanceof Symbol)) {
                throw Util.runtimeException("Invalid token: ##" + o);
            }
            if (!specials.containsKey(o)) {
                throw Util.runtimeException("Unknown symbolic value: ##" + o);
            }
            return specials.valAt(o);
        }
    }

    public static class NamespaceMapReader
    extends AFn {
        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public Object invoke(Object reader2, Object colon, Object opts, Object pendingForms) {
            String ns2;
            PushbackReader r = (PushbackReader)reader2;
            boolean auto = false;
            int autoChar = LispReader.read1(r);
            if (autoChar == 58) {
                auto = true;
            } else {
                LispReader.unread(r, autoChar);
            }
            Object sym = null;
            int nextChar = LispReader.read1(r);
            if (LispReader.isWhitespace(nextChar)) {
                if (!auto) {
                    LispReader.unread(r, nextChar);
                    throw Util.runtimeException("Namespaced map must specify a namespace");
                }
                while (LispReader.isWhitespace(nextChar)) {
                    nextChar = LispReader.read1(r);
                }
                if (nextChar != 123) {
                    LispReader.unread(r, nextChar);
                    throw Util.runtimeException("Namespaced map must specify a namespace");
                }
            } else if (nextChar != 123) {
                LispReader.unread(r, nextChar);
                sym = LispReader.read(r, true, null, false, opts, pendingForms);
                nextChar = LispReader.read1(r);
                while (LispReader.isWhitespace(nextChar)) {
                    nextChar = LispReader.read1(r);
                }
            }
            if (nextChar != 123) {
                throw Util.runtimeException("Namespaced map must specify a map");
            }
            if (auto) {
                Resolver resolver2 = (Resolver)RT.READER_RESOLVER.deref();
                if (sym == null) {
                    ns2 = resolver2 != null ? resolver2.currentNS().name : Compiler.currentNS().getName().getName();
                } else {
                    Symbol resolvedNS;
                    if (!(sym instanceof Symbol) || ((Symbol)sym).getNamespace() != null) {
                        throw Util.runtimeException("Namespaced map must specify a valid namespace: " + sym);
                    }
                    if (resolver2 != null) {
                        resolvedNS = resolver2.resolveAlias((Symbol)sym);
                    } else {
                        Namespace rns = Compiler.currentNS().lookupAlias((Symbol)sym);
                        Symbol symbol2 = resolvedNS = rns != null ? rns.getName() : null;
                    }
                    if (resolvedNS == null) {
                        throw Util.runtimeException("Unknown auto-resolved namespace alias: " + sym);
                    }
                    ns2 = resolvedNS.getName();
                }
            } else {
                if (!(sym instanceof Symbol) || ((Symbol)sym).getNamespace() != null) {
                    throw Util.runtimeException("Namespaced map must specify a valid namespace: " + sym);
                }
                ns2 = ((Symbol)sym).getName();
            }
            List kvs = LispReader.readDelimitedList('}', r, true, opts, LispReader.ensurePending(pendingForms));
            if ((kvs.size() & 1) == 1) {
                throw Util.runtimeException("Namespaced map literal must contain an even number of forms");
            }
            Object[] a = new Object[kvs.size()];
            Iterator iter = kvs.iterator();
            int i = 0;
            while (true) {
                void var15_15;
                Object val2;
                block31: {
                    Object e2;
                    block30: {
                        if (!iter.hasNext()) {
                            return RT.map(a);
                        }
                        e2 = iter.next();
                        val2 = iter.next();
                        if (!(e2 instanceof Keyword)) break block30;
                        Keyword kw = (Keyword)e2;
                        if (kw.getNamespace() == null) {
                            Keyword keyword2 = Keyword.intern(ns2, kw.getName());
                            break block31;
                        } else if (kw.getNamespace().equals("_")) {
                            Keyword keyword3 = Keyword.intern(null, kw.getName());
                        }
                        break block31;
                    }
                    if (e2 instanceof Symbol) {
                        Symbol s2 = (Symbol)e2;
                        if (s2.getNamespace() == null) {
                            Symbol symbol3 = Symbol.intern(ns2, s2.getName());
                        } else if (s2.getNamespace().equals("_")) {
                            Symbol symbol4 = Symbol.intern(null, s2.getName());
                        }
                    }
                }
                a[i] = var15_15;
                a[i + 1] = val2;
                i += 2;
            }
        }
    }

    public static class DiscardReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object underscore, Object opts, Object pendingForms) {
            PushbackReader r = (PushbackReader)reader2;
            LispReader.read(r, true, null, true, opts, LispReader.ensurePending(pendingForms));
            return r;
        }
    }

    public static class CommentReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object semicolon, Object opts, Object pendingForms) {
            int ch;
            Reader r = (Reader)reader2;
            while ((ch = LispReader.read1(r)) != -1 && ch != 10 && ch != 13) {
            }
            return r;
        }
    }

    public static class StringReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object doublequote, Object opts, Object pendingForms) {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader2;
            int ch = LispReader.read1(r);
            while (ch != 34) {
                if (ch == -1) {
                    throw Util.runtimeException("EOF while reading string");
                }
                if (ch == 92) {
                    ch = LispReader.read1(r);
                    if (ch == -1) {
                        throw Util.runtimeException("EOF while reading string");
                    }
                    switch (ch) {
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 117: {
                            ch = LispReader.read1(r);
                            if (Character.digit(ch, 16) == -1) {
                                throw Util.runtimeException("Invalid unicode escape: \\u" + (char)ch);
                            }
                            ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 16, 4, true);
                            break;
                        }
                        default: {
                            if (Character.isDigit(ch)) {
                                if ((ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 8, 3, false)) <= 255) break;
                                throw Util.runtimeException("Octal escape sequence must be in range [0, 377].");
                            }
                            throw Util.runtimeException("Unsupported escape character: \\" + (char)ch);
                        }
                    }
                }
                sb.append((char)ch);
                ch = LispReader.read1(r);
            }
            return sb.toString();
        }
    }

    public static class RegexReader
    extends AFn {
        static StringReader stringrdr = new StringReader();

        @Override
        public Object invoke(Object reader2, Object doublequote, Object opts, Object pendingForms) {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader2;
            int ch = LispReader.read1(r);
            while (ch != 34) {
                if (ch == -1) {
                    throw Util.runtimeException("EOF while reading regex");
                }
                sb.append((char)ch);
                if (ch == 92) {
                    ch = LispReader.read1(r);
                    if (ch == -1) {
                        throw Util.runtimeException("EOF while reading regex");
                    }
                    sb.append((char)ch);
                }
                ch = LispReader.read1(r);
            }
            return Pattern.compile(sb.toString());
        }
    }

    public static class ReaderException
    extends RuntimeException
    implements IExceptionInfo {
        public final int line;
        public final int column;
        public final Object data;
        public static final String ERR_NS = "clojure.error";
        public static final Keyword ERR_LINE = Keyword.intern("clojure.error", "line");
        public static final Keyword ERR_COLUMN = Keyword.intern("clojure.error", "column");

        public ReaderException(int line, int column, Throwable cause) {
            super(cause);
            this.line = line;
            this.column = column;
            this.data = RT.map(ERR_LINE, line, ERR_COLUMN, column);
        }

        @Override
        public IPersistentMap getData() {
            return (IPersistentMap)this.data;
        }
    }

    public static interface Resolver {
        public Symbol currentNS();

        public Symbol resolveClass(Symbol var1);

        public Symbol resolveAlias(Symbol var1);

        public Symbol resolveVar(Symbol var1);
    }
}

