module DF = Dataflow
module UD = Usedef
module IH = Inthash
module E = Errormsg
val debug : bool ref
val ignore_inst : (Cil.instr -> bool) ref
val ignore_call : (Cil.instr -> bool) ref
val registerIgnoreInst : (Cil.instr -> bool) -> unit
val registerIgnoreCall : (Cil.instr -> bool) -> unit
val live_label : string ref
val live_func : string ref
module VS = UD.VS
val debug_print : unit -> VS.t -> Pretty.doc
val min_print : unit -> VS.t -> Pretty.doc
val printer : (unit -> VS.t -> Pretty.doc) ref
module LiveFlow :
  sig
    val name : string
    val debug : bool ref
    type t = VS.t
    val pretty : unit -> VS.t -> Pretty.doc
    val stmtStartData : VS.t IH.t
    val funcExitData : VS.t
    val combineStmtStartData : Cil.stmt -> old:t -> t -> VS.t option
    val combineSuccessors : VS.t -> VS.t -> VS.t
    val doStmt : Cil.stmt -> VS.t DF.action
    val doInstr : Cil.instr -> 'a -> VS.t DF.action
    val filterStmt : 'a -> 'b -> bool
  end
module L : sig val compute : Cil.stmt list -> unit end
val all_stmts : Cil.stmt list ref
class nullAdderClass :
  object
    method queueInstr : Cil.instr list -> unit
    method unqueueInstr : unit -> Cil.instr list
    method vattr : Cil.attribute -> Cil.attribute list Cil.visitAction
    method vattrparam : Cil.attrparam -> Cil.attrparam Cil.visitAction
    method vblock : Cil.block -> Cil.block Cil.visitAction
    method vexpr : Cil.exp -> Cil.exp Cil.visitAction
    method vfunc : Cil.fundec -> Cil.fundec Cil.visitAction
    method vglob : Cil.global -> Cil.global list Cil.visitAction
    method vinit :
      Cil.varinfo -> Cil.offset -> Cil.init -> Cil.init Cil.visitAction
    method vinitoffs : Cil.offset -> Cil.offset Cil.visitAction
    method vinst : Cil.instr -> Cil.instr list Cil.visitAction
    method vlval : Cil.lval -> Cil.lval Cil.visitAction
    method voffs : Cil.offset -> Cil.offset Cil.visitAction
    method vstmt : Cil.stmt -> Cil.stmt Cil.visitAction
    method vtype : Cil.typ -> Cil.typ Cil.visitAction
    method vvdec : Cil.varinfo -> Cil.varinfo Cil.visitAction
    method vvrbl : Cil.varinfo -> Cil.varinfo Cil.visitAction
  end
val null_adder : Cil.fundec -> Cil.stmt list
val computeLiveness : Cil.fundec -> unit
val getLiveSet : int -> VS.t option
val getLiveness : Cil.stmt -> VS.t
val getPostLiveness : Cil.stmt -> LiveFlow.t
val instrLiveness : Cil.instr list -> Cil.stmt -> VS.t -> bool -> VS.t list
class livenessVisitorClass :
  bool ->
  object
    val mutable cur_liv_dat : VS.t option
    val mutable liv_dat_lst : VS.t list
    val mutable sid : int
    method queueInstr : Cil.instr list -> unit
    method unqueueInstr : unit -> Cil.instr list
    method vattr : Cil.attribute -> Cil.attribute list Cil.visitAction
    method vattrparam : Cil.attrparam -> Cil.attrparam Cil.visitAction
    method vblock : Cil.block -> Cil.block Cil.visitAction
    method vexpr : Cil.exp -> Cil.exp Cil.visitAction
    method vfunc : Cil.fundec -> Cil.fundec Cil.visitAction
    method vglob : Cil.global -> Cil.global list Cil.visitAction
    method vinit :
      Cil.varinfo -> Cil.offset -> Cil.init -> Cil.init Cil.visitAction
    method vinitoffs : Cil.offset -> Cil.offset Cil.visitAction
    method vinst : Cil.instr -> Cil.instr list Cil.visitAction
    method vlval : Cil.lval -> Cil.lval Cil.visitAction
    method voffs : Cil.offset -> Cil.offset Cil.visitAction
    method vstmt : Cil.stmt -> Cil.stmt Cil.visitAction
    method vtype : Cil.typ -> Cil.typ Cil.visitAction
    method vvdec : Cil.varinfo -> Cil.varinfo Cil.visitAction
    method vvrbl : Cil.varinfo -> Cil.varinfo Cil.visitAction
  end
class deadnessVisitorClass :
  object
    val mutable cur_liv_dat : VS.t option
    val mutable liv_dat_lst : VS.t list
    val mutable post_dead_vars : VS.t
    val mutable post_live_vars : VS.t
    val mutable sid : int
    method queueInstr : Cil.instr list -> unit
    method unqueueInstr : unit -> Cil.instr list
    method vattr : Cil.attribute -> Cil.attribute list Cil.visitAction
    method vattrparam : Cil.attrparam -> Cil.attrparam Cil.visitAction
    method vblock : Cil.block -> Cil.block Cil.visitAction
    method vexpr : Cil.exp -> Cil.exp Cil.visitAction
    method vfunc : Cil.fundec -> Cil.fundec Cil.visitAction
    method vglob : Cil.global -> Cil.global list Cil.visitAction
    method vinit :
      Cil.varinfo -> Cil.offset -> Cil.init -> Cil.init Cil.visitAction
    method vinitoffs : Cil.offset -> Cil.offset Cil.visitAction
    method vinst : Cil.instr -> Cil.instr list Cil.visitAction
    method vlval : Cil.lval -> Cil.lval Cil.visitAction
    method voffs : Cil.offset -> Cil.offset Cil.visitAction
    method vstmt : Cil.stmt -> Cil.stmt Cil.visitAction
    method vtype : Cil.typ -> Cil.typ Cil.visitAction
    method vvdec : Cil.varinfo -> Cil.varinfo Cil.visitAction
    method vvrbl : Cil.varinfo -> Cil.varinfo Cil.visitAction
  end
val print_everything : unit -> unit
val match_label : Cil.label -> bool
class doFeatureClass :
  object
    method queueInstr : Cil.instr list -> unit
    method unqueueInstr : unit -> Cil.instr list
    method vattr : Cil.attribute -> Cil.attribute list Cil.visitAction
    method vattrparam : Cil.attrparam -> Cil.attrparam Cil.visitAction
    method vblock : Cil.block -> Cil.block Cil.visitAction
    method vexpr : Cil.exp -> Cil.exp Cil.visitAction
    method vfunc : Cil.fundec -> Cil.fundec Cil.visitAction
    method vglob : Cil.global -> Cil.global list Cil.visitAction
    method vinit :
      Cil.varinfo -> Cil.offset -> Cil.init -> Cil.init Cil.visitAction
    method vinitoffs : Cil.offset -> Cil.offset Cil.visitAction
    method vinst : Cil.instr -> Cil.instr list Cil.visitAction
    method vlval : Cil.lval -> Cil.lval Cil.visitAction
    method voffs : Cil.offset -> Cil.offset Cil.visitAction
    method vstmt : Cil.stmt -> Cil.stmt Cil.visitAction
    method vtype : Cil.typ -> Cil.typ Cil.visitAction
    method vvdec : Cil.varinfo -> Cil.varinfo Cil.visitAction
    method vvrbl : Cil.varinfo -> Cil.varinfo Cil.visitAction
  end
val do_live_feature : Cil.file -> unit
val feature : Cil.featureDescr
