/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractBitVector;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Symbol;

public final class ComplexBitVector
extends AbstractBitVector {
    private int fillPointer = -1;
    private boolean isDisplaced;
    private AbstractArray array;
    private int displacement;

    public ComplexBitVector(int capacity) {
        this.capacity = capacity;
        int size = capacity >>> 6;
        if ((capacity & 0x3F) != 0) {
            ++size;
        }
        this.bits = new long[size];
    }

    public ComplexBitVector(int capacity, AbstractArray array, int displacement) {
        this.capacity = capacity;
        this.array = array;
        this.displacement = displacement;
        this.isDisplaced = true;
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.BIT_VECTOR, Fixnum.getInstance(this.capacity));
    }

    @Override
    public boolean hasFillPointer() {
        return this.fillPointer >= 0;
    }

    @Override
    public int getFillPointer() {
        return this.fillPointer;
    }

    @Override
    public void setFillPointer(int n) {
        this.fillPointer = n;
    }

    @Override
    public void setFillPointer(LispObject obj) {
        if (obj == Lisp.T) {
            this.fillPointer = this.capacity();
        } else {
            int n = Fixnum.getValue(obj);
            if (n > this.capacity()) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") exceeds the capacity of the vector (");
                sb.append(this.capacity());
                sb.append(").");
                Lisp.error(new LispError(sb.toString()));
            } else if (n < 0) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") is negative.");
                Lisp.error(new LispError(sb.toString()));
            } else {
                this.fillPointer = n;
            }
        }
    }

    @Override
    public LispObject arrayDisplacement() {
        Fixnum value2;
        LispObject value1;
        if (this.array != null) {
            value1 = this.array;
            value2 = Fixnum.getInstance(this.displacement);
        } else {
            value1 = Lisp.NIL;
            value2 = Fixnum.ZERO;
        }
        return LispThread.currentThread().setValues(value1, value2);
    }

    @Override
    public int length() {
        return this.fillPointer >= 0 ? this.fillPointer : this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        if (index >= this.length()) {
            this.badIndex(index, this.length());
        }
        return this.AREF(index);
    }

    @Override
    public LispObject AREF(int index) {
        if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        }
        if (this.bits != null) {
            int offset = index >> 6;
            return (this.bits[offset] & 1L << index) != 0L ? Fixnum.ONE : Fixnum.ZERO;
        }
        return this.array.AREF(index + this.displacement);
    }

    @Override
    protected int getBit(int index) {
        if (this.bits != null) {
            int offset = index >> 6;
            return (this.bits[offset] & 1L << index) != 0L ? 1 : 0;
        }
        return Fixnum.getValue(this.array.AREF(index + this.displacement));
    }

    @Override
    public void aset(int index, LispObject newValue) {
        if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        }
        if (newValue instanceof Fixnum) {
            switch (((Fixnum)newValue).value) {
                case 0: {
                    if (this.bits != null) {
                        int offset;
                        int n = offset = index >> 6;
                        this.bits[n] = this.bits[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
                    } else {
                        this.clearBit(index);
                    }
                    return;
                }
                case 1: {
                    if (this.bits != null) {
                        int offset;
                        int n = offset = index >> 6;
                        this.bits[n] = this.bits[n] | 1L << index;
                    } else {
                        this.setBit(index);
                    }
                    return;
                }
            }
        }
        Lisp.type_error(newValue, Symbol.BIT);
    }

    @Override
    protected void setBit(int index) {
        if (this.bits != null) {
            int offset;
            int n = offset = index >> 6;
            this.bits[n] = this.bits[n] | 1L << index;
        } else {
            this.array.aset(index + this.displacement, (LispObject)Fixnum.ONE);
        }
    }

    @Override
    protected void clearBit(int index) {
        if (this.bits != null) {
            int offset;
            int n = offset = index >> 6;
            this.bits[n] = this.bits[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            this.array.aset(index + this.displacement, (LispObject)Fixnum.ZERO);
        }
    }

    @Override
    public void shrink(int n) {
        if (this.bits != null) {
            if (n < this.capacity) {
                int size = n >>> 6;
                if ((n & 0x3F) != 0) {
                    ++size;
                }
                if (size < this.bits.length) {
                    long[] newbits = new long[size];
                    System.arraycopy(this.bits, 0, newbits, 0, size);
                    this.bits = newbits;
                }
                this.capacity = n;
                return;
            }
            if (n == this.capacity) {
                return;
            }
        }
        Lisp.error(new LispError());
    }

    @Override
    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public void vectorPushExtend(LispObject element) {
        int fp = this.getFillPointer();
        if (fp < 0) {
            this.noFillPointer();
        }
        if (fp >= this.capacity()) {
            this.ensureCapacity(this.capacity() * 2 + 1);
        }
        this.aset(fp, element);
        this.setFillPointer(fp + 1);
    }

    @Override
    public LispObject VECTOR_PUSH_EXTEND(LispObject element) {
        this.vectorPushExtend(element);
        return Fixnum.getInstance(this.getFillPointer() - 1);
    }

    @Override
    public LispObject VECTOR_PUSH_EXTEND(LispObject element, LispObject extension) {
        int ext = Fixnum.getValue(extension);
        int fp = this.getFillPointer();
        if (fp < 0) {
            this.noFillPointer();
        }
        if (fp >= this.capacity()) {
            ext = Math.max(ext, this.capacity() + 1);
            this.ensureCapacity(this.capacity() + ext);
        }
        this.aset(fp, element);
        this.setFillPointer(fp + 1);
        return Fixnum.getInstance(fp);
    }

    private final void ensureCapacity(int minCapacity) {
        if (this.bits != null) {
            if (this.capacity < minCapacity) {
                int size = minCapacity >>> 6;
                if ((minCapacity & 0x3F) != 0) {
                    ++size;
                }
                long[] newBits = new long[size];
                System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
                this.bits = newBits;
                this.capacity = minCapacity;
            }
        } else {
            Debug.assertTrue(this.array != null);
            if (this.capacity < minCapacity || this.array.getTotalSize() - this.displacement < minCapacity) {
                int size = minCapacity >>> 6;
                if ((minCapacity & 0x3F) != 0) {
                    ++size;
                }
                this.bits = new long[size];
                int limit = Math.min(this.capacity, this.array.getTotalSize() - this.displacement);
                for (int i = 0; i < limit; ++i) {
                    int n = Fixnum.getValue(this.array.AREF(this.displacement + i));
                    if (n == 1) {
                        this.setBit(i);
                        continue;
                    }
                    this.clearBit(i);
                }
                this.capacity = minCapacity;
                this.array = null;
                this.displacement = 0;
                this.isDisplaced = false;
            }
        }
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        int n;
        int i;
        int size;
        if (this.bits == null) {
            size = this.capacity >>> 6;
            if ((this.capacity & 0x3F) != 0) {
                ++size;
            }
            this.bits = new long[size];
            for (i = 0; i < this.capacity; ++i) {
                n = Fixnum.getValue(this.array.AREF(this.displacement + i));
                if (n == 1) {
                    this.setBit(i);
                    continue;
                }
                this.clearBit(i);
            }
            this.array = null;
            this.displacement = 0;
            this.isDisplaced = false;
        }
        if (this.capacity != newCapacity) {
            size = newCapacity >>> 6;
            if ((newCapacity & 0x3F) != 0) {
                ++size;
            }
            if (initialContents != null) {
                this.bits = new long[size];
                this.capacity = newCapacity;
                if (initialContents.listp()) {
                    LispObject list = initialContents;
                    for (int i2 = 0; i2 < newCapacity; ++i2) {
                        this.aset(i2, list.car());
                        list = list.cdr();
                    }
                } else if (initialContents.vectorp()) {
                    for (i = 0; i < newCapacity; ++i) {
                        this.aset(i, initialContents.elt(i));
                    }
                } else {
                    Lisp.type_error(initialContents, Symbol.SEQUENCE);
                }
            } else {
                long[] newBits = new long[size];
                System.arraycopy(this.bits, 0, newBits, 0, Math.min(this.bits.length, newBits.length));
                this.bits = newBits;
                if (newCapacity > this.capacity && initialElement != null) {
                    n = Fixnum.getValue(initialElement);
                    if (n == 1) {
                        for (int i3 = this.capacity; i3 < newCapacity; ++i3) {
                            this.setBit(i3);
                        }
                    } else {
                        for (int i4 = this.capacity; i4 < newCapacity; ++i4) {
                            this.clearBit(i4);
                        }
                    }
                }
            }
            this.capacity = newCapacity;
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int size, AbstractArray displacedTo, int displacement) {
        this.capacity = size;
        this.array = displacedTo;
        this.displacement = displacement;
        this.bits = null;
        this.isDisplaced = true;
        return this;
    }
}

