/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.Serializable;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.PrintNotReadable;
import org.armedbear.lisp.SimpleArray_T;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.StringOutputStream;
import org.armedbear.lisp.Symbol;

public abstract class AbstractArray
extends LispObject
implements Serializable {
    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public boolean equalp(LispObject obj) {
        if (obj instanceof AbstractArray) {
            AbstractArray a = (AbstractArray)obj;
            if (this.getRank() != a.getRank()) {
                return false;
            }
            int i = this.getRank();
            while (i-- > 0) {
                if (this.getDimension(i) == a.getDimension(i)) continue;
                return false;
            }
            i = this.getTotalSize();
            while (i-- > 0) {
                if (this.AREF(i).equalp(a.AREF(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isDisplaced() {
        return false;
    }

    public LispObject arrayDisplacement() {
        return LispThread.currentThread().setValues(Lisp.NIL, Fixnum.ZERO);
    }

    public boolean hasFillPointer() {
        return false;
    }

    public int getFillPointer() {
        this.noFillPointer();
        return -1;
    }

    public void setFillPointer(LispObject fillPointer) {
        this.setFillPointer(fillPointer.intValue());
    }

    public void setFillPointer(int fillPointer) {
        this.noFillPointer();
    }

    public boolean isAdjustable() {
        return true;
    }

    public abstract int getRank();

    public abstract LispObject getDimensions();

    public abstract int getDimension(int var1);

    public abstract LispObject getElementType();

    public abstract int getTotalSize();

    @Override
    public abstract void aset(int var1, LispObject var2);

    protected static final int computeTotalSize(int[] dimensions) {
        int size = 1;
        int i = dimensions.length;
        while (i-- > 0) {
            size *= dimensions[i];
        }
        return size;
    }

    public int getRowMajorIndex(LispObject[] subscripts) {
        int[] subs = new int[subscripts.length];
        for (int i = 0; i < subscripts.length; ++i) {
            LispObject subscript = subscripts[i];
            if (subscript instanceof Fixnum) {
                subs[i] = ((Fixnum)subscript).value;
                continue;
            }
            Lisp.type_error(subscript, Symbol.FIXNUM);
        }
        return this.getRowMajorIndex(subs);
    }

    public int getRowMajorIndex(int[] subscripts) {
        int rank = this.getRank();
        if (rank != subscripts.length) {
            String errorMsg = "Wrong number of subscripts (%d) for array of rank %d.";
            Lisp.program_error(String.format("Wrong number of subscripts (%d) for array of rank %d.", subscripts.length, rank));
        }
        int sum = 0;
        int size = 1;
        int i = rank;
        while (i-- > 0) {
            int dim = this.getDimension(i);
            int lastSize = size;
            size *= dim;
            int n = subscripts[i];
            if (n < 0 || n >= dim) {
                String errorMsg = "Invalid index %d for array %s.";
                Lisp.program_error(String.format("Invalid index %d for array %s.", n, this.printObject()));
            }
            sum += n * lastSize;
        }
        return sum;
    }

    public LispObject get(int[] subscripts) {
        return this.AREF(this.getRowMajorIndex(subscripts));
    }

    public void set(int[] subscripts, LispObject newValue) {
        this.aset(this.getRowMajorIndex(subscripts), newValue);
    }

    public abstract void fill(LispObject var1);

    public String printObject(int[] dimv) {
        StringBuilder sb = new StringBuilder();
        LispThread thread = LispThread.currentThread();
        LispObject printReadably = Symbol.PRINT_READABLY.symbolValue(thread);
        if (printReadably != Lisp.NIL || Symbol.PRINT_ARRAY.symbolValue(thread) != Lisp.NIL) {
            LispObject currentPrintLevel;
            int currentLevel;
            int maxLevel = Integer.MAX_VALUE;
            if (printReadably != Lisp.NIL) {
                for (int i = 0; i < dimv.length - 1; ++i) {
                    if (dimv[i] != 0) continue;
                    for (int j = i + 1; j < dimv.length; ++j) {
                        if (dimv[j] == 0) continue;
                        Lisp.error(new PrintNotReadable(Lisp.list(Keyword.OBJECT, this)));
                        return null;
                    }
                }
            } else {
                LispObject printLevel = Symbol.PRINT_LEVEL.symbolValue(thread);
                if (printLevel instanceof Fixnum) {
                    maxLevel = ((Fixnum)printLevel).value;
                }
            }
            if ((currentLevel = Fixnum.getValue(currentPrintLevel = Lisp._CURRENT_PRINT_LEVEL_.symbolValue(thread))) >= maxLevel) {
                return "#";
            }
            sb.append('#');
            sb.append(dimv.length);
            sb.append('A');
            this.appendContents(dimv, 0, sb, thread);
            return sb.toString();
        }
        sb.append('(');
        if (this instanceof SimpleArray_T) {
            sb.append("SIMPLE-");
        }
        sb.append("ARRAY " + this.getElementType().printObject() + " (");
        for (int i = 0; i < dimv.length; ++i) {
            sb.append(dimv[i]);
            if (i >= dimv.length - 1) continue;
            sb.append(' ');
        }
        sb.append("))");
        return this.unreadableString(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendContents(int[] dimensions, int index, StringBuilder sb, LispThread thread) {
        if (dimensions.length == 0) {
            if (Symbol.PRINT_CIRCLE.symbolValue(thread) != Lisp.NIL) {
                StringOutputStream stream = new StringOutputStream();
                thread.execute(Symbol.OUTPUT_OBJECT.getSymbolFunction(), this.AREF(index), stream);
                sb.append(stream.getString().getStringValue());
            } else {
                sb.append(this.AREF(index).printObject());
            }
        } else {
            LispObject currentPrintLevel;
            int currentLevel;
            LispObject printReadably = Symbol.PRINT_READABLY.symbolValue(thread);
            int maxLength = Integer.MAX_VALUE;
            int maxLevel = Integer.MAX_VALUE;
            if (printReadably == Lisp.NIL) {
                LispObject printLevel;
                LispObject printLength = Symbol.PRINT_LENGTH.symbolValue(thread);
                if (printLength instanceof Fixnum) {
                    maxLength = ((Fixnum)printLength).value;
                }
                if ((printLevel = Symbol.PRINT_LEVEL.symbolValue(thread)) instanceof Fixnum) {
                    maxLevel = ((Fixnum)printLevel).value;
                }
            }
            if ((currentLevel = Fixnum.getValue(currentPrintLevel = Lisp._CURRENT_PRINT_LEVEL_.symbolValue(thread))) < maxLevel) {
                SpecialBindingsMark mark = thread.markSpecialBindings();
                thread.bindSpecial(Lisp._CURRENT_PRINT_LEVEL_, currentPrintLevel.incr());
                try {
                    sb.append('(');
                    int[] dims = new int[dimensions.length - 1];
                    for (int i = 1; i < dimensions.length; ++i) {
                        dims[i - 1] = dimensions[i];
                    }
                    int count = 1;
                    for (int i = 0; i < dims.length; ++i) {
                        count *= dims[i];
                    }
                    int length = dimensions[0];
                    int limit = Math.min(length, maxLength);
                    for (int i = 0; i < limit; ++i) {
                        this.appendContents(dims, index, sb, thread);
                        if (i < limit - 1 || limit < length) {
                            sb.append(' ');
                        }
                        index += count;
                    }
                    if (limit < length) {
                        sb.append("...");
                    }
                    sb.append(')');
                }
                finally {
                    thread.resetSpecialBindings(mark);
                }
            } else {
                sb.append('#');
            }
        }
    }

    @Override
    public int psxhash() {
        long result = 128387L;
        int rank = this.getRank();
        int limit = rank < 4 ? rank : 4;
        for (int i = 0; i < limit; ++i) {
            result = Lisp.mix(result, this.getDimension(i));
        }
        int length = this.getTotalSize();
        limit = length < 4 ? length : 4;
        for (int i = 0; i < length; ++i) {
            result = Lisp.mix(result, this.AREF(i).psxhash());
        }
        return (int)(result & Integer.MAX_VALUE);
    }

    public abstract AbstractArray adjustArray(int[] var1, LispObject var2, LispObject var3);

    public abstract AbstractArray adjustArray(int[] var1, AbstractArray var2, int var3);
}

