/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.bigint;

import java.io.Serializable;
import java.math.BigInteger;
import net.i2p.crypto.eddsa.math.Encoding;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.bigint.BigIntegerFieldElement;

public class BigIntegerLittleEndianEncoding
extends Encoding
implements Serializable {
    private static final long serialVersionUID = 3984579843759837L;
    private BigInteger mask;

    @Override
    public synchronized void setField(Field field) {
        super.setField(field);
        this.mask = BigInteger.ONE.shiftLeft(field.getb() - 1).subtract(BigInteger.ONE);
    }

    @Override
    public byte[] encode(FieldElement fieldElement) {
        return this.encode(((BigIntegerFieldElement)fieldElement).bi.and(this.mask));
    }

    public byte[] encode(BigInteger bigInteger) {
        int n;
        if (this.f == null) {
            throw new IllegalStateException("field not set");
        }
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[this.f.getb() / 8];
        for (n = 0; n < byArray.length; ++n) {
            byArray2[n] = byArray[byArray.length - 1 - n];
        }
        for (n = byArray.length; n < byArray2.length; ++n) {
            byArray2[n] = 0;
        }
        return byArray2;
    }

    @Override
    public FieldElement decode(byte[] byArray) {
        if (this.f == null) {
            throw new IllegalStateException("field not set");
        }
        if (byArray.length != this.f.getb() / 8) {
            throw new IllegalArgumentException("Not a valid encoding");
        }
        return new BigIntegerFieldElement(this.f, this.toBigInteger(byArray).and(this.mask));
    }

    public BigInteger toBigInteger(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - 1 - i];
        }
        return new BigInteger(1, byArray2);
    }

    @Override
    public boolean isNegative(FieldElement fieldElement) {
        return ((BigIntegerFieldElement)fieldElement).bi.testBit(0);
    }
}

