/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui.jfx;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.JComponent;
import org.netbeans.modules.htmlui.impl.HtmlToolkit;
import org.netbeans.modules.htmlui.jfx.NbBrowsers;
import org.openide.DialogDescriptor;
import org.openide.util.Lookup;

public final class JavaFxHtmlToolkit
extends HtmlToolkit {
    static final JavaFxHtmlToolkit INSTANCE = new JavaFxHtmlToolkit();
    private static final Method GET;
    private static final Method ENTER;
    private static final Method EXIT;

    @Override
    public Object initHtmlComponent(JComponent c, final Consumer<String> titleDisplayer) {
        JFXPanel p = (JFXPanel)c;
        Platform.setImplicitExit((boolean)false);
        final WebView webView = new WebView();
        BorderPane bp = new BorderPane();
        Scene scene = new Scene((Parent)bp, (Paint)Color.ALICEBLUE);
        class X
        implements ChangeListener<String>,
        Runnable {
            private String title;

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                this.title = webView.getEngine().getTitle();
                EventQueue.invokeLater(this);
            }

            @Override
            public void run() {
                if (this.title != null) {
                    titleDisplayer.accept(this.title);
                }
            }
        }
        X x = new X();
        webView.getEngine().titleProperty().addListener((ChangeListener)x);
        HtmlToolkit.getDefault().execute(x);
        bp.setCenter((Node)webView);
        p.setScene(scene);
        return webView;
    }

    @Override
    public Object initHtmlDialog(URL url, final DialogDescriptor dd, JComponent ourPanel, Runnable onPageLoad, String[] techIds) {
        JFXPanel p = (JFXPanel)ourPanel;
        Platform.setImplicitExit((boolean)false);
        final WebView webView = new WebView();
        BorderPane bp = new BorderPane();
        Scene scene = new Scene((Parent)bp, (Paint)Color.ALICEBLUE);
        class X
        implements ChangeListener<String>,
        Runnable {
            private String title;

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                this.title = webView.getEngine().getTitle();
                EventQueue.invokeLater(this);
            }

            @Override
            public void run() {
                if (this.title != null) {
                    dd.setTitle(this.title);
                }
            }
        }
        X x = new X();
        webView.getEngine().titleProperty().addListener((ChangeListener)x);
        HtmlToolkit.getDefault().execute(x);
        bp.setCenter((Node)webView);
        p.setScene(scene);
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = JavaFxHtmlToolkit.class.getClassLoader();
        }
        this.load(webView, url, onPageLoad, loader, techIds);
        return webView;
    }

    @Override
    public <C> C convertToComponent(Class<C> type, final URL pageUrl, ClassLoader loader, final Runnable onPageLoad, final List<String> techIds) throws IllegalStateException {
        if (type == Node.class) {
            WebView wv = new WebView();
            this.load(wv, pageUrl, onPageLoad, loader, techIds.toArray());
            return type.cast(wv);
        }
        if (type == JComponent.class) {
            final JFXPanel tmp = new JFXPanel();
            final ClassLoader l = loader;
            HtmlToolkit.getDefault().execute(new Runnable(){

                @Override
                public void run() {
                    WebView wv = new WebView();
                    JavaFxHtmlToolkit.this.load(wv, pageUrl, onPageLoad, l, techIds.toArray());
                    Scene s = new Scene((Parent)wv);
                    tmp.setScene(s);
                }
            });
            return type.cast(tmp);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    @Override
    public void enterNestedLoop(Object impl) {
        try {
            Object tk = GET.invoke(null, new Object[0]);
            ENTER.invoke(tk, impl);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, "enterNestedEventLoop(" + impl + ")", ex);
        }
    }

    @Override
    public void exitNestedLoop(Object impl) {
        try {
            Object tk = GET.invoke(null, new Object[0]);
            EXIT.invoke(tk, impl, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, "exitNestedEventLoop(" + impl + ", null)", ex);
        }
    }

    @Override
    public boolean isApplicationThread() {
        return Platform.isFxApplicationThread();
    }

    @Override
    public JComponent newPanel() {
        return new JFXPanel();
    }

    @Override
    public void load(Object webView, URL pageUrl, Runnable runnable, ClassLoader loader, Object[] ctx) {
        NbBrowsers.load((WebView)webView, pageUrl, runnable, loader, ctx);
    }

    @Override
    public void execute(Runnable command) {
        Platform.runLater((Runnable)command);
    }

    static {
        Method g = null;
        Method n = null;
        Method x = null;
        try {
            Class<?> tC;
            String toolkitCN = "com.sun.javafx.tk.Toolkit";
            try {
                tC = Class.forName("com.sun.javafx.tk.Toolkit");
            }
            catch (ClassNotFoundException ex) {
                tC = Stage.class.getClassLoader().loadClass("com.sun.javafx.tk.Toolkit");
            }
            g = tC.getMethod("getToolkit", new Class[0]);
            n = tC.getMethod("enterNestedEventLoop", Object.class);
            x = tC.getMethod("exitNestedEventLoop", Object.class, Object.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
            HtmlToolkit.LOG.log(Level.SEVERE, "Cannot initialize JavaFX Toolkit access. May cause deadlocks.", ex);
        }
        GET = g;
        ENTER = n;
        EXIT = x;
    }
}

