/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;

public interface ExecutionControl
extends AutoCloseable {
    public void load(ClassBytecodes[] var1) throws ClassInstallException, NotImplementedException, EngineTerminationException;

    public void redefine(ClassBytecodes[] var1) throws ClassInstallException, NotImplementedException, EngineTerminationException;

    public String invoke(String var1, String var2) throws RunException, EngineTerminationException, InternalException;

    public String varValue(String var1, String var2) throws RunException, EngineTerminationException, InternalException;

    public void addToClasspath(String var1) throws EngineTerminationException, InternalException;

    public void stop() throws EngineTerminationException, InternalException;

    public Object extensionCommand(String var1, Object var2) throws RunException, EngineTerminationException, InternalException;

    @Override
    public void close();

    public static ExecutionControl generate(ExecutionEnv env, String name, Map<String, String> parameters) throws Throwable {
        Set<Object> keys = parameters == null ? Collections.emptySet() : parameters.keySet();
        for (ExecutionControlProvider p : ServiceLoader.load(ExecutionControlProvider.class)) {
            if (!p.name().equals(name) || !p.defaultParameters().keySet().containsAll(keys)) continue;
            return p.generate(env, parameters);
        }
        throw new IllegalArgumentException("No ExecutionControlProvider with name '" + name + "' and parameter keys: " + keys.toString());
    }

    public static ExecutionControl generate(ExecutionEnv env, String spec) throws Throwable {
        HashMap<String, String> parameters = new HashMap<String, String>();
        class SpecReader {
            int len;
            int i;
            char ch;
            final /* synthetic */ String val$spec;

            SpecReader(String string) {
                this.val$spec = string;
                this.len = this.val$spec.length();
                this.i = -1;
                this.next();
            }

            boolean more() {
                return this.i < this.len;
            }

            char current() {
                return this.ch;
            }

            final boolean next() {
                ++this.i;
                if (this.i < this.len) {
                    this.ch = this.val$spec.charAt(this.i);
                    return true;
                }
                this.i = this.len;
                return false;
            }

            void skipWhite() {
                while (this.more() && Character.isWhitespace(this.ch)) {
                    this.next();
                }
            }

            String readId() {
                this.skipWhite();
                StringBuilder sb = new StringBuilder();
                while (this.more() && Character.isJavaIdentifierPart(this.ch)) {
                    sb.append(this.ch);
                    this.next();
                }
                this.skipWhite();
                String id = sb.toString();
                if (id.isEmpty()) {
                    throw new IllegalArgumentException("Expected identifier in " + this.val$spec);
                }
                return id;
            }

            void expect(char exp) {
                this.skipWhite();
                if (!this.more() || this.ch != exp) {
                    throw new IllegalArgumentException("Expected '" + exp + "' in " + this.val$spec);
                }
                this.next();
                this.skipWhite();
            }

            String readValue() {
                this.expect('(');
                int parenDepth = 1;
                StringBuilder sb = new StringBuilder();
                while (this.more()) {
                    if (this.ch == ')') {
                        if (--parenDepth == 0) {
                            break;
                        }
                    } else if (this.ch == '(') {
                        ++parenDepth;
                    }
                    sb.append(this.ch);
                    this.next();
                }
                this.expect(')');
                return sb.toString();
            }
        }
        SpecReader sr = new SpecReader(spec);
        String name = sr.readId();
        if (sr.more()) {
            sr.expect(':');
            while (sr.more()) {
                String key = sr.readId();
                String value = sr.readValue();
                parameters.put(key, value);
                if (!sr.more()) continue;
                sr.expect(',');
            }
        }
        return ExecutionControl.generate(env, name, parameters);
    }

    public static class StoppedException
    extends RunException {
        private static final long serialVersionUID = 1L;

        public StoppedException() {
            super("stopped by stop()");
        }
    }

    public static class ResolutionException
    extends RunException {
        private static final long serialVersionUID = 1L;
        private final int id;

        public ResolutionException(int id, StackTraceElement[] stackElements) {
            super("resolution exception: " + id);
            this.id = id;
            this.setStackTrace(stackElements);
        }

        public int id() {
            return this.id;
        }
    }

    public static class UserException
    extends RunException {
        private static final long serialVersionUID = 1L;
        private final String causeExceptionClass;

        public UserException(String message, String causeExceptionClass, StackTraceElement[] stackElements) {
            super(message);
            this.causeExceptionClass = causeExceptionClass;
            this.setStackTrace(stackElements);
        }

        public String causeExceptionClass() {
            return this.causeExceptionClass;
        }
    }

    public static abstract class RunException
    extends ExecutionControlException {
        private static final long serialVersionUID = 1L;

        private RunException(String message) {
            super(message);
        }
    }

    public static class ClassInstallException
    extends ExecutionControlException {
        private static final long serialVersionUID = 1L;
        private final boolean[] installed;

        public ClassInstallException(String message, boolean[] installed) {
            super(message);
            this.installed = installed;
        }

        public boolean[] installed() {
            return this.installed;
        }
    }

    public static class InternalException
    extends ExecutionControlException {
        private static final long serialVersionUID = 1L;

        public InternalException(String message) {
            super(message);
        }
    }

    public static class NotImplementedException
    extends InternalException {
        private static final long serialVersionUID = 1L;

        public NotImplementedException(String message) {
            super(message);
        }
    }

    public static class EngineTerminationException
    extends ExecutionControlException {
        private static final long serialVersionUID = 1L;

        public EngineTerminationException(String message) {
            super(message);
        }
    }

    public static abstract class ExecutionControlException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExecutionControlException(String message) {
            super(message);
        }
    }

    public static final class ClassBytecodes
    implements Serializable {
        private static final long serialVersionUID = 54506481972415973L;
        private final String name;
        private final byte[] bytecodes;

        public ClassBytecodes(String name, byte[] bytecodes) {
            this.name = name;
            this.bytecodes = bytecodes;
        }

        public byte[] bytecodes() {
            return this.bytecodes;
        }

        public String name() {
            return this.name;
        }
    }
}

