/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.core;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeadingParser
extends AbstractBlockParser {
    final Heading block = new Heading();

    public HeadingParser(int level) {
        this.block.setLevel(level);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        inlineParser.parse(this.block.getText(), (Node)this.block);
    }

    @Override
    public void closeBlock(ParserState state) {
    }

    static class HeadingOptions {
        final boolean noAtxSpace;
        final boolean noEmptyHeadingWithoutSpace;
        final boolean noLeadSpace;
        final boolean canInterruptItemParagraph;
        final int setextMarkerLength;

        public HeadingOptions(DataHolder options) {
            this.noAtxSpace = (Boolean)Parser.HEADING_NO_ATX_SPACE.getFrom(options);
            this.noEmptyHeadingWithoutSpace = (Boolean)Parser.HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE.getFrom(options);
            this.noLeadSpace = (Boolean)Parser.HEADING_NO_LEAD_SPACE.getFrom(options);
            this.canInterruptItemParagraph = (Boolean)Parser.HEADING_CAN_INTERRUPT_ITEM_PARAGRAPH.getFrom(options);
            this.setextMarkerLength = (Integer)Parser.HEADING_SETEXT_MARKER_LENGTH.getFrom(options);
        }
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final HeadingOptions options;
        private final HeadingParsing myParsing;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new HeadingOptions(options);
            this.myParsing = new HeadingParsing(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4 || this.options.noLeadSpace && state.getIndent() >= 1) {
                return BlockStart.none();
            }
            if (state.getActiveBlockParser() instanceof FencedCodeBlockParser) {
                return BlockStart.none();
            }
            if (!this.options.canInterruptItemParagraph) {
                boolean inParagraphListItem;
                BlockParser matched = matchedBlockParser.getBlockParser();
                boolean inParagraph = matched.isParagraphParser();
                boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                if (inParagraphListItem) {
                    return BlockStart.none();
                }
            }
            BasedSequence line = state.getLine();
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence paragraph = matchedBlockParser.getParagraphContent();
            BasedSequence trySequence = (BasedSequence)line.subSequence(nextNonSpace, line.length());
            Matcher matcher = this.myParsing.ATX_HEADING.matcher((CharSequence)trySequence);
            if (matcher.find()) {
                int newOffset = nextNonSpace + matcher.group(0).length();
                int openingStart = matcher.start();
                int openingEnd = matcher.end();
                BasedSequence openingMarker = (BasedSequence)((BasedSequence)trySequence.subSequence(openingStart, openingEnd)).trim();
                int level = openingMarker.length();
                BlockContent content = new BlockContent();
                content.add((BasedSequence)state.getLineWithEOL().subSequence(newOffset), state.getIndent());
                BasedSequence headerText = (BasedSequence)trySequence.subSequence(openingEnd);
                BasedSequence closingMarker = null;
                matcher = this.myParsing.ATX_TRAILING.matcher((CharSequence)headerText);
                if (matcher.find()) {
                    int closingStart = matcher.start();
                    int closingEnd = matcher.end();
                    closingMarker = (BasedSequence)((BasedSequence)headerText.subSequence(closingStart, closingEnd)).trim();
                    headerText = (BasedSequence)headerText.subSequence(0, closingStart);
                }
                HeadingParser headingParser = new HeadingParser(level);
                headingParser.block.setOpeningMarker(openingMarker);
                headingParser.block.setText((BasedSequence)headerText.trim());
                headingParser.block.setClosingMarker(closingMarker);
                headingParser.block.setCharsFromContent();
                return BlockStart.of(headingParser).atIndex(line.length());
            }
            matcher = this.myParsing.SETEXT_HEADING.matcher((CharSequence)trySequence);
            if (matcher.find()) {
                if (paragraph != null) {
                    int level = matcher.group(0).charAt(0) == '=' ? 1 : 2;
                    BlockContent content = new BlockContent();
                    content.addAll(matchedBlockParser.getParagraphLines(), matchedBlockParser.getParagraphEolLengths());
                    BasedSequence headingText = (BasedSequence)content.getContents().trim();
                    BasedSequence closingMarker = (BasedSequence)line.trim();
                    HeadingParser headingParser = new HeadingParser(level);
                    headingParser.block.setText(headingText);
                    headingParser.block.setClosingMarker(closingMarker);
                    headingParser.block.setCharsFromContent();
                    return BlockStart.of(headingParser).atIndex(line.length()).replaceActiveBlockParser();
                }
                return BlockStart.none();
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            HashSet<Class<? extends CustomBlockParserFactory>> set = new HashSet<Class<? extends CustomBlockParserFactory>>();
            set.add(BlockQuoteParser.Factory.class);
            return set;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public BlockParserFactory apply(DataHolder options) {
            return new BlockFactory(options);
        }
    }

    static class HeadingParsing
    extends Parsing {
        private final Pattern ATX_HEADING;
        private final Pattern ATX_TRAILING;
        private final Pattern SETEXT_HEADING;

        public HeadingParsing(DataHolder options) {
            super(options);
            this.ATX_HEADING = (Boolean)Parser.HEADING_NO_ATX_SPACE.getFrom(options) != false ? Pattern.compile("^#{1,6}(?:[ \t]*|$)") : ((Boolean)Parser.HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE.getFrom(options) != false ? Pattern.compile("^#{1,6}[ \t]+") : Pattern.compile("^#{1,6}(?:[ \t]+|$)"));
            this.ATX_TRAILING = (Boolean)Parser.HEADING_NO_ATX_SPACE.getFrom(options) != false ? Pattern.compile("[ \t]*#+[ \t]*$") : Pattern.compile("(^| |\t)[ \t]*#+[ \t]*$");
            int minLength = (Integer)Parser.HEADING_SETEXT_MARKER_LENGTH.getFrom(options);
            this.SETEXT_HEADING = minLength <= 1 ? Pattern.compile("^(?:=+|-+)[ \t]*$") : Pattern.compile("^(?:={" + minLength + ",}|-{" + minLength + ",})[ \t]*$");
        }
    }
}

