/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.adm.model.VulnerabilityAuditCollection;
import com.oracle.bmc.adm.requests.ListVulnerabilityAuditsRequest;
import com.oracle.bmc.adm.responses.ListVulnerabilityAuditsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListVulnerabilityAuditsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListVulnerabilityAuditsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListVulnerabilityAuditsRequest interceptRequest(ListVulnerabilityAuditsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListVulnerabilityAuditsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20220421").path("vulnerabilityAudits");
        if (request.getId() != null) {
            target = target.queryParam("id", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getId())});
        }
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        if (request.getKnowledgeBaseId() != null) {
            target = target.queryParam("knowledgeBaseId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getKnowledgeBaseId())});
        }
        if (request.getIsSuccess() != null) {
            target = target.queryParam("isSuccess", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsSuccess())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListVulnerabilityAuditsResponse> fromResponse() {
        Function<Response, ListVulnerabilityAuditsResponse> transformer = new Function<Response, ListVulnerabilityAuditsResponse>(){

            public ListVulnerabilityAuditsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.adm.responses.ListVulnerabilityAuditsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(VulnerabilityAuditCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListVulnerabilityAuditsResponse.Builder builder = ListVulnerabilityAuditsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.vulnerabilityAuditCollection((VulnerabilityAuditCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListVulnerabilityAuditsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

