/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.RunIntoMethodActionSupport;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RunIntoMethodActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener,
ActionsManagerListener {
    private static final Logger logger = Logger.getLogger(RunIntoMethodActionProvider.class.getName());
    private final JPDADebuggerImpl debugger;
    private ActionsManager lastActionsManager;

    public RunIntoMethodActionProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.lastActionsManager != null) {
            this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = null;
        }
    }

    static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    private ActionsManager getActionsManager() {
        ActionsManager current = RunIntoMethodActionProvider.getCurrentActionsManager();
        if (current != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            current.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = current;
        }
        return current;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && this.debugger.getState() == 3 && this.debugger.getCurrentThread() != null && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        if (this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_INTO_METHOD);
    }

    public void doAction(Object action) {
        final String[] methodPtr = new String[1];
        final String[] urlPtr = new String[1];
        final String[] classPtr = new String[1];
        final IllegalComponentStateException[] cnex = new IllegalComponentStateException[]{null};
        final int[] linePtr = new int[1];
        final int[] offsetPtr = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    EditorContext context = EditorContextBridge.getContext();
                    methodPtr[0] = context.getSelectedMethodName();
                    linePtr[0] = context.getCurrentLineNumber();
                    offsetPtr[0] = EditorContextBridge.getCurrentOffset();
                    urlPtr[0] = context.getCurrentURL();
                    try {
                        classPtr[0] = context.getCurrentClassName();
                    }
                    catch (IllegalComponentStateException icsex) {
                        cnex[0] = icsex;
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex.getTargetException());
            return;
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        String method = methodPtr[0];
        if (method.length() < 1) {
            this.debugger.actionMessageCallback(ActionsManager.ACTION_RUN_INTO_METHOD, NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_Put_cursor_on_some_method_call"));
            return;
        }
        int methodLine = linePtr[0];
        int methodOffset = offsetPtr[0];
        String url = urlPtr[0];
        String className = cnex[0] == null ? classPtr[0] : cnex[0].getMessage();
        RunIntoMethodActionSupport.runIntoMethod((JPDADebuggerImpl)this.debugger, (String)url, (String)className, (String)method, (int)methodLine, (int)methodOffset);
    }

    public void actionPerformed(Object action) {
    }

    public void actionStateChanged(Object action, boolean enabled) {
        if (ActionsManager.ACTION_CONTINUE == action) {
            this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, enabled && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        }
    }
}

