/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.angular.index.AngularJsIndexer;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class AngularConfigInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("(.)*\\.config");
    public static final String COMPONENT_PROP = "component";
    public static final String COMPONENTS_PROP = "components";
    public static final String CONTROLLER_SUFFIX = "Controller";
    private static final String COMPONENTS_BASEDIR = "components";

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public Collection<TypeUsage> intercept(Snapshot snapshot, String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (!AngularJsIndexer.isScannerThread()) {
            return Collections.emptyList();
        }
        for (FunctionArgument arg : args) {
            if (arg.getKind() != FunctionArgument.Kind.ARRAY) continue;
            FileObject fo = globalObject.getFileObject();
            TokenHierarchy th = snapshot.getTokenHierarchy();
            TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)arg.getOffset());
            if (ts == null || fo == null) continue;
            AngularConfigInterceptor.saveComponentsToIndex(fo, AngularConfigInterceptor.findComponents((TokenSequence<? extends JsTokenId>)ts, arg.getOffset()));
        }
        return Collections.emptyList();
    }

    public static void saveComponentsToIndex(FileObject fo, Set<String> components) {
        for (String component : components) {
            if (component.isEmpty()) continue;
            Matcher m = Pattern.compile("[A-Z]").matcher(component);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, '-' + m.group().toLowerCase());
            }
            m.appendTail(sb);
            String componentDashName = sb.length() == 0 ? component : sb.toString();
            String templateName = "components/" + componentDashName + "/" + componentDashName + ".html";
            String controllerName = String.valueOf(component.charAt(0)).toUpperCase().concat(component.substring(1)).concat(CONTROLLER_SUFFIX);
            AngularJsIndexer.addTemplateController(fo.toURI(), templateName, controllerName, component);
            AngularJsIndexer.addComponent(fo.toURI(), component);
        }
    }

    public static Set<String> findComponents(TokenSequence<? extends JsTokenId> ts, int offset) {
        if (ts == null || offset == -1) {
            return Collections.emptySet();
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return Collections.emptySet();
        }
        Token token = ts.token();
        if (token.id() != JsTokenId.BRACKET_LEFT_BRACKET) {
            token = LexUtilities.findNextToken(ts, Arrays.asList(JsTokenId.BRACKET_LEFT_BRACKET));
        }
        HashSet<String> result = new HashSet<String>();
        while (token != null && token.id() != JsTokenId.BRACKET_RIGHT_BRACKET) {
            token = LexUtilities.findNextToken(ts, Arrays.asList(JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_BRACKET));
            if (token.id() != JsTokenId.BRACKET_LEFT_CURLY) continue;
            while (token != null && token.id() != JsTokenId.BRACKET_RIGHT_CURLY) {
                token = LexUtilities.findNextToken(ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.BRACKET_RIGHT_CURLY));
                if (token.text().toString().startsWith(COMPONENT_PROP)) {
                    token = LexUtilities.findNextToken(ts, Arrays.asList(JsTokenId.STRING, JsTokenId.BRACKET_LEFT_CURLY));
                    if (token == null) continue;
                    if (token.id() == JsTokenId.STRING) {
                        result.add(token.text().toString());
                        continue;
                    }
                    if (token.id() != JsTokenId.BRACKET_LEFT_CURLY) continue;
                    while (token != null && token.id() != JsTokenId.BRACKET_RIGHT_CURLY) {
                        token = LexUtilities.findNextToken(ts, Arrays.asList(JsTokenId.STRING, JsTokenId.BRACKET_RIGHT_CURLY));
                        if (token != null && token.id() == JsTokenId.STRING) {
                            result.add(token.text().toString());
                        }
                        ts.moveNext();
                    }
                    continue;
                }
                ts.moveNext();
            }
        }
        return result;
    }
}

