/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear.model;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.ApplicationMetadata;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.maven.j2ee.ear.model.ApplicationImpl;
import org.netbeans.modules.maven.j2ee.ear.model.ApplicationMetadataImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class ApplicationMetadataModelImpl
implements MetadataModelImplementation<ApplicationMetadata> {
    private final Application root;
    private final ApplicationMetadata metadata;

    public ApplicationMetadataModelImpl(final Project earProject) {
        Application ddRoot = null;
        FileObject ddFO = this.getDeploymentDescriptor(earProject);
        if (ddFO != null) {
            try {
                ddRoot = DDProvider.getDefault().getDDRoot(ddFO);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        this.root = ddRoot != null ? ddRoot : (Application)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Application>(){

            public Application run() {
                return new ApplicationImpl(earProject);
            }
        });
        this.metadata = new ApplicationMetadataImpl(this.root);
    }

    public <R> R runReadAction(final MetadataModelAction<ApplicationMetadata, R> action) throws MetadataModelException, IOException {
        try {
            return (R)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<R>(){

                public R run() throws Exception {
                    ApplicationMetadataModelImpl.this.enterRunReadAction();
                    try {
                        Object object = action.run((Object)ApplicationMetadataModelImpl.this.metadata);
                        return object;
                    }
                    finally {
                        ApplicationMetadataModelImpl.this.leaveRunReadAction();
                    }
                }
            });
        }
        catch (MutexException mutexException) {
            throw new MetadataModelException((Throwable)mutexException.getException());
        }
    }

    public boolean isReady() {
        return true;
    }

    public <R> Future<R> runReadActionWhenReady(MetadataModelAction<ApplicationMetadata, R> action) throws IOException {
        return new SimpleFuture<R>(this.runReadAction(action));
    }

    private FileObject getDeploymentDescriptor(Project earProject) {
        EarProvider impl = (EarProvider)earProject.getLookup().lookup(EarProvider.class);
        Ear ear = impl.findEar(earProject.getProjectDirectory());
        FileObject ddFO = ear.getDeploymentDescriptor();
        return ddFO;
    }

    private void enterRunReadAction() {
        Application application = this.metadata.getRoot();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).enterRunReadAction();
        }
    }

    private void leaveRunReadAction() {
        Application application = this.metadata.getRoot();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).leaveRunReadAction();
        }
    }

    private static final class SimpleFuture<R>
    implements Future<R> {
        private volatile R result;

        public SimpleFuture(R result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

