/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public final class ZeroBasedIntArray
extends AbstractIntArray {
    private static final ZeroBasedIntArray ZERO_BASED_INT_ARRAY = new ZeroBasedIntArray(0, ZeroBasedIntArray.createCache());

    public static ZeroBasedIntArray makeZeroBasedIntArray(DynamicObject object, int length, int usedLength, int[] array, int integrityLevel) {
        ZeroBasedIntArray arrayType = (ZeroBasedIntArray)ZeroBasedIntArray.createZeroBasedIntArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedIntArray createZeroBasedIntArray() {
        return ZERO_BASED_INT_ARRAY;
    }

    private ZeroBasedIntArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index) {
        return ZeroBasedIntArray.isSupportedZeroBased(object, (int)index);
    }

    @Override
    public int getInBoundsFastInt(DynamicObject object, int index) {
        return ZeroBasedIntArray.getArray(object)[index];
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, int value) {
        ZeroBasedIntArray.getArray((DynamicObject)object)[index] = value;
    }

    @Override
    protected int prepareInBoundsFast(DynamicObject object, long index) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        ZeroBasedIntArray.prepareInBoundsZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        this.prepareSupportedZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected void setLengthLess(DynamicObject object, long length, ScriptArray.ProfileHolder profile) {
        this.setLengthLessZeroBased(object, length, profile);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        return this.toArrayZeroBased(object);
    }

    @Override
    public ZeroBasedDoubleArray toDouble(DynamicObject object, long index, double value) {
        int[] array = ZeroBasedIntArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        double[] doubleCopy = ArrayCopy.intToDouble(array, 0, usedLength);
        ZeroBasedDoubleArray newArray = ZeroBasedDoubleArray.makeZeroBasedDoubleArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ZeroBasedObjectArray toObject(DynamicObject object, long index, Object value) {
        int[] array = ZeroBasedIntArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        Object[] doubleCopy = ArrayCopy.intToObject(array, 0, usedLength);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ContiguousIntArray toContiguous(DynamicObject object, long index, Object value) {
        int[] array = ZeroBasedIntArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        ContiguousIntArray newArray = ContiguousIntArray.makeContiguousIntArray(object, length, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray toHoles(DynamicObject object, long index, Object value) {
        int[] array = ZeroBasedIntArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        AbstractWritableArray newArray = CompilerDirectives.injectBranchProbability((double)1.0E-4, (boolean)ZeroBasedIntArray.containsHoleValue(object)) ? this.toObjectHoles(object) : HolesIntArray.makeHolesIntArray(object, length, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    protected HolesObjectArray toObjectHoles(DynamicObject object) {
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        return HolesObjectArray.makeHolesObjectArray(object, length, ZeroBasedIntArray.convertToObject(object), 0L, 0, usedLength, 0, this.integrityLevel);
    }

    @Override
    public long firstElementIndex(DynamicObject object) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object) {
        return ZeroBasedIntArray.getUsedLength(object) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        int[] array = ZeroBasedIntArray.getArray(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        System.arraycopy(array, (int)end, array, (int)start, Math.max(0, (int)((long)usedLength - end)));
        return this;
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(DynamicObject object) {
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        return usedLength < length;
    }

    @Override
    protected ZeroBasedIntArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedIntArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index) {
        return this.nextElementIndexZeroBased(object, index);
    }
}

