/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.Places;
import org.openide.util.RequestProcessor;

public final class GradleDaemon {
    static final AtomicBoolean initScriptReady = new AtomicBoolean(false);
    static final RequestProcessor GRADLE_LOADER_RP = new RequestProcessor("gradle-project-loader", 1);
    static final String INIT_SCRIPT_NAME = "modules/gradle/nb-tooling.gradle";
    static final String TOOLING_JAR_NAME = "modules/gradle/netbeans-gradle-tooling.jar";
    private static final String PROP_TOOLING_JAR = "NETBEANS_TOOLING_JAR";
    private static final String TOOLING_JAR = InstalledFileLocator.getDefault().locate("modules/gradle/netbeans-gradle-tooling.jar", "org.netbeans.modules.gradle", false).getAbsolutePath().replace("\\", "\\\\");
    private static final String DAEMON_LOADED = "Daemon Loaded.";
    private static final String LOADER_PROJECT_NAME = "modules/gradle/daemon-loader";
    private static final File LOADER_PROJECT_DIR = InstalledFileLocator.getDefault().locate("modules/gradle/daemon-loader", "org.netbeans.modules.gradle", false);
    private static final DummyBuildAction DUMMY_ACTION = new DummyBuildAction();
    private static final Logger LOG = Logger.getLogger(GradleDaemon.class.getName());

    private GradleDaemon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String initScript() {
        File initScript = Places.getCacheSubfile((String)"gradle/nb-tooling.gradle");
        AtomicBoolean atomicBoolean = initScriptReady;
        synchronized (atomicBoolean) {
            if (!initScriptReady.get()) {
                File initTemplate = InstalledFileLocator.getDefault().locate(INIT_SCRIPT_NAME, "org.netbeans.modules.gradle", false);
                try (Stream<String> lines = Files.lines(initTemplate.toPath());){
                    List script = lines.map(line -> line.replace(PROP_TOOLING_JAR, TOOLING_JAR)).collect(Collectors.toList());
                    Files.write(initScript.toPath(), script, new OpenOption[0]);
                    initScriptReady.set(true);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Can't create NetBeans Gradle init script", ex);
                }
            }
        }
        return initScript.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLoadDaemon() {
        GradleConnector gconn = GradleConnector.newConnector();
        ProjectConnection pconn = gconn.forProjectDirectory(LOADER_PROJECT_DIR).connect();
        BuildActionExecuter action = pconn.action((BuildAction)DUMMY_ACTION);
        GradleCommandLine cmd = new GradleCommandLine(new String[0]);
        cmd.setFlag(GradleCommandLine.Flag.OFFLINE, true);
        cmd.addParameter(GradleCommandLine.Parameter.INIT_SCRIPT, GradleDaemon.initScript());
        cmd.configure((ConfigurableLauncher<?>)action);
        try {
            action.run();
        }
        catch (IllegalStateException | GradleConnectionException throwable) {
        }
        finally {
            pconn.close();
        }
    }

    private static class DummyBuildAction
    implements BuildAction<String> {
        private DummyBuildAction() {
        }

        public String execute(BuildController bc) {
            return GradleDaemon.DAEMON_LOADED;
        }
    }

    public static class Loader
    implements Runnable {
        @Override
        public void run() {
            GradleSettings settings = GradleSettings.getDefault();
            GradleDistributionManager dmgr = GradleDistributionManager.get(settings.getGradleUserHome());
            if (settings.isStartDaemonOnStart() && dmgr.defaultDistribution().isAvailable()) {
                GRADLE_LOADER_RP.submit(() -> GradleDaemon.doLoadDaemon());
            }
        }
    }
}

