/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamConstants;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.openide.util.NotImplementedException;

public final class SerParser
implements ObjectStreamConstants {
    private static final boolean DEBUG = Boolean.getBoolean("org.netbeans.modules.clazz.SerParser.DEBUG");
    private final InputStream is;
    private int seq = 0;
    private final List<Object> refs = new ArrayList<Object>(100);
    private int pushback = -1;
    public static final Object NULL = "null";

    public SerParser(InputStream is) {
        this.is = is;
    }

    private int makeRef(Object o) {
        this.refs.add(o);
        int i = this.seq++;
        if (DEBUG) {
            System.err.println("makeRef[" + i + "]=" + o);
        }
        return i;
    }

    private Object getRef(int i) throws CorruptException {
        int idx = i - 0x7E0000;
        if (idx < 0 || idx >= this.seq) {
            throw new CorruptException("Invalid reference: " + i);
        }
        Object o = this.refs.get(idx);
        if (o == null) {
            throw new CorruptException("Invalid reference: " + i);
        }
        return o;
    }

    public Stream parse() throws IOException, CorruptException {
        Stream s = new Stream();
        s.magic = this.readShort();
        s.version = this.readShort();
        if (s.magic != -21267 || s.version != 5) {
            throw new CorruptException("stream version mismatch: " + SerParser.hexify(s.magic) + " != " + SerParser.hexify((short)-21267) + " or " + SerParser.hexify(s.version) + " != " + SerParser.hexify((short)5));
        }
        s.contents = new ArrayList<Object>(10);
        while (this.peek() != -1) {
            s.contents.add(this.readContent());
        }
        if (DEBUG) {
            System.err.println("parsed: " + s);
        }
        return s;
    }

    private int rb() throws IOException {
        if (this.pushback != -1) {
            int c = this.pushback;
            this.pushback = -1;
            return c;
        }
        int c = this.is.read();
        if (DEBUG) {
            System.err.println("read: " + Integer.toHexString(c));
        }
        if (c == -1) {
            throw new EOFException();
        }
        return c;
    }

    private int peek() throws IOException {
        if (this.pushback != -1) {
            throw new IllegalStateException("can only peek once");
        }
        this.pushback = this.is.read();
        if (DEBUG) {
            System.err.println("read: " + Integer.toHexString(this.pushback));
        }
        return this.pushback;
    }

    static String hexify(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        String s = Integer.toHexString(i).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(s, 2);
    }

    static String hexify(short s) {
        int i = s;
        if (i < 0) {
            i += 65536;
        }
        String st = Integer.toHexString(i).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(st, 4);
    }

    static String hexify(int i) {
        String s = Integer.toHexString(i).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(s, 4);
    }

    static String hexify(long l) {
        String s1 = Integer.toHexString((int)((l & 0xFFFFFFFF00000000L) << 32)).toUpperCase(Locale.US);
        String s2 = Integer.toHexString((int)(l & 0xFFFFFFFFL)).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(s1, 4) + SerParser.pad(s2, 4);
    }

    static String hexify(byte[] b) {
        StringBuffer buf = new StringBuffer(2 + b.length * 2);
        buf.append("0x");
        for (int i = 0; i < b.length; ++i) {
            int x = b[i];
            if (x < 0) {
                x += 256;
            }
            buf.append(SerParser.pad(Integer.toHexString(x).toUpperCase(Locale.US), 2));
        }
        return buf.toString();
    }

    private static String pad(String s, int size) {
        int i = s.length();
        if (i == size) {
            return s;
        }
        StringBuffer b = new StringBuffer(size);
        for (int k = 0; k < size - i; ++k) {
            b.append('0');
        }
        b.append(s);
        return b.toString();
    }

    private long readLong() throws IOException {
        long x1 = this.rb();
        long x2 = this.rb();
        long x3 = this.rb();
        long x4 = this.rb();
        long x5 = this.rb();
        long x6 = this.rb();
        long x7 = this.rb();
        long x8 = this.rb();
        long l = (x1 << 56) + (x2 << 48) + (x3 << 40) + (x4 << 32) + (x5 << 24) + (x6 << 16) + (x7 << 8) + x8;
        if (DEBUG) {
            System.err.println("readLong: " + l);
        }
        return l;
    }

    private int readInt() throws IOException {
        int x1 = this.rb();
        int x2 = this.rb();
        int x3 = this.rb();
        int x4 = this.rb();
        int i = (x1 << 24) + (x2 << 16) + (x3 << 8) + x4;
        if (DEBUG) {
            System.err.println("readInt: " + i);
        }
        return i;
    }

    private short readShort() throws IOException {
        int x1 = this.rb();
        int x2 = this.rb();
        short s = (short)((x1 << 8) + x2);
        if (DEBUG) {
            System.err.println("readShort: " + s);
        }
        return s;
    }

    private byte readByte() throws IOException {
        return (byte)this.rb();
    }

    private String readUTF() throws IOException {
        int len = this.readShort();
        if (len < 0) {
            throw new NotImplementedException();
        }
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = this.readByte();
        }
        String s = new String(buf, StandardCharsets.UTF_8);
        if (DEBUG) {
            System.err.println("readUTF: " + s);
        }
        return s;
    }

    private Object readContent() throws IOException {
        byte tc = this.readByte();
        switch (tc) {
            case 115: {
                return this.readNewObject();
            }
            case 118: {
                return this.readNewClass();
            }
            case 117: {
                return this.readNewArray();
            }
            case 114: {
                return this.readNewClassDesc();
            }
            case 125: {
                throw new NotImplementedException("TC_PROXYCLASSDESC");
            }
            case 116: {
                return this.readNewString();
            }
            case 124: {
                throw new NotImplementedException("TC_LONGSTRING");
            }
            case 113: {
                return this.readReference();
            }
            case 112: {
                return NULL;
            }
            case 123: {
                throw new NotImplementedException("TC_EXCEPTION");
            }
            case 121: {
                throw new NotImplementedException("TC_RESET");
            }
            case 119: {
                return this.readBlockData();
            }
            case 122: {
                return this.readBlockDataLong();
            }
        }
        throw new CorruptException("Unknown typecode: " + SerParser.hexify(tc));
    }

    private ObjectWrapper readNewObject() throws IOException {
        ObjectWrapper ow = new ObjectWrapper();
        ow.classdesc = this.readClassDesc();
        this.makeRef(ow);
        ow.data = new ArrayList<Object>(10);
        LinkedList<ClassDesc> hier = new LinkedList<ClassDesc>();
        ClassDesc cd = ow.classdesc;
        while (cd != null) {
            hier.addFirst(cd);
            cd = cd.superclass;
        }
        for (ClassDesc cd2 : hier) {
            if (cd2.serializable) {
                ow.data.addAll(this.readNoWrClass(cd2));
                if (!cd2.writeMethod) continue;
                ow.data.addAll(this.readContents());
                continue;
            }
            if (cd2.blockData) {
                ow.data.addAll(this.readContents());
                continue;
            }
            ow.data.add(this.readContent());
        }
        if (DEBUG) {
            System.err.println("readNewObject: " + ow);
        }
        return ow;
    }

    private ClassDesc readClassDesc() throws IOException {
        Object o = this.readContent();
        if (o instanceof ClassDesc) {
            return (ClassDesc)o;
        }
        if (o == NULL) {
            return null;
        }
        throw new CorruptException("Expected class desc, got: " + o);
    }

    private ClassDesc readNewClass() throws IOException {
        ClassDesc cd = this.readClassDesc();
        this.makeRef(cd);
        return cd;
    }

    private ClassDesc readNewClassDesc() throws IOException {
        ClassDesc cd = new ClassDesc();
        cd.name = this.readUTF();
        if (!(cd.name.startsWith("[") || cd.name.length() == 1 && "BSIJFDCZ".indexOf(cd.name) != -1 || cd.name.endsWith(";"))) {
            cd.name = "L" + cd.name + ";";
        }
        cd.svuid = this.readLong();
        this.makeRef(cd);
        byte cdf = this.readByte();
        cd.writeMethod = (cdf & 1) != 0;
        cd.blockData = (cdf & 8) != 0;
        cd.serializable = (cdf & 2) != 0;
        cd.externalizable = (cdf & 4) != 0;
        int count = this.readShort();
        cd.fields = new ArrayList<FieldDesc>(count);
        for (int i = 0; i < count; ++i) {
            cd.fields.add(this.readFieldDesc());
        }
        cd.annotation = this.readContents();
        cd.superclass = this.readClassDesc();
        if (DEBUG) {
            System.err.println("readNewClassDesc: " + cd);
        }
        return cd;
    }

    private FieldDesc readFieldDesc() throws IOException {
        FieldDesc fd;
        char tc = (char)this.readByte();
        switch (tc) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                fd = new FieldDesc();
                fd.type = new String(new char[]{tc});
                break;
            }
            case '[': {
                fd = new ObjFieldDesc();
                ((ObjFieldDesc)fd).array = true;
                break;
            }
            case 'L': {
                fd = new ObjFieldDesc();
                ((ObjFieldDesc)fd).array = false;
                break;
            }
            default: {
                throw new CorruptException("Strange field type: " + tc);
            }
        }
        fd.name = this.readUTF();
        if (fd instanceof ObjFieldDesc) {
            String clazz;
            fd.type = clazz = (String)this.readContent();
        }
        if (DEBUG) {
            System.err.println("readFieldDesc: " + fd);
        }
        return fd;
    }

    private List<Object> readContents() throws IOException {
        ArrayList<Object> l = new ArrayList<Object>(10);
        while (this.peek() != 120) {
            l.add(this.readContent());
        }
        if (this.readByte() != 120) {
            throw new IllegalStateException();
        }
        if (DEBUG) {
            System.err.println("readContents: " + l);
        }
        return l;
    }

    private ArrayWrapper readNewArray() throws IOException {
        ArrayWrapper aw = new ArrayWrapper();
        aw.classdesc = this.readClassDesc();
        this.makeRef(aw);
        int size = this.readInt();
        if (size < 0) {
            throw new NotImplementedException();
        }
        aw.values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            if (aw.classdesc.name.equals("[B")) {
                aw.values.add(this.readByte());
                continue;
            }
            if (aw.classdesc.name.equals("[S")) {
                aw.values.add(this.readShort());
                continue;
            }
            if (aw.classdesc.name.equals("[I")) {
                aw.values.add(new Integer(this.readInt()));
                continue;
            }
            if (aw.classdesc.name.equals("[J")) {
                aw.values.add(new Long(this.readLong()));
                continue;
            }
            if (aw.classdesc.name.equals("[F")) {
                aw.values.add(Float.valueOf(Float.intBitsToFloat(this.readInt())));
                continue;
            }
            if (aw.classdesc.name.equals("[D")) {
                aw.values.add(new Double(Double.longBitsToDouble(this.readLong())));
                continue;
            }
            if (aw.classdesc.name.equals("[C")) {
                aw.values.add(new Character((char)this.readShort()));
                continue;
            }
            if (aw.classdesc.name.equals("[Z")) {
                aw.values.add(this.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE);
                continue;
            }
            aw.values.add(this.readContent());
        }
        if (DEBUG) {
            System.err.println("readNewArray: " + aw);
        }
        return aw;
    }

    private String readNewString() throws IOException {
        String s = this.readUTF();
        this.makeRef(s);
        return s;
    }

    private Object readReference() throws IOException {
        int i = this.readInt();
        Object r = this.getRef(i);
        if (DEBUG) {
            System.err.println("readReference: " + r);
        }
        return r;
    }

    private byte[] readBlockData() throws IOException {
        int size = this.readByte();
        if (size < 0) {
            size += 256;
        }
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = this.readByte();
        }
        if (DEBUG) {
            System.err.println("readBlockData: " + size + " bytes");
        }
        return b;
    }

    private byte[] readBlockDataLong() throws IOException {
        int size = this.readInt();
        if (size < 0) {
            throw new NotImplementedException();
        }
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = this.readByte();
        }
        if (DEBUG) {
            System.err.println("readBlockDataLong: " + size + " bytes");
        }
        return b;
    }

    private List<NameValue> readNoWrClass(ClassDesc cd) throws IOException {
        List<FieldDesc> fields = cd.fields;
        ArrayList<NameValue> values = new ArrayList<NameValue>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            FieldDesc fd = fields.get(i);
            if (fd.type.equals("B")) {
                values.add(new NameValue(fd, this.readByte()));
                continue;
            }
            if (fd.type.equals("S")) {
                values.add(new NameValue(fd, this.readShort()));
                continue;
            }
            if (fd.type.equals("I")) {
                values.add(new NameValue(fd, new Integer(this.readInt())));
                continue;
            }
            if (fd.type.equals("J")) {
                values.add(new NameValue(fd, new Long(this.readLong())));
                continue;
            }
            if (fd.type.equals("F")) {
                values.add(new NameValue(fd, Float.valueOf(Float.intBitsToFloat(this.readInt()))));
                continue;
            }
            if (fd.type.equals("D")) {
                values.add(new NameValue(fd, new Double(Double.longBitsToDouble(this.readLong()))));
                continue;
            }
            if (fd.type.equals("C")) {
                values.add(new NameValue(fd, new Character((char)this.readShort())));
                continue;
            }
            if (fd.type.equals("Z")) {
                values.add(new NameValue(fd, this.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE));
                continue;
            }
            values.add(new NameValue(fd, this.readContent()));
        }
        if (DEBUG) {
            System.err.println("readNoWrClass: " + values);
        }
        return values;
    }

    public static final class ArrayWrapper {
        public ClassDesc classdesc;
        public List<Object> values;

        public String toString() {
            return this.classdesc.name + "{" + this.values + "}";
        }
    }

    public static final class ObjFieldDesc
    extends FieldDesc {
        public boolean array;

        @Override
        public String toString() {
            return "Field[name=" + this.name + ",type=" + this.type + (this.array ? "[]" : "") + "]";
        }
    }

    public static class FieldDesc {
        public String name;
        public String type;

        public String toString() {
            return "Field[name=" + this.name + ",type=" + this.type + "]";
        }
    }

    public static final class ClassDesc {
        public String name;
        public long svuid;
        public boolean writeMethod;
        public boolean blockData;
        public boolean serializable;
        public boolean externalizable;
        public List<FieldDesc> fields;
        public List annotation;
        public ClassDesc superclass;

        public String toString() {
            return "Class[name=" + this.name + "]";
        }
    }

    public static final class NameValue {
        public final FieldDesc name;
        public final Object value;

        public NameValue(FieldDesc name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name.toString() + "=" + this.value.toString();
        }
    }

    public static final class ObjectWrapper {
        public ClassDesc classdesc;
        public List<Object> data;

        public String toString() {
            return "Object[class=" + this.classdesc.name + ",data=<omitted>]";
        }
    }

    public static final class Stream {
        public short magic;
        public short version;
        public List<Object> contents;

        public String toString() {
            return "Stream[contents=" + this.contents + "]";
        }
    }

    public static final class CorruptException
    extends IOException {
        public CorruptException() {
        }

        public CorruptException(String m) {
            super(m);
        }
    }
}

