/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.StandardTagNamespaceTemplate;
import com.oracle.bmc.identity.requests.GetStandardTagTemplateRequest;
import com.oracle.bmc.identity.responses.GetStandardTagTemplateResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStandardTagTemplateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetStandardTagTemplateConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetStandardTagTemplateRequest interceptRequest(GetStandardTagTemplateRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetStandardTagTemplateRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getStandardTagNamespaceName(), (String)"standardTagNamespaceName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("tags").path("standardTagNamespaceTemplates").path(HttpUtils.encodePathSegment((String)request.getStandardTagNamespaceName()));
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetStandardTagTemplateResponse> fromResponse() {
        Function<Response, GetStandardTagTemplateResponse> transformer = new Function<Response, GetStandardTagTemplateResponse>(){

            public GetStandardTagTemplateResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.GetStandardTagTemplateResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(StandardTagNamespaceTemplate.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetStandardTagTemplateResponse.Builder builder = GetStandardTagTemplateResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.standardTagNamespaceTemplate((StandardTagNamespaceTemplate)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetStandardTagTemplateResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

