/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;

public abstract class NbiTreeTableModel
implements TableModel {
    private Vector<TableModelListener> listeners = new Vector();
    private TreeModel treeModel;
    private JTree tree;
    private TreeExpansionListener treeExpansionListener;
    private TreeModelListener treeModelListener;
    private boolean consumeNextExpansionEvent = false;

    public NbiTreeTableModel(TreeModel treeModel) {
        this.setTreeModel(treeModel);
    }

    public abstract int getTreeColumnIndex();

    public final TreeModel getTreeModel() {
        return this.treeModel;
    }

    final void setTreeModel(TreeModel treeModel) {
        this.removeTreeModelListener();
        this.treeModel = treeModel;
        this.addTreeModelListener();
    }

    public final JTree getTree() {
        return this.tree;
    }

    final void setTree(JTree tree) {
        this.removeTreeExpansionListener();
        this.tree = tree;
        this.addTreeExpansionListener();
    }

    final void consumeNextExpansionEvent() {
        this.consumeNextExpansionEvent = true;
    }

    final void cancelConsume() {
        this.consumeNextExpansionEvent = false;
    }

    @Override
    public final int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public abstract Class<?> getColumnClass(int var1);

    @Override
    public abstract boolean isCellEditable(int var1, int var2);

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public abstract void setValueAt(Object var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener listener) {
        Vector<TableModelListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener listener) {
        Vector<TableModelListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(listener);
        }
    }

    protected void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableDataChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    protected void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableDataChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    protected void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableDataChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    private void removeTreeModelListener() {
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
    }

    private void addTreeModelListener() {
        if (this.treeModelListener == null) {
            this.treeModelListener = new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent event) {
                    NbiTreeTableModel.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent event) {
                    NbiTreeTableModel.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent event) {
                    NbiTreeTableModel.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent event) {
                    NbiTreeTableModel.this.delayedFireTableDataChanged();
                }
            };
        }
        this.treeModel.addTreeModelListener(this.treeModelListener);
    }

    private void removeTreeExpansionListener() {
        if (this.tree != null) {
            this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        }
    }

    private void addTreeExpansionListener() {
        if (this.treeExpansionListener == null) {
            this.treeExpansionListener = new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    if (NbiTreeTableModel.this.consumeNextExpansionEvent) {
                        NbiTreeTableModel.this.consumeNextExpansionEvent = false;
                        return;
                    }
                    int row = NbiTreeTableModel.this.tree.getRowForPath(event.getPath());
                    int childrenCount = NbiTreeTableModel.this.treeModel.getChildCount(event.getPath().getLastPathComponent());
                    NbiTreeTableModel.this.fireTableRowsDeleted(row + 1, row + childrenCount);
                    NbiTreeTableModel.this.fireTableRowsUpdated(row, row);
                }

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    if (NbiTreeTableModel.this.consumeNextExpansionEvent) {
                        NbiTreeTableModel.this.consumeNextExpansionEvent = false;
                        return;
                    }
                    int row = NbiTreeTableModel.this.tree.getRowForPath(event.getPath());
                    int childrenCount = NbiTreeTableModel.this.treeModel.getChildCount(event.getPath().getLastPathComponent());
                    NbiTreeTableModel.this.fireTableRowsInserted(row + 1, row + childrenCount);
                    NbiTreeTableModel.this.fireTableRowsUpdated(row, row);
                }
            };
        }
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
    }

    private void fireTableDataChanged(TableModelEvent event) {
        for (TableModelListener listener : this.listeners.toArray(new TableModelListener[0])) {
            listener.tableChanged(event);
        }
    }

    private void fireTableDataChanged() {
        this.fireTableDataChanged(new TableModelEvent(this));
    }

    private void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbiTreeTableModel.this.fireTableDataChanged();
            }
        });
    }
}

