/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDeploymentRequest
extends BmcRequest<Void> {
    private String deploymentId;
    private String opcRequestId;

    @ConstructorProperties(value={"deploymentId", "opcRequestId"})
    GetDeploymentRequest(String deploymentId, String opcRequestId) {
        this.deploymentId = deploymentId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetDeploymentRequest(super=" + super.toString() + ", deploymentId=" + this.getDeploymentId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDeploymentRequest)) {
            return false;
        }
        GetDeploymentRequest other = (GetDeploymentRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$deploymentId = this.getDeploymentId();
        String other$deploymentId = other.getDeploymentId();
        if (this$deploymentId == null ? other$deploymentId != null : !this$deploymentId.equals(other$deploymentId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDeploymentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $deploymentId = this.getDeploymentId();
        result = result * 59 + ($deploymentId == null ? 43 : $deploymentId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDeploymentRequest, Void> {
        private String deploymentId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDeploymentRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDeploymentRequest build() {
            GetDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDeploymentRequest buildWithoutInvocationCallback() {
            return new GetDeploymentRequest(this.deploymentId, this.opcRequestId);
        }

        public String toString() {
            return "GetDeploymentRequest.Builder(deploymentId=" + this.deploymentId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

