/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class UnusedUsesCollector
extends DefaultVisitor {
    private static final String NAMESPACE_SEPARATOR = "\\";
    private final PHPParseResult parserResult;
    private final Map<String, UnusedOffsetRanges> unusedUsesOffsetRanges;

    public UnusedUsesCollector(PHPParseResult parserResult) {
        assert (parserResult != null);
        this.parserResult = parserResult;
        this.unusedUsesOffsetRanges = new HashMap<String, UnusedOffsetRanges>();
    }

    public Collection<UnusedOffsetRanges> collect() {
        Program program = this.parserResult.getProgram();
        if (program != null) {
            program.accept(this);
        }
        return this.unusedUsesOffsetRanges.values();
    }

    @Override
    public void visit(Program program) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        this.scan(program.getStatements());
        this.scan(program.getComments());
    }

    @Override
    public void visit(PHPDocTypeNode node) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        QualifiedName typeName = QualifiedName.create(node.getValue());
        if (this.unusedUsesOffsetRanges.size() > 0 && !typeName.getKind().isFullyQualified()) {
            String firstSegmentName = typeName.getSegments().getFirst();
            this.processFirstSegmentName(firstSegmentName);
        }
    }

    @Override
    public void visit(NamespaceName node) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        if (this.unusedUsesOffsetRanges.size() > 0 && !node.isGlobal()) {
            Identifier firstSegment = node.getSegments().get(0);
            String firstSegmentName = firstSegment.getName();
            this.processFirstSegmentName(firstSegmentName);
        }
    }

    private void processFirstSegmentName(String firstSegmentName) {
        HashSet<String> namesToRemove = new HashSet<String>();
        for (String name : this.unusedUsesOffsetRanges.keySet()) {
            QualifiedName qualifiedUseName = QualifiedName.create(name);
            if (!qualifiedUseName.getSegments().getLast().equals(firstSegmentName)) continue;
            namesToRemove.add(name);
        }
        this.unusedUsesOffsetRanges.keySet().removeAll(namesToRemove);
    }

    @Override
    public void visit(UseStatement node) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        List<UseStatementPart> parts = node.getParts();
        if (parts.size() == 1 && parts.get(0) instanceof SingleUseStatementPart) {
            String correctName = this.getCorrectName((SingleUseStatementPart)parts.get(0));
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            this.unusedUsesOffsetRanges.put(correctName, new UnusedOffsetRanges(offsetRange, offsetRange));
        } else {
            this.processUseStatementsParts(parts);
        }
    }

    private String getCorrectName(SingleUseStatementPart useStatementPart) {
        String identifierName;
        Identifier alias = useStatementPart.getAlias();
        if (alias != null) {
            identifierName = alias.getName();
        } else {
            NamespaceName name = useStatementPart.getName();
            identifierName = CodeUtils.extractQualifiedName(name);
            if (name.isGlobal()) {
                identifierName = NAMESPACE_SEPARATOR + identifierName;
            }
        }
        return identifierName;
    }

    private void processUseStatementsParts(List<UseStatementPart> parts) {
        int lastStartOffset = -1;
        int partsSize = parts.size();
        for (int i = 0; i < partsSize; ++i) {
            int endOffset;
            UseStatementPart useStatementPart = parts.get(i);
            if (useStatementPart instanceof SingleUseStatementPart) {
                SingleUseStatementPart singleUseStatementPart = (SingleUseStatementPart)useStatementPart;
                if (lastStartOffset == -1) {
                    lastStartOffset = singleUseStatementPart.getStartOffset();
                }
                endOffset = singleUseStatementPart.getEndOffset();
                this.processSingleUseStatementPart(singleUseStatementPart, lastStartOffset, endOffset);
                lastStartOffset = singleUseStatementPart.getEndOffset();
                continue;
            }
            if (useStatementPart instanceof GroupUseStatementPart) {
                GroupUseStatementPart groupUseStatementPart = (GroupUseStatementPart)useStatementPart;
                List<SingleUseStatementPart> items = groupUseStatementPart.getItems();
                if (items.isEmpty()) continue;
                if (lastStartOffset == -1) {
                    lastStartOffset = items.get(0).getStartOffset();
                }
                for (SingleUseStatementPart item : items) {
                    endOffset = item.getEndOffset();
                    this.processSingleUseStatementPart(item, lastStartOffset, endOffset);
                    lastStartOffset = item.getEndOffset();
                }
                continue;
            }
            assert (false) : "Unexpected class type: " + useStatementPart.getClass().getName();
        }
    }

    private void processSingleUseStatementPart(SingleUseStatementPart singleUseStatementPart, int replaceStartOffset, int replaceEndOffset) {
        String correctName = this.getCorrectName(singleUseStatementPart);
        OffsetRange rangeToVisualise = new OffsetRange(singleUseStatementPart.getStartOffset(), singleUseStatementPart.getEndOffset());
        OffsetRange rangeToReplace = new OffsetRange(replaceStartOffset, replaceEndOffset);
        this.unusedUsesOffsetRanges.put(correctName, new UnusedOffsetRanges(rangeToVisualise, rangeToReplace));
    }

    public static final class UnusedOffsetRanges {
        private final OffsetRange rangeToVisualise;
        private final OffsetRange rangeToReplace;

        private UnusedOffsetRanges(OffsetRange rangeToVisualise, OffsetRange rangeToReplace) {
            this.rangeToVisualise = rangeToVisualise;
            this.rangeToReplace = rangeToReplace;
        }

        public OffsetRange getRangeToVisualise() {
            return this.rangeToVisualise;
        }

        public OffsetRange getRangeToReplace() {
            return this.rangeToReplace;
        }
    }
}

