/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Collection;
import java.util.Comparator;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameters;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileEnumDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.util.DefaultList;

public class InitEnumVisitor
extends AbstractJavaSyntaxVisitor {
    protected ClassFileBodyDeclaration bodyDeclaration = null;
    protected BodyDeclaration constantBodyDeclaration = null;
    protected DefaultList<ClassFileEnumDeclaration.ClassFileConstant> constants = new DefaultList();
    protected int lineNumber;
    protected int index;
    protected BaseExpression arguments;

    public DefaultList<EnumDeclaration.Constant> getConstants() {
        if (!this.constants.isEmpty()) {
            this.constants.sort(new EnumConstantComparator());
        }
        return new DefaultList<EnumDeclaration.Constant>((Collection<EnumDeclaration.Constant>)this.constants);
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bd = this.bodyDeclaration;
        this.bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.constants.clear();
        this.safeAcceptListDeclaration(this.bodyDeclaration.getFieldDeclarations());
        this.safeAcceptListDeclaration(this.bodyDeclaration.getMethodDeclarations());
        this.bodyDeclaration = bd;
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
        if (cfcd.getStatements().getClass() == Statements.class) {
            Statements statements = (Statements)cfcd.getStatements();
            if (statements.size() == 1) {
                cfcd.setFlags(4096);
            } else {
                FormalParameters parameters = (FormalParameters)cfcd.getFormalParameters();
                parameters.subList(0, 2).clear();
                statements.remove(0);
                cfcd.setFlags(0);
            }
        } else {
            cfcd.setFlags(4096);
        }
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        if ((declaration.getFlags() & 9) != 0 && (declaration.getName().equals("values") || declaration.getName().equals("valueOf"))) {
            ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)declaration;
            cfmd.setFlags(cfmd.getFlags() | 0x1000);
        }
    }

    @Override
    public void visit(FieldDeclaration declaration) {
        if ((declaration.getFlags() & 0x4000) != 0) {
            ClassFileFieldDeclaration cffd = (ClassFileFieldDeclaration)declaration;
            cffd.getFieldDeclarators().accept(this);
            cffd.setFlags(cffd.getFlags() | 0x1000);
        }
    }

    @Override
    public void visit(FieldDeclarator declaration) {
        this.constantBodyDeclaration = null;
        this.safeAccept(declaration.getVariableInitializer());
        this.constants.add(new ClassFileEnumDeclaration.ClassFileConstant(this.lineNumber, declaration.getName(), this.index, this.arguments, this.constantBodyDeclaration));
    }

    @Override
    public void visit(NewExpression expression) {
        ClassFileTypeDeclaration typeDeclaration;
        Expressions parameters = (Expressions)expression.getParameters();
        Expression exp = (Expression)parameters.get(1);
        if (exp.getClass() == CastExpression.class) {
            exp = ((CastExpression)exp).getExpression();
        }
        IntegerConstantExpression ice = (IntegerConstantExpression)exp;
        this.lineNumber = expression.getLineNumber();
        this.index = ice.getValue();
        if (parameters.size() == 2) {
            this.arguments = null;
        } else {
            parameters.subList(0, 2).clear();
            this.arguments = parameters;
        }
        String enumInternalTypeName = expression.getObjectType().getInternalName();
        if (!enumInternalTypeName.equals(this.bodyDeclaration.getInternalTypeName()) && (typeDeclaration = this.bodyDeclaration.getInnerTypeDeclaration(enumInternalTypeName)) != null) {
            this.constantBodyDeclaration = typeDeclaration.getBodyDeclaration();
        }
    }

    protected static class EnumConstantComparator
    implements Comparator<ClassFileEnumDeclaration.ClassFileConstant> {
        protected EnumConstantComparator() {
        }

        @Override
        public int compare(ClassFileEnumDeclaration.ClassFileConstant ec1, ClassFileEnumDeclaration.ClassFileConstant ec2) {
            return ec1.getIndex() - ec2.getIndex();
        }
    }
}

