/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.util;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoStatus;
import com.almworks.tracker.eapi.alpha.ConnectionState;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracker.eapi.alpha.TrackerApplication;
import com.almworks.tracker.eapi.alpha.TrackerConnectionStatus;
import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracker.eapi.alpha.TrackerStarter;
import com.almworks.tracklink.IssueLink;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.TrackLinkCaches;
import com.almworks.tracklink.TrackLinkPlugin;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.highlight.URLTextRange;
import com.almworks.tracklink.toolwindow.Dashboard;
import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.vcslinks.cache.VCSCache;
import com.almworks.util.Log;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    @NonNls
    public static final String HTML_PREFIX = "<html><body>";
    public static final String UTF_8 = "UTF-8";
    public static final Pattern STACK_TRACE_MATCH_FAST_PATTERN = Pattern.compile("at\\s+([\\w\\$]*\\.)+([\\w\\$<>]*\\(.+\\))\\s*");
    public static final Pattern STACK_TRACE_MATCH_LONG_PATTERN = Pattern.compile("([^\n]*\\n+\\s*)?(at\\s+([\\w\\$]*\\.)+([\\w\\$<>]*\\([^&]+\\))\\s*){2,}");
    public static final Pattern ANTIHTML_PATTERN = Pattern.compile("(<(/)?td[^>]*>)|(<(/)?tr[^>]*>)|(<(/)?table[^>]*>)|(<(/)?span[^>]*>)|(<(/)?div[^>]*>)|(<br>)|(&\\w*;)");
    public static final Pattern URL_MATCHER = Pattern.compile("^(http|https|ftp)\\://[a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{2,4}(/\\S*)?$");
    public static final Pattern JIRA_REPLACER = Pattern.compile("\\p{Upper}{2,}\\-");
    public static final Pattern HAPPY_END_PATTERN = Pattern.compile("status:((resolved)|(closed)|(verified))", 2);
    public static final TObjectHashingStrategy<ArtifactInfo> ARTIFACT_URL_EQUALITY = new TObjectHashingStrategy<ArtifactInfo>(){

        public int computeHashCode(ArtifactInfo artifactInfo) {
            String url = artifactInfo.getUrl();
            return url != null ? url.hashCode() : 0;
        }

        public boolean equals(ArtifactInfo info1, ArtifactInfo info2) {
            return Utils.equals(info1.getUrl(), info2.getUrl());
        }
    };
    private static final Pattern HTML_BR_PATTERN = Pattern.compile("<br>|</br>");
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\n");
    private static final Pattern AT_PATTERN = Pattern.compile("\\s*at\\s+");
    private static final Pattern HTML_FINDER = Pattern.compile("(<(/)?table>)|(<(/)?td[^>]*>)|(<(/)?tr[^>]*>)|(<(/)?table[^>]*>)|(<(/)?span[^>]*>)|(<(/)?div[^>]*>)|(<br>)|(&\\w*;)");

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static String normalizeBugzillaURL(@NonNls String urlString) throws MalformedURLException {
        String result;
        int k;
        URL url;
        if (urlString == null) {
            throw new MalformedURLException("Null URL");
        }
        if ((urlString = urlString.trim()).length() == 0) {
            throw new MalformedURLException("Empty URL");
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            if (urlString.indexOf("://") < 0) {
                urlString = "http://" + urlString;
                url = new URL(urlString);
            }
            throw e;
        }
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(".cgi") && (k = path.lastIndexOf(47)) >= 0) {
            path = path.substring(0, k);
        }
        if (!(result = (url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path)).toExternalForm()).endsWith("/")) {
            result = result + "/";
        }
        if (StringUtil.isEmpty((String)url.getHost())) {
            throw new MalformedURLException("Empty host");
        }
        return result;
    }

    public static String normalizeJIRAURL(@NonNls String urlString) throws MalformedURLException {
        String result;
        int i;
        URL url;
        if (urlString == null) {
            throw new MalformedURLException("Null URL");
        }
        if ((urlString = urlString.trim()).length() == 0) {
            throw new MalformedURLException("Empty URL");
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            if (urlString.indexOf("://") < 0) {
                urlString = "http://" + urlString;
                url = new URL(urlString);
            }
            throw e;
        }
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((i = path.lastIndexOf("/browse/")) != -1) {
            path = path.substring(0, i);
        }
        if ((i = path.lastIndexOf("/secure/")) != -1) {
            path = path.substring(0, i);
        }
        if (!(result = (url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path)).toExternalForm()).endsWith("/")) {
            result = result + "/";
        }
        if (StringUtil.isEmpty((String)url.getHost())) {
            throw new MalformedURLException("Empty host");
        }
        return result;
    }

    @NotNull
    public static void setMnemonicIfNeed(AbstractButton button) {
        if (button.getMnemonic() != 0) {
            return;
        }
        String textWithMnemonic = button.getText();
        StringBuffer visibleName = new StringBuffer();
        boolean ampFound = false;
        int actualIndex = 0;
        int mnemonicIndex = -1;
        int i = 0;
        while (i < textWithMnemonic.length()) {
            char c = textWithMnemonic.charAt(i);
            if (ampFound) {
                --actualIndex;
                if (c == '&') {
                    visibleName.append(c);
                } else {
                    mnemonicIndex = actualIndex;
                    visibleName.append(c);
                }
                ampFound = false;
            } else if (c != '&') {
                visibleName.append(c);
            } else {
                ampFound = true;
            }
            ++i;
            ++actualIndex;
        }
        button.setText(visibleName.toString());
        char mChar = '\u0000';
        if (mnemonicIndex != -1 && (mChar = visibleName.charAt(mnemonicIndex)) >= 'a' && mChar <= 'z') {
            mChar = (char)(mChar - 32);
        }
        button.setMnemonic(mChar);
    }

    public static String getStatusPresentation(ArtifactInfoStatus status) {
        return StringBundle.get("artifact.status." + (status != null ? status.getExternalName() : "UNKNOWN"), new Object[0]);
    }

    @Nullable
    public static String getConnectionStatePresentation(ConnectionState state) {
        if (state == ConnectionState.CONNECTED) {
            return StringBundle.get("connectionstate.connected", new Object[0]);
        }
        if (state == ConnectionState.CONNECTION_CLOSED) {
            return StringBundle.get("connectionstate.connection_closed", new Object[0]);
        }
        if (state == ConnectionState.CONNECTION_FAILED) {
            return StringBundle.get("connectionstate.connection_failed", new Object[0]);
        }
        if (state == ConnectionState.NOT_CONNECTED) {
            return StringBundle.get("connectionstate.not_connected", new Object[0]);
        }
        return null;
    }

    public static int getStartLineOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/util/Utils.getStartLineOffset must not be null");
        }
        offset = Utils.ensureInBounds(editor, offset);
        Document document = editor.getDocument();
        int lineCount = document.getLineCount();
        int textLength = document.getTextLength();
        int lineNumber = offset < 0 ? 0 : (offset < textLength ? document.getLineNumber(offset) : lineCount - 1);
        if (lineNumber >= 0 && lineNumber < lineCount) {
            return document.getLineStartOffset(lineNumber);
        }
        return 0;
    }

    public static int getEndLineOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/util/Utils.getEndLineOffset must not be null");
        }
        offset = Utils.ensureInBounds(editor, offset);
        Document document = editor.getDocument();
        int lineCount = document.getLineCount();
        int textLength = document.getTextLength();
        int lineNumber = offset < 0 ? 0 : (offset < textLength ? document.getLineNumber(offset) : lineCount - 1);
        if (lineNumber >= 0 && lineNumber < lineCount) {
            return document.getLineEndOffset(lineNumber);
        }
        return 0;
    }

    public static int ensureInBounds(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/util/Utils.ensureInBounds must not be null");
        }
        return Utils.ensureInBounds(offset, 0, editor.getDocument().getTextLength());
    }

    public static int ensureInBounds(int value, int minValue, int maxValue) {
        return Math.max(Math.min(value, Math.max(minValue, maxValue)), Math.min(minValue, maxValue));
    }

    public static boolean intersectOrBound(int start1, int end1, int start2, int end2) {
        return Math.max(start1, start2) <= Math.min(end1, end2);
    }

    public static boolean intersect(int start1, int end1, int start2, int end2) {
        return Math.max(start1, start2) < Math.min(end1, end2);
    }

    public static boolean isControlOrMetaPressed(InputEvent event) {
        if (SystemInfo.isMac) {
            return (event.getModifiersEx() & 0x100) == 256;
        }
        return (event.getModifiersEx() & 0x80) == 128;
    }

    public static boolean isAltPressed(InputEvent event) {
        return (event.getModifiersEx() & 0x200) == 512;
    }

    @Nullable
    public static Point getCaretScreenPoint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/util/Utils.getCaretScreenPoint must not be null");
        }
        Point point = editor.logicalPositionToXY(editor.getCaretModel().getLogicalPosition());
        point.translate(0, editor.getLineHeight());
        JScrollPane scrollPane = Utils.getJScrollPaneParent(editor.getContentComponent());
        if (scrollPane != null) {
            Point scrollOffset = scrollPane.getVisibleRect().getLocation();
            point.translate(-scrollOffset.x, -scrollOffset.y);
        }
        SwingUtilities.convertPointToScreen(point, editor.getContentComponent());
        return point;
    }

    @Nullable
    private static JScrollPane getJScrollPaneParent(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JScrollPane) {
            return (JScrollPane)c;
        }
        return Utils.getJScrollPaneParent(c.getParent());
    }

    public static boolean startDeskzilla(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        TrackerConnector connector = Utils.getConnector(dataContext);
        if (connector == null) {
            return false;
        }
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        TrackLinkPlugin plugin = (TrackLinkPlugin)project.getComponent(TrackLinkPlugin.class);
        if (plugin == null) {
            return false;
        }
        Component component = (Component)DataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (component == null) {
            return false;
        }
        IssueLinkModel model = plugin.getIssueModel();
        String deskzillaWorkspaceSelector = model.getDeskzillaWorkspaceSelector();
        TrackerApplication application = model.getApplication();
        if (application == null) {
            return false;
        }
        TrackerStarter starter = connector.getTrackerStarter();
        TrackerConnectionStatus connectionStatus = (TrackerConnectionStatus)starter.getConnectionStatus().getValue();
        if (connectionStatus == null || !connectionStatus.isConnected()) {
            try {
                if (deskzillaWorkspaceSelector == null || deskzillaWorkspaceSelector.length() == 0) {
                    starter.startTracker(application);
                } else {
                    File workspaceDirectory = new File(deskzillaWorkspaceSelector);
                    starter.startTracker(application, workspaceDirectory);
                }
            }
            catch (IOException e1) {
                String appName = plugin.getIssueModel().getApplicationDisplayNameNotNull();
                Messages.showErrorDialog((Component)component, (String)StringBundle.get("popup.cannot_start_app", appName), (String)StringBundle.get("popup.cannot_start_app.title", appName));
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/util/Utils.notNull must not be null");
        }
        T t = value != null ? value : defaultValue;
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/util/Utils.notNull must not return null");
        }
        return t;
    }

    public static String getHackedID(String url) {
        int i = url.lastIndexOf(47);
        if (i > -1 && i < url.length() - 1) {
            int p = url.indexOf(61, i);
            if (p > -1 && p < url.length() - 1) {
                return url.substring(p + 1);
            }
            return url.substring(i + 1);
        }
        return "~" + (url.length() > 3 ? url.substring(url.length() - 3) : url);
    }

    public static int getNumericID(String strId) {
        String s = JIRA_REPLACER.matcher(strId).replaceFirst("");
        return Integer.parseInt(s);
    }

    public static boolean isDeskzillaConnected(DataContext dataContext) {
        TrackerConnector connector = Utils.getConnector(dataContext);
        return connector != null && ((TrackerConnectionStatus)connector.getTrackerStarter().getConnectionStatus().getValue()).isConnected();
    }

    @Nullable
    public static TrackerConnector getConnector(DataContext dataContext) {
        Dashboard dashboard = Utils.getDashboard(dataContext);
        if (dashboard == null) {
            return null;
        }
        return dashboard.getConnector();
    }

    @Nullable
    public static Dashboard getDashboard(DataContext dataContext) {
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        return (Dashboard)project.getComponent(Dashboard.class);
    }

    @Nullable
    public static TrackLinkPlugin getTrackLinkPlugin(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/util/Utils.getTrackLinkPlugin must not be null");
        }
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        return (TrackLinkPlugin)project.getComponent(TrackLinkPlugin.class);
    }

    @Nullable
    public static IssueLink getIssueLink(DataContext context, boolean lookAtDashboard) {
        IssueLink issueLink = (IssueLink)context.getData("IssueLink");
        if (issueLink != null) {
            return issueLink;
        }
        TrackLinkPlugin plugin = Utils.getTrackLinkPlugin(context);
        if (plugin == null) {
            return null;
        }
        URLTextRange range = plugin.getParser().getURLTextRange(context);
        if (range != null) {
            return range;
        }
        if (lookAtDashboard) {
            Dashboard dashboard = Utils.getDashboard(context);
            if (dashboard == null) {
                return null;
            }
            ArtifactInfo artifactInfo = dashboard.getToolPanel().getSingleSelectedArtifact();
            if (artifactInfo != null) {
                return Utils.getIssueLink(artifactInfo);
            }
        }
        return null;
    }

    @Nullable
    public static IssueLink getIssueLinks(DataContext context) {
        ArtifactInfoRow info = (ArtifactInfoRow)context.getData("ArtifactInfoNodes");
        if (info != null) {
            return Utils.getIssueLink(info.getArtifactInfo());
        }
        TrackLinkPlugin plugin = Utils.getTrackLinkPlugin(context);
        if (plugin == null) {
            return null;
        }
        return plugin.getParser().getURLTextRange(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static IssueLink getIssueLink(final @NotNull ArtifactInfo artifactInfo) {
        if (artifactInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/util/Utils.getIssueLink must not be null");
        }
        IssueLink issueLink = new IssueLink(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public String getURL() {
                String string = artifactInfo.getUrl();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/almworks/tracklink/util/Utils$2.getURL must not return null");
                }
                return string;
            }

            @Nullable
            public String getIssueName() {
                return (String)artifactInfo.getPresentation(GenericKeys.SUMMARY);
            }
        };
        if (issueLink == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/util/Utils.getIssueLink must not return null");
        }
        return issueLink;
    }

    public static void checkVisibility(AnActionEvent e) {
        if (e == null) {
            return;
        }
        if ("TracklinkPopups".equals(e.getPlace())) {
            e.getPresentation().setVisible(e.getPresentation().isEnabled());
        }
    }

    @Nullable
    public static ActionToolbar createActionToolbar(@NonNls String groupId) {
        AnAction anAction = ActionManager.getInstance().getAction(groupId);
        if (anAction instanceof ActionGroup) {
            return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)anAction, true);
        }
        Log.error("Cannot find ActionGroup by id: " + groupId);
        return null;
    }

    public static boolean getBooleanValue(Element element, String attrName) {
        return Boolean.parseBoolean(element.getAttributeValue(attrName));
    }

    public static int getIntValue(Element element, String attrName, int defaultValue) {
        try {
            return Integer.parseInt(element.getAttributeValue(attrName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Nullable
    public static ArtifactInfoCache getArtifactInfoCache() {
        TrackLinkCaches caches = (TrackLinkCaches)ApplicationManager.getApplication().getComponent(TrackLinkCaches.class);
        if (caches == null) {
            return null;
        }
        return caches.getArtifactInfoCache();
    }

    @Nullable
    public static VCSCache getVCSCache(Project project) {
        return (VCSCache)project.getComponent(VCSCache.class);
    }

    public static boolean getBooleanAttribute(Element element, String attrName, boolean defaultValue) {
        String attributeValue = element.getAttributeValue(attrName);
        return attributeValue == null ? defaultValue : Boolean.parseBoolean(attributeValue);
    }

    public static void toFront(Window window) {
        window.toFront();
        window.requestFocus();
        window.toFront();
    }

    @Nullable
    public static <T> T asClass(Class<T> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        return null;
    }

    public static void toFront(Project project) {
        Window window;
        if (project != null && (window = WindowManager.getInstance().suggestParentWindow(project)) != null) {
            Utils.toFront(window);
        }
    }

    public static String[] getUrls(Collection<IssueLink> links) {
        if (links == null) {
            return EMPTY_STRING_ARRAY;
        }
        int size = links.size();
        if (size == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] urls = new String[size];
        Iterator<IssueLink> ii = links.iterator();
        int i = 0;
        while (ii.hasNext()) {
            String url = ii.next().getURL();
            assert (url != null);
            urls[i] = url;
            ++i;
        }
        return urls;
    }

    public static void setupApiLog(TrackerConnector connector) {
        String API_DUMP_PROPERTY = "api.dump";
        String dumpLog = System.getProperty("api.dump");
        if (dumpLog != null) {
            File dir = null;
            try {
                dir = new File(dumpLog);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dir != null && dir.isDirectory()) {
                connector.configureLogging(dir);
            }
        }
    }

    public static String replaceBRwithN(String in) {
        Matcher m = HTML_BR_PATTERN.matcher(in);
        return m.replaceAll("\n");
    }

    public static String removeHTMLEntities(String in) {
        Matcher m = ANTIHTML_PATTERN.matcher(in);
        return m.replaceAll("");
    }

    public static String normalizeStackTrace(String stackTrace) {
        String withoutN = NEW_LINE_PATTERN.matcher(stackTrace).replaceAll("");
        Matcher st = AT_PATTERN.matcher(withoutN);
        return st.replaceAll("\n\tat ");
    }

    public static String extractStackTrace(String in) {
        String replacedBR = Utils.removeHTMLEntities(Utils.replaceBRwithN(in));
        Matcher matcher = STACK_TRACE_MATCH_LONG_PATTERN.matcher(replacedBR);
        matcher.find();
        return Utils.normalizeStackTrace(matcher.group(0));
    }

    public static boolean hasStackTrace(String in) {
        Matcher matcher = STACK_TRACE_MATCH_FAST_PATTERN.matcher(in);
        return matcher.find();
    }

    public static String getHighlightedHtml(String presentation, String highlight) {
        String replacementPattern = "<span class=\"found\">$0</span>";
        Pattern replacer = Pattern.compile(highlight, 18);
        Matcher m = HTML_FINDER.matcher(presentation);
        StringBuffer buffer = new StringBuffer();
        int lastEnd = 0;
        while (m.find(lastEnd)) {
            int start = m.start(0);
            int end = m.end(0);
            if (start - lastEnd > 0) {
                String nonHtml = presentation.substring(lastEnd, start);
                String res = replacer.matcher(nonHtml).replaceAll(replacementPattern);
                buffer.append(res);
            }
            String html = presentation.substring(start, end);
            buffer.append(html);
            lastEnd = end;
        }
        return buffer.toString();
    }

    public static boolean isBrowseableURL(String url) {
        Matcher m = URL_MATCHER.matcher(url);
        return m.find();
    }

    public static boolean isResolved(String text) {
        Matcher m = HAPPY_END_PATTERN.matcher(text);
        return m.find();
    }
}

