/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table.view;

import com.almworks.tracklink.toolwindow.table.model.ArtifactCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.almworks.tracklink.toolwindow.table.model.IssueTableModel;
import com.almworks.tracklink.toolwindow.table.model.TableAbstractRow;
import com.almworks.tracklink.util.PluginIcons;
import com.almworks.util.ui.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;

public class IssueTableCellRenderer
extends JComponent
implements TableCellRenderer {
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    public static final int MIN_DISTANCE = 3;
    public static final Icon BUG_ICON = PluginIcons.BUG;
    public static final Icon STACK_TRACE_ICON = PluginIcons.BUG_STACKTRACE;
    private Color myFIRST_BG_COLOR;
    private Color mySECOND_BG_COLOR;
    private Color myTableForeground;
    private Color myIDColor;
    private Color myIDSelectionColor;
    private Color myIDNonSelectionColor;
    public static final float MAX_ID_RATIO = 0.3f;
    private final IssueTableModel myModel;
    private TableAbstractRow myRow;
    private Rectangle myRect;
    private int myMaxCharWidth = 0;
    private boolean myIsFontMetricsChanged = true;
    private FontMetrics myFontMetrics;
    private Font myFont;
    private JTable myTable;
    private Rectangle myExpandRect;
    private Color foregroundColor;
    private Color backgroundColor;
    private int myFontBaseLine;
    private int myRowHeight;
    private int myIconMaxWidth;
    private Icon myExpandIcon;
    private Icon myCollapseIcon;
    private Border myBorder = null;
    private Color myTableSelectionForeground;
    private Color myTableSelectionBackground;

    public IssueTableCellRenderer(IssueTableModel model, JTable table) {
        this.myModel = model;
        this.myTable = table;
        this.updateUI();
    }

    public void setTable(JTable table) {
        this.myTable = table;
    }

    public Rectangle getExpandRect() {
        return this.myExpandRect;
    }

    public String getToolTipText() {
        String toolTip = this.myRow.getColumn(1);
        if (this.myRow instanceof ArtifactInfoRow) {
            ArtifactInfoRow air = (ArtifactInfoRow)this.myRow;
            if (this.myModel.isFiltering()) {
                Matcher matcher = this.myModel.getFilterPattern().matcher(this.getFoundPlaces(air));
                return "<html>" + matcher.replaceAll("<span style=\"background-color:" + ColorUtil.SEARCH_HIGLIGHT_BACKCOLOR_LITERAL + "; color:#FFFFFF;\">$0</span>") + "</html>";
            }
            int lenght = toolTip.length();
            int lineWidth = (int)this.myRect.getWidth() / this.myMaxCharWidth;
            StringBuffer sb = new StringBuffer("<html>");
            sb.append(String.format("<b>%s</b><br>", air.getColumn(0)));
            int pos = 0;
            while (pos < lenght) {
                if (pos + lineWidth < lenght) {
                    int firstSpace = toolTip.indexOf(32, pos + lineWidth);
                    if (firstSpace != -1) {
                        sb.append(toolTip.substring(pos, firstSpace));
                        pos = firstSpace;
                    } else {
                        sb.append(toolTip.substring(pos, lenght));
                        pos = lenght;
                    }
                } else {
                    sb.append(toolTip.substring(pos, lenght));
                    pos = lenght;
                }
                sb.append("<br>");
            }
            sb.append("</html>");
            return sb.toString();
        }
        return toolTip;
    }

    private int paintFilteringText(Graphics g, int xPos, String outstr, Color forecolor) {
        g.setColor(forecolor);
        g.drawString(outstr, xPos, this.myFontBaseLine);
        if (this.myModel.isFiltering()) {
            Matcher matcher = this.myModel.getFilterPattern().matcher(outstr);
            int start = 0;
            while (matcher.find(start)) {
                String toPrint = outstr.substring(matcher.start(0), matcher.end(0));
                String beforePrint = outstr.substring(0, matcher.start(0));
                int printPos = xPos + this.myFontMetrics.stringWidth(beforePrint);
                g.setColor(ColorUtil.SEARCH_HIGLIGHT_BACKCOLOR);
                g.fillRect(printPos, 0, this.myFontMetrics.stringWidth(toPrint), this.myRect.height);
                g.setColor(ColorUtil.SEARCH_HIGLIGHT_FORECOLOR);
                g.drawString(toPrint, printPos, this.myFontBaseLine);
                start = matcher.end(0);
            }
            g.setColor(forecolor);
        }
        return xPos;
    }

    public void paint(Graphics graphics) {
        Graphics borderGraphics = this.myBorder != null ? graphics.create() : graphics;
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.myBorder != null) {
            this.myBorder.paintBorder(this, borderGraphics, 0, 0, this.getWidth(), this.getHeight());
            borderGraphics.dispose();
        }
        boolean rightEdge = false;
        if (this.myRow instanceof ArtifactInfoRow) {
            graphics.setColor(this.foregroundColor);
            this.paintArtifactRow(graphics);
        } else if (this.myRow instanceof ArtifactCollectionRow) {
            this.paintCollectionRow(graphics);
        }
    }

    private void paintArtifactRow(Graphics graphics) {
        String outstr;
        int rightEdge = 0;
        ArtifactInfoRow air = (ArtifactInfoRow)this.myRow;
        Icon printIcon = null;
        printIcon = air.hasStackTrace() ? STACK_TRACE_ICON : BUG_ICON;
        this.drawIcon(printIcon, graphics);
        rightEdge += this.myIconMaxWidth;
        ArtifactInfoRow row = (ArtifactInfoRow)this.myRow;
        int idWidth = this.getIdWidth(row);
        if ((float)idWidth < 0.3f * (float)this.getWidth()) {
            outstr = row.getColumn(0);
            this.paintFilteringText(graphics, rightEdge, outstr, this.myIDColor);
            rightEdge += idWidth;
        }
        outstr = row.getColumn(1);
        int rightEdge2 = this.paintFilteringText(graphics, rightEdge, outstr, this.foregroundColor);
        if (row.isResolved() && !this.myModel.isFiltering()) {
            int height = this.myRowHeight / 2;
            graphics.drawLine(rightEdge, height, rightEdge + this.myFontMetrics.stringWidth(outstr), height);
        }
    }

    private void paintCollectionRow(Graphics graphics) {
        int rightEdge = 0;
        boolean isExpanded = ((ArtifactCollectionRow)this.myRow).isCollectionExpanded();
        Icon toDraw = isExpanded ? this.myExpandIcon : this.myCollapseIcon;
        this.drawIcon(toDraw, graphics);
        ArtifactCollectionRow row = (ArtifactCollectionRow)this.myRow;
        graphics.setFont(this.myFont.deriveFont(1));
        String outstr = row.getColumn(0);
        graphics.setColor(this.foregroundColor);
        graphics.drawString(outstr, rightEdge += this.myExpandRect.x + this.myExpandRect.width + 2, this.myFontBaseLine);
        graphics.setFont(this.myFont.deriveFont(0));
    }

    private void drawIcon(Icon toDraw, Graphics graphics) {
        assert (toDraw != null);
        int height = toDraw.getIconHeight();
        int width = toDraw.getIconWidth();
        height = (this.myRowHeight - height) / 2;
        width = (this.myIconMaxWidth - width) / 2;
        toDraw.paintIcon(this, graphics, width, height);
    }

    private int getIdWidth(ArtifactInfoRow row) {
        return row.getParent().getColuntWidth(0) * this.myMaxCharWidth + 3;
    }

    private void setFontDisplayMetrics(Font font) {
        this.setFont(font);
        this.myFont = font;
        this.myFontMetrics = this.getFontMetrics(font);
        this.myMaxCharWidth = this.myFontMetrics.charWidth('0');
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.foregroundColor = this.myTableSelectionForeground;
            this.backgroundColor = this.myTableSelectionBackground;
            this.myIDColor = this.myIDSelectionColor;
        } else {
            this.foregroundColor = this.myTableForeground;
            this.backgroundColor = row % 2 == 0 ? this.myFIRST_BG_COLOR : this.mySECOND_BG_COLOR;
            this.myIDColor = this.myIDNonSelectionColor;
        }
        if (hasFocus) {
            this.myBorder = null;
            if (isSelected) {
                this.myBorder = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (this.myBorder == null) {
                this.myBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(this.myBorder);
        } else {
            this.setBorder(IssueTableCellRenderer.getNoFocusBorder());
            this.myBorder = null;
        }
        this.myRow = (TableAbstractRow)value;
        this.myRect = table.getCellRect(row, column, false);
        return this;
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public String toString() {
        return "IssueTableCellRenderer{}";
    }

    public void updateUI() {
        super.updateUI();
        this.myExpandIcon = (Icon)UIManager.get("Tree.expandedIcon");
        this.myCollapseIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        this.setFontDisplayMetrics(UIManager.getFont("Table.font"));
        this.myRowHeight = Math.max(Math.max(this.myFontMetrics.getHeight(), this.myExpandIcon.getIconHeight()), Math.max(BUG_ICON.getIconHeight(), STACK_TRACE_ICON.getIconHeight()));
        this.myIconMaxWidth = Math.max(this.myExpandIcon.getIconHeight(), Math.max(BUG_ICON.getIconHeight(), STACK_TRACE_ICON.getIconHeight()));
        this.myTable.setRowHeight(this.myRowHeight);
        this.myFontBaseLine = this.myFontMetrics.getAscent() + (this.myRowHeight - this.myFontMetrics.getHeight()) / 2;
        int width = this.myExpandIcon.getIconWidth();
        int xPos = (this.myIconMaxWidth - width) / 2;
        this.myExpandRect = new Rectangle(xPos, 0, width + xPos, this.myRowHeight);
        this.myTable.setUI((TableUI)UIManager.getUI(this.myTable));
        this.myTableForeground = this.myTable.getForeground();
        this.myFIRST_BG_COLOR = this.myTable.getBackground();
        this.mySECOND_BG_COLOR = ColorUtil.between(this.myFIRST_BG_COLOR, this.myTableForeground, 0.1f);
        this.myTableSelectionBackground = this.myTable.getSelectionBackground();
        this.myTableSelectionForeground = this.myTable.getSelectionForeground();
        this.myIDSelectionColor = ColorUtil.between(this.myTableSelectionForeground, this.myTableSelectionBackground, 0.25f);
        this.myIDNonSelectionColor = ColorUtil.between(this.myTableForeground, this.myFIRST_BG_COLOR, 0.35f);
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }

    public String getFoundPlaces(ArtifactInfoRow row) {
        if (!this.myModel.isFiltering()) {
            return null;
        }
        int start = 0;
        String fullText = row.getText();
        StringBuffer result = new StringBuffer();
        Matcher matcher = this.myModel.getFilterPattern().matcher(fullText);
        while (matcher.find(start)) {
            int firstIndex = matcher.start(0);
            int lastIndex = matcher.end(0);
            lastIndex = lastIndex + 100 < fullText.length() ? (lastIndex += 99) : fullText.length();
            firstIndex = firstIndex - 20 > 0 ? (firstIndex -= 19) : 0;
            start = lastIndex - this.myModel.getFilterString().length();
            result.append("...");
            result.append(fullText.substring(firstIndex, lastIndex));
            result.append("...");
            result.append("<br>");
        }
        return result.toString();
    }
}

