/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.CollectionData;
import com.almworks.tracklink.IssueLink;
import com.almworks.tracklink.toolwindow.table.model.ArtifactCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.almworks.tracklink.toolwindow.table.model.IssueTableModel;
import com.almworks.tracklink.toolwindow.table.model.TableAbstractRow;
import com.almworks.tracklink.toolwindow.table.view.IssueTable;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.almworks.util.detach.Lifespan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolPanel
extends JPanel
implements DataProvider {
    private final IssueTableModel myIssueTableModel;
    private Project myProject;
    private IssueTable myView;

    public ToolPanel(IssueTableModel model, Lifespan lifespan) {
        super(GuiUtils.createBorderLayout());
        this.myIssueTableModel = model;
    }

    public void init() {
        this.initializeIssueTable();
        this.initializePanel();
        this.installPopupHandlers();
    }

    private void initializeIssueTable() {
        this.myView = new IssueTable(this.myIssueTableModel);
    }

    private void installPopupHandlers() {
        PopupHandler.installPopupHandler((JComponent)this.myView.getTable(), (String)"DashboardPopup", (String)"TracklinkPopups");
    }

    protected void initializePanel() {
        ActionToolbar toolbar = Utils.createActionToolbar("DashboardToolbar");
        if (toolbar != null) {
            JPanel fullToolbar = new JPanel(new BorderLayout());
            fullToolbar.add((Component)toolbar.getComponent(), "West");
            fullToolbar.add((Component)this.myView.getSearchField(), "Center");
            this.add((Component)fullToolbar, "North");
        }
        this.add((Component)this.myView.getComponent(), "Center");
    }

    public IssueTable getIssueView() {
        return this.myView;
    }

    @Nullable
    public ArtifactInfo getSingleSelectedArtifact() {
        ArtifactInfoRow row = this.getSingleSelectedArtifactRow();
        return row == null ? null : row.getArtifactInfo();
    }

    @Nullable
    public ArtifactInfoRow getSingleSelectedArtifactRow() {
        TableAbstractRow row = this.getSelectedRow();
        if (row != null && row instanceof ArtifactInfoRow) {
            return (ArtifactInfoRow)row;
        }
        return null;
    }

    @Nullable
    private TableAbstractRow getSelectedRow() {
        return this.myView.getSearchField().hasFocus() ? null : this.myIssueTableModel.getRowByPosition(this.myView.getSingleSelection());
    }

    @Nullable
    public CollectionData getSingleSelectedCollection() {
        ArtifactCollectionRow row = this.getSingleSelectedCollectionRow();
        return row == null ? null : row.getCollectionData();
    }

    @Nullable
    public ArtifactCollectionRow getSingleSelectedCollectionRow() {
        TableAbstractRow row = this.getSelectedRow();
        if (row != null && row instanceof ArtifactCollectionRow) {
            return (ArtifactCollectionRow)row;
        }
        return null;
    }

    @Nullable
    public Object getData(String dataId) {
        if (Comparing.strEqual((String)dataId, (String)"DashboardSelection")) {
            return this.getSingleSelectedCollection();
        }
        if (Comparing.strEqual((String)dataId, (String)"FiltrationString")) {
            return this.myIssueTableModel.getFilterString();
        }
        if (Comparing.strEqual((String)dataId, (String)"ArtifactInfoNodes")) {
            return this.getSingleSelectedArtifactRow();
        }
        if (Comparing.strEqual((String)dataId, (String)"IssueLink")) {
            return this.getIssueLink();
        }
        return null;
    }

    private Object getIssueLink() {
        final ArtifactInfo info = this.getSingleSelectedArtifact();
        return info == null ? null : new IssueLink(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public String getURL() {
                String string = info.getUrl();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/almworks/tracklink/toolwindow/ToolPanel$1.getURL must not return null");
                }
                return string;
            }

            @Nullable
            public String getIssueName() {
                return null;
            }
        };
    }
}

