/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow;

import com.almworks.dup.util.EventListener;
import com.almworks.dup.util.ValueEvent;
import com.almworks.dup.util.ValueModel;
import com.almworks.tracker.alpha.AlphaConnector;
import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.CollectionData;
import com.almworks.tracker.eapi.alpha.ConnectorProperty;
import com.almworks.tracker.eapi.alpha.TrackerApplication;
import com.almworks.tracker.eapi.alpha.TrackerConnectionStatus;
import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.MigrationConfig;
import com.almworks.tracklink.TrackLinkCaches;
import com.almworks.tracklink.TrackLinkPlugin;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.cache.impl.ArtifactInfoCacheImpl;
import com.almworks.tracklink.collections.CollectionsCache;
import com.almworks.tracklink.collections.CollectionsCacheImpl;
import com.almworks.tracklink.settings.TrackerInstallHelper;
import com.almworks.tracklink.toolwindow.IssueMonitor;
import com.almworks.tracklink.toolwindow.ToolPanel;
import com.almworks.tracklink.toolwindow.table.IssueTableController;
import com.almworks.tracklink.toolwindow.table.PluginBaseComponents;
import com.almworks.tracklink.toolwindow.table.model.ArtifactCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.almworks.tracklink.toolwindow.table.model.IssueTableModel;
import com.almworks.tracklink.toolwindow.table.model.TableFilteringRow;
import com.almworks.tracklink.util.HTMLViewer;
import com.almworks.tracklink.util.PluginIcons;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.Lifecycle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="TrackLink.DashboardWindow", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class Dashboard
implements ProjectComponent,
DataProvider,
PluginBaseComponents,
PersistentStateComponent<IssueTableModel> {
    private static final String CONNECTOR_SHORT_NAME = "IDEA";
    private static final String CONFIGURE_ACTION_URL = "http://tracklink.almworks.com/actions/configure";
    protected static final String WINDOW_ID = StringBundle.get("plugin.toolwindow.id", new Object[0]);
    private final Lifecycle myProjectLifespan = new Lifecycle();
    private final TrackLinkPlugin myPlugin;
    private final TrackLinkCaches myCaches;
    private final TrackerConnector myConnector = new AlphaConnector();
    public IssueTableModel myIssueTableModel = new IssueTableModel();
    private final IssueTableController myModelController = new IssueTableController(this.myIssueTableModel, this);
    @Nullable
    private Project myProject;
    @Nullable
    private ToolWindow myToolWindow;
    private final JPanel myWholePanel = new JPanel(new BorderLayout());
    private HTMLViewer myCoverView = this.createHtmlViewer();
    private String myTitle = null;
    private final ToolPanel myToolPanel = new ToolPanel(this.myIssueTableModel, this.myProjectLifespan.lifespan());
    private final MyIssueMonitor myIssueMonitor = new MyIssueMonitor();
    private IssueLinkModel myIssueModel;

    public Dashboard(Project project, TrackLinkPlugin plugin, TrackLinkCaches caches) {
        this.myProject = project;
        this.myPlugin = plugin;
        this.myCaches = caches;
        this.myIssueModel = plugin.getIssueModel();
        Utils.setupApiLog(this.myConnector);
    }

    public IssueTableModel getState() {
        this.myModelController.getState();
        return this.myIssueTableModel;
    }

    public void loadState(IssueTableModel model) {
        this.myModelController.loadState(model);
    }

    private HTMLViewer createHtmlViewer() {
        HTMLViewer viewer = new HTMLViewer();
        viewer.setAutoStyleEnabled(true);
        viewer.setOpaque(false);
        viewer.setBorder(new EmptyBorder(5, 5, 5, 5));
        viewer.addHyperlinkListener(CONFIGURE_ACTION_URL, new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                Dashboard.this.myPlugin.showConfigurationDialog(Dashboard.this.myCoverView);
            }
        });
        return viewer;
    }

    public MyIssueMonitor getIssueMonitor() {
        return this.myIssueMonitor;
    }

    public ToolPanel getToolPanel() {
        return this.myToolPanel;
    }

    public void projectOpened() {
        Project project = this.myProject;
        if (project == null) {
            assert (false) : this;
            return;
        }
        this.myModelController.init();
        this.myProjectLifespan.cycle();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Dashboard.this.myCaches.getArtifactInfoCache().registerConnector(Dashboard.this.myProjectLifespan.lifespan(), Dashboard.this.myProject, Dashboard.this.myConnector);
            }
        });
        this.watchForTitleAndCover();
        this.watchTrackerWorkspaceSelection();
        this.maybeMigrate();
        this.startConnector();
        this.myToolPanel.init();
        this.initializeToolWindow();
    }

    private void initializeToolWindow() {
        ToolWindowManager twm = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = twm.registerToolWindow(WINDOW_ID, (JComponent)this.myWholePanel, ToolWindowAnchor.RIGHT);
        if (toolWindow == null) {
            assert (false) : this;
        } else {
            toolWindow.setIcon(PluginIcons.ICON_SMALL);
            toolWindow.setTitle(this.myTitle);
            this.myProjectLifespan.lifespan().add(new Detach(){

                protected void doDetach() {
                    ToolWindowManager.getInstance((Project)Dashboard.this.myProject).unregisterToolWindow(WINDOW_ID);
                    Dashboard.this.myToolWindow = null;
                }
            });
        }
        this.myToolWindow = toolWindow;
    }

    public void startConnector() {
        this.myConnector.setProperty(ConnectorProperty.NAME, (Object)this.myProject.getName());
        this.myConnector.setProperty(ConnectorProperty.SHORT_NAME, (Object)CONNECTOR_SHORT_NAME);
        this.myConnector.start();
    }

    private void maybeMigrate() {
        MigrationConfig myMigrationConfig = (MigrationConfig)ApplicationManager.getApplication().getComponent(MigrationConfig.class);
        if (myMigrationConfig != null && myMigrationConfig.isNeedMigrate()) {
            this.myIssueModel.getSettingsFrom(myMigrationConfig.getModel());
        }
    }

    public void watchTrackerWorkspaceSelection() {
        final IssueLinkModel issueLinkModel = this.myPlugin.getIssueModel();
        final Runnable job = new Runnable(){

            public void run() {
                String pathname = issueLinkModel.getDeskzillaWorkspaceSelector();
                TrackerApplication application = issueLinkModel.getApplication();
                if (application == null) {
                    Dashboard.this.myConnector.getTrackerStarter().useTrackerDiscovery(null, null);
                } else if (pathname != null && pathname.length() > 0) {
                    Dashboard.this.myConnector.getTrackerStarter().useTrackerWorkspace(new File(pathname));
                } else {
                    Dashboard.this.myConnector.getTrackerStarter().useTrackerDiscovery(application, null);
                }
            }
        };
        issueLinkModel.addApplyingJob(job);
        job.run();
        this.myProjectLifespan.lifespan().add(new Detach(){

            protected void doDetach() {
                issueLinkModel.removeApplyingJob(job);
            }
        });
    }

    private void watchForTitleAndCover() {
        ValueModel connectionStatus = this.myConnector.getTrackerStarter().getConnectionStatus();
        connectionStatus.events().addListener(this.myProjectLifespan.lifespan(), ValueEvent.class, (EventListener)new EventListener<ValueEvent>(){

            public void onEvent(ValueEvent event) {
                Dashboard.this.updateTitle();
            }
        });
        final Runnable job = new Runnable(){

            public void run() {
                Dashboard.this.updateTitle();
            }
        };
        this.myIssueModel.addApplyingJob(job);
        this.myProjectLifespan.lifespan().add(new Detach(){

            protected void doDetach() {
                Dashboard.this.myIssueModel.removeApplyingJob(job);
            }
        });
        this.myIssueModel.apply();
    }

    private void updateTitle() {
        TrackerApplication application = this.myIssueModel.getApplication();
        if (application == null) {
            String text;
            String currentText;
            boolean anyInstalled;
            this.myTitle = StringBundle.get("plugin.toolwindow.title.noIntegration", new Object[0]);
            boolean bl = anyInstalled = TrackerInstallHelper.isInstalled("deskzilla") || TrackerInstallHelper.isInstalled("jiraclient");
            if (this.myWholePanel.getComponentCount() != 1 || this.myWholePanel.getComponent(0) != this.myCoverView) {
                this.myWholePanel.removeAll();
                this.myWholePanel.add((Component)this.myCoverView, "Center");
                this.myWholePanel.revalidate();
                this.myWholePanel.repaint();
            }
            if (!(currentText = this.myCoverView.getText()).equals(text = StringBundle.get(anyInstalled ? "plugin.toolwindow.cover.unconfigured" : "plugin.toolwindow.cover.notInstalled", new Object[0]))) {
                this.myCoverView.setText(text);
            }
        } else {
            if (this.myWholePanel.getComponentCount() != 1 || this.myWholePanel.getComponent(0) != this.myToolPanel) {
                this.myWholePanel.removeAll();
                this.myWholePanel.add((Component)this.myToolPanel, "Center");
                this.myWholePanel.revalidate();
                this.myWholePanel.repaint();
            }
            TrackerConnectionStatus status = (TrackerConnectionStatus)this.myConnector.getTrackerStarter().getConnectionStatus().getValue();
            String stateName = Utils.getConnectionStatePresentation(status.getConnectionState());
            if (status.isConnected()) {
                this.checkFirstConnection();
                String trackerName = status.getTrackerName();
                String workspaceDirectory = status.getWorkspaceDirectory();
                this.myTitle = StringBundle.get("plugin.toolwindow.title", stateName, trackerName, workspaceDirectory);
            } else {
                this.myTitle = StringBundle.get("plugin.toolwindow.shortTitle", stateName);
            }
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.setTitle(this.myTitle);
        }
    }

    public void projectClosed() {
        this.myProjectLifespan.dispose();
        this.myProject = null;
        this.myIssueTableModel.doDetatch();
        this.myConnector.stop();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("TrackLink.DashboardWindow" == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/toolwindow/Dashboard.getComponentName must not return null");
        }
        return "TrackLink.DashboardWindow";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void checkFirstConnection() {
        if (this.myCaches.myNeverConnected) {
            this.myConnector.getArtifactCollectionConfigurationManager().requestAddDefaultCollections();
            this.myCaches.myNeverConnected = false;
        }
    }

    @Nullable
    public Object getData(String dataId) {
        return this.myToolPanel.getData(dataId);
    }

    public Component getComponent() {
        return this.myWholePanel;
    }

    public IssueLinkModel getIssueModel() {
        return this.myIssueModel;
    }

    public static Dashboard getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/toolwindow/Dashboard.getInstance must not be null");
        }
        return (Dashboard)project.getComponent(Dashboard.class);
    }

    public PluginBaseComponents getBaseComponents() {
        return this;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TrackerConnector getConnector() {
        TrackerConnector trackerConnector = this.myConnector;
        if (trackerConnector == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/toolwindow/Dashboard.getConnector must not return null");
        }
        return trackerConnector;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ArtifactInfoCache getArtifactInfoCache() {
        ArtifactInfoCacheImpl artifactInfoCacheImpl = this.myCaches.getArtifactInfoCache();
        if (artifactInfoCacheImpl == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/toolwindow/Dashboard.getArtifactInfoCache must not return null");
        }
        return artifactInfoCacheImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CollectionsCache getCollectionsCache() {
        CollectionsCacheImpl collectionsCacheImpl = this.myCaches.getCollectionsCache();
        if (collectionsCacheImpl == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/toolwindow/Dashboard.getCollectionsCache must not return null");
        }
        return collectionsCacheImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyIssueMonitor
    implements IssueMonitor {
        @Override
        public Set<ArtifactInfo> getAllMonitoringArtifactInfos() {
            THashSet result = new THashSet(Utils.ARTIFACT_URL_EQUALITY);
            for (ArtifactCollectionRow item : Dashboard.this.myIssueTableModel.getCollections()) {
                for (TableFilteringRow child : item.getChildrenAsArray()) {
                    result.add(((ArtifactInfoRow)child).getArtifactInfo());
                }
            }
            return result;
        }

        @Override
        public void forgetCollections(Collection<CollectionData> collections) {
            if (Dashboard.this.myModelController == null) {
                return;
            }
            for (CollectionData data : collections) {
                Dashboard.this.myModelController.removeCollection(data.getCollectionId());
            }
        }

        @Override
        public boolean isEmpty() {
            return Dashboard.this.myIssueTableModel.getCollectionSize() == 0;
        }
    }
}

