/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.popup;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.Lifespan;

public class DragAdapter
implements MouseListener,
MouseMotionListener {
    private boolean onPress = false;
    private Point startPoint = new Point();
    private Point startLocation = new Point();
    private Component myComponent;
    private Window myWindow;
    private Cursor myOldCursor;

    public static void attachToComponent(Component component, Window window, Lifespan lifespan) {
        new DragAdapter(component, window, lifespan);
    }

    private DragAdapter(Component component, Window window, Lifespan lifespan) {
        this.myComponent = component;
        this.myWindow = window;
        this.myComponent.addMouseListener(this);
        this.myComponent.addMouseMotionListener(this);
        lifespan.add(new Detach(){

            protected void doDetach() {
                DragAdapter.this.myComponent.removeMouseListener(DragAdapter.this);
                DragAdapter.this.myComponent.removeMouseMotionListener(DragAdapter.this);
            }
        });
    }

    public void mousePressed(MouseEvent e) {
        this.onPress = true;
        this.myOldCursor = this.myComponent.getCursor();
        this.myComponent.setCursor(Cursor.getPredefinedCursor(13));
        this.startPoint = e.getPoint();
        SwingUtilities.convertPointToScreen(this.startPoint, this.myComponent);
        this.startLocation = this.myWindow.getLocation();
    }

    public void mouseReleased(MouseEvent e) {
        this.onPress = false;
        this.myComponent.setCursor(this.myOldCursor);
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.onPress) {
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, this.myComponent);
            int shiftX = point.x - this.startPoint.x;
            int shiftY = point.y - this.startPoint.y;
            Point p = new Point(this.startLocation.x + shiftX, this.startLocation.y + shiftY);
            this.myWindow.setLocation(p);
            this.startPoint = point;
            this.startLocation = p;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

