/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.Serializable;
import java.util.Comparator;
import javolution.Javolution;
import javolution.lang.Configurable;
import javolution.text.Text;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FastComparator<T>
implements Comparator<T>,
Serializable {
    protected static final XMLFormat<FastComparator> FAST_COMPARATOR_XML = new XMLFormat(Javolution.j2meGetClass("javolution.util.FastComparator")){

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            if (clazz == DEFAULT.getClass()) {
                return DEFAULT;
            }
            if (clazz == DIRECT.getClass()) {
                return DIRECT;
            }
            if (clazz == IDENTITY.getClass()) {
                return IDENTITY;
            }
            if (clazz == LEXICAL.getClass()) {
                return LEXICAL;
            }
            if (clazz == REHASH.getClass()) {
                return REHASH;
            }
            return super.newInstance(clazz, inputElement);
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
        }
    };
    public static final Configurable<Boolean> REHASH_SYSTEM_HASHCODE = new Configurable(FastComparator.isPoorSystemHash()){

        protected void notifyChange() {
            _Rehash = (Boolean)this.get();
        }
    };
    static boolean _Rehash = REHASH_SYSTEM_HASHCODE.get();
    public static final FastComparator DEFAULT = new Default();
    public static final FastComparator DIRECT = new Direct();
    public static final FastComparator REHASH = new Rehash();
    public static final FastComparator IDENTITY = new Identity();
    public static final FastComparator LEXICAL = new Lexical();

    public abstract int hashCodeOf(T var1);

    public abstract boolean areEqual(T var1, T var2);

    @Override
    public abstract int compare(T var1, T var2);

    private static Boolean isPoorSystemHash() {
        int n;
        boolean[] blArray = new boolean[32];
        for (n = 0; n < blArray.length; ++n) {
            blArray[new Object().hashCode() & blArray.length - 1] = true;
        }
        n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            ++n;
        }
        return new Boolean(n > blArray.length >> 1);
    }

    private static final class Lexical
    extends FastComparator {
        private Lexical() {
        }

        public int hashCodeOf(Object object) {
            if (object instanceof String || object instanceof Text) {
                return object.hashCode();
            }
            CharSequence charSequence = (CharSequence)object;
            int n = 0;
            int n2 = charSequence.length();
            int n3 = 0;
            while (n3 < n2) {
                n = 31 * n + charSequence.charAt(n3++);
            }
            return n;
        }

        public boolean areEqual(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                return object.equals(object2);
            }
            if (object instanceof CharSequence && object2 instanceof String) {
                CharSequence charSequence = (CharSequence)object;
                String string = (String)object2;
                int n = string.length();
                if (charSequence.length() != n) {
                    return false;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (string.charAt(n2) == charSequence.charAt(n2++)) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof String && object2 instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)object2;
                String string = (String)object;
                int n = string.length();
                if (charSequence.length() != n) {
                    return false;
                }
                int n3 = 0;
                while (n3 < n) {
                    if (string.charAt(n3) == charSequence.charAt(n3++)) continue;
                    return false;
                }
                return true;
            }
            if (object == null || object2 == null) {
                return object == object2;
            }
            CharSequence charSequence = (CharSequence)object;
            CharSequence charSequence2 = (CharSequence)object2;
            int n = charSequence.length();
            if (charSequence2.length() != n) {
                return false;
            }
            int n4 = 0;
            while (n4 < n) {
                if (charSequence.charAt(n4) == charSequence2.charAt(n4++)) continue;
                return false;
            }
            return true;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                String string = (String)object;
                CharSequence charSequence = (CharSequence)object2;
                int n = 0;
                int n2 = Math.min(string.length(), charSequence.length());
                while (n2-- != 0) {
                    char c;
                    char c2 = string.charAt(n);
                    if (c2 == (c = charSequence.charAt(n++))) continue;
                    return c2 - c;
                }
                return string.length() - charSequence.length();
            }
            if (object2 instanceof String) {
                return -this.compare(object2, object);
            }
            CharSequence charSequence = (CharSequence)object;
            CharSequence charSequence2 = (CharSequence)object2;
            int n = 0;
            int n3 = Math.min(charSequence.length(), charSequence2.length());
            while (n3-- != 0) {
                char c;
                char c3 = charSequence.charAt(n);
                if (c3 == (c = charSequence2.charAt(n++))) continue;
                return c3 - c;
            }
            return charSequence.length() - charSequence2.length();
        }

        public String toString() {
            return "lexical";
        }
    }

    private static final class Identity
    extends FastComparator {
        private Identity() {
        }

        public int hashCodeOf(Object object) {
            int n = System.identityHashCode(object);
            if (!_Rehash) {
                return n;
            }
            n += ~(n << 9);
            n ^= n >>> 14;
            n += n << 4;
            return n ^ n >>> 10;
        }

        public boolean areEqual(Object object, Object object2) {
            return object == object2;
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }

        public String toString() {
            return "identity";
        }
    }

    private static final class Rehash
    extends FastComparator {
        private Rehash() {
        }

        public int hashCodeOf(Object object) {
            int n = object.hashCode();
            n += ~(n << 9);
            n ^= n >>> 14;
            n += n << 4;
            return n ^ n >>> 10;
        }

        public boolean areEqual(Object object, Object object2) {
            return object == null ? object2 == null : object == object2 || object.equals(object2);
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }

        public String toString() {
            return "rehash";
        }
    }

    private static final class Direct
    extends FastComparator {
        private Direct() {
        }

        public int hashCodeOf(Object object) {
            return object.hashCode();
        }

        public boolean areEqual(Object object, Object object2) {
            return object == null ? object2 == null : object == object2 || object.equals(object2);
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }

        public String toString() {
            return "direct";
        }
    }

    private static final class Default
    extends FastComparator {
        private Default() {
        }

        public int hashCodeOf(Object object) {
            return _Rehash ? REHASH.hashCodeOf(object) : object.hashCode();
        }

        public boolean areEqual(Object object, Object object2) {
            return object == null ? object2 == null : object == object2 || object.equals(object2);
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }

        public String toString() {
            return "default";
        }
    }
}

