/*
 * Decompiled with CFR 0.152.
 */
package org.almworks.util;

import java.util.Arrays;
import java.util.Collection;
import org.almworks.util.StringUtil$FindAnyMethod;

public class StringUtil {
    public static final String LINE_SEPARATOR = String.format("%n", new Object[0]);

    private StringUtil() {
    }

    public static String substringBeforeLast(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringBeforeFirst(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringAfterLast(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(n + string2.length());
    }

    public static String removeWhitespaces(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (stringBuffer != null) continue;
                stringBuffer = new StringBuffer(n);
                stringBuffer.append(string.substring(0, i));
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static String implode(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : collection) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String limitString(String string, int n) {
        if (string == null) {
            return "";
        }
        if (string.length() > n) {
            string = string.substring(0, n - 3).concat("...");
        }
        return string;
    }

    public static int calculateAffinity(String string, String string2) {
        int[] nArray = StringUtil.getLetterCounts(string);
        int[] nArray2 = StringUtil.getLetterCounts(string2);
        int n = 0;
        int n2 = nArray.length;
        assert (n2 == nArray2.length);
        for (int i = 0; i < n2; ++i) {
            n += Math.abs(nArray[i] - nArray2[i]);
        }
        return n;
    }

    private static int[] getLetterCounts(String string) {
        int[] nArray = new int[26];
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                int n2;
                char c = string.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    n2 = c - 65;
                } else {
                    if (c < 'a' || c > 'z') continue;
                    n2 = c - 97;
                }
                if (n2 >= 0 && n2 < nArray.length) {
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + 1;
                    continue;
                }
                assert (false) : n2 + ", " + String.valueOf(c);
            }
        }
        return nArray;
    }

    public static int indexOfAny(String string, char c, char c2) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            if (c3 != c && c3 != c2) continue;
            return i;
        }
        return -1;
    }

    public static String repeatCharacter(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtil.indexOfIgnoreCase(string.toCharArray(), 0, string.length(), string2.toCharArray(), 0, string2.length(), 0);
    }

    public static int indexOfIgnoreCase(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
        if (n5 >= n2) {
            return n4 == 0 ? n2 : -1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 == 0) {
            return n5;
        }
        char c = cArray2[n3];
        char c2 = Character.toLowerCase(c);
        int n6 = n + (n2 - n4);
        for (int i = n + n5; i <= n6; ++i) {
            char c3;
            char c4;
            if (Character.toLowerCase(cArray[i]) != c2) {
                while (++i <= n6 && Character.toLowerCase(cArray[i]) != c2) {
                }
            }
            if (i > n6) continue;
            int n7 = i + 1;
            int n8 = n7 + n4 - 1;
            int n9 = n3 + 1;
            while (n7 < n8 && ((c4 = cArray[n7]) == (c3 = cArray2[n9]) || Character.toLowerCase(c4) == Character.toLowerCase(c3))) {
                ++n7;
                ++n9;
            }
            if (n7 != n8) continue;
            return i - n;
        }
        return -1;
    }

    public static int findAny(char[] cArray, char[][] cArray2, int[] nArray, boolean bl, boolean bl2) {
        assert (nArray == null || cArray2.length == nArray.length) : cArray2 + " " + nArray;
        StringUtil$FindAnyMethod stringUtil$FindAnyMethod = nArray == null ? new StringUtil$FindAnyMethod(cArray2, bl) : new StringUtil$FindAnyMethod(cArray2, nArray, bl);
        return stringUtil$FindAnyMethod.perform(cArray, bl2);
    }
}

