/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;
import net.java.plaf.ClientProperties;
import net.java.plaf.util.Messages;

public final class TextComponentMenu {
    private static final Messages MESSAGES = new Messages("TextComponentPopup", "net.java.plaf.windows.common.CommonResources");
    private final JTextComponent m_component;
    private Listener m_listener;
    private ActionMap m_actionMap;
    private UndoableEdit m_lastUndoableEdit;
    private static final String ACTION_UNDO = "undo";
    private static final String ACTION_CUT = "cut";
    private static final String ACTION_COPY = "copy";
    private static final String ACTION_PASTE = "paste";
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_SELECT_ALL = "selectAll";

    public TextComponentMenu(JTextComponent component) {
        this.m_component = component;
        this.m_listener = new Listener();
        this.m_component.addMouseListener(this.m_listener);
        this.m_component.addKeyListener(this.m_listener);
        this.m_component.getDocument().addUndoableEditListener(this.m_listener);
    }

    public void uninstall() {
        this.m_component.removeMouseListener(this.m_listener);
        this.m_component.removeKeyListener(this.m_listener);
        this.m_component.getDocument().removeUndoableEditListener(this.m_listener);
    }

    public void documentChanged(Document oldDocument, Document newDocument) {
        this.m_lastUndoableEdit = null;
        oldDocument.removeUndoableEditListener(this.m_listener);
        newDocument.addUndoableEditListener(this.m_listener);
    }

    private void createActionMap() {
        ActionMap map = new ActionMap();
        UndoAction undo = new UndoAction();
        MESSAGES.resAction(undo, "Undo");
        map.put(ACTION_UNDO, undo);
        map.put(ACTION_CUT, this.createDelegateAction(this.m_component.getActionMap().get("cut-to-clipboard"), "Cut"));
        map.put(ACTION_COPY, this.createDelegateAction(this.m_component.getActionMap().get("copy-to-clipboard"), "Copy"));
        map.put(ACTION_PASTE, this.createDelegateAction(this.m_component.getActionMap().get("paste-from-clipboard"), "Paste"));
        map.put(ACTION_DELETE, this.createDelegateAction(this.m_component.getActionMap().get("delete-next"), "Delete"));
        map.put(ACTION_SELECT_ALL, this.createDelegateAction(this.m_component.getActionMap().get("select-all"), "SelectAll"));
        this.m_actionMap = map;
    }

    private ActionMap getActionMap() {
        if (this.m_actionMap == null) {
            this.createActionMap();
        }
        return this.m_actionMap;
    }

    private void showPopupMenu(JTextComponent component, int x, int y) {
        Boolean showPopup = (Boolean)component.getClientProperty(ClientProperties.NO_TEXTFIELD_POPUP);
        if (showPopup == null || !showPopup.booleanValue()) {
            JPopupMenu popup = new JPopupMenu();
            this.updateActionEnablement();
            ActionMap map = this.getActionMap();
            popup.add(map.get(ACTION_UNDO));
            popup.addSeparator();
            popup.add(map.get(ACTION_CUT));
            popup.add(map.get(ACTION_COPY));
            popup.add(map.get(ACTION_PASTE));
            popup.add(map.get(ACTION_DELETE));
            popup.addSeparator();
            popup.add(map.get(ACTION_SELECT_ALL));
            popup.show(component, x, y);
        }
    }

    private void showPopupMenu(JTextComponent component, MouseEvent me) {
        this.showPopupMenu(component, me.getX(), me.getY());
    }

    private void updateActionEnablement() {
        boolean selectedText = this.m_component.getSelectionEnd() - this.m_component.getSelectionStart() > 0;
        boolean containsText = this.m_component.getDocument().getLength() > 0;
        boolean editable = this.m_component.isEditable();
        boolean copyProtected = this.m_component instanceof JPasswordField;
        boolean dataOnClipboard = this.m_component.getToolkit().getSystemClipboard().getContents(null) != null;
        ActionMap map = this.getActionMap();
        map.get(ACTION_UNDO).setEnabled(editable && this.m_lastUndoableEdit != null && this.m_lastUndoableEdit.canUndo());
        map.get(ACTION_CUT).setEnabled(!copyProtected && editable && selectedText);
        map.get(ACTION_COPY).setEnabled(!copyProtected && selectedText);
        map.get(ACTION_PASTE).setEnabled(editable && dataOnClipboard);
        map.get(ACTION_DELETE).setEnabled(editable && selectedText);
        map.get(ACTION_SELECT_ALL).setEnabled(containsText);
    }

    private Action createDelegateAction(Action base, String resKey) {
        DelegateAction delegateAction = new DelegateAction(base);
        MESSAGES.resAction(delegateAction, resKey);
        return delegateAction;
    }

    private static interface ResourceConstants {
        public static final String UNDO = "Undo";
        public static final String CUT = "Cut";
        public static final String COPY = "Copy";
        public static final String PASTE = "Paste";
        public static final String DELETE = "Delete";
        public static final String SELECT_ALL = "SelectAll";
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
            super(TextComponentMenu.ACTION_UNDO);
        }

        public void actionPerformed(ActionEvent ae) {
            if (TextComponentMenu.this.m_lastUndoableEdit != null && TextComponentMenu.this.m_lastUndoableEdit.canUndo()) {
                TextComponentMenu.this.m_lastUndoableEdit.undo();
            }
        }
    }

    private class DelegateAction
    extends AbstractAction {
        private final Action m_baseAction;

        public DelegateAction(Action baseAction) {
            this.m_baseAction = baseAction;
        }

        public void actionPerformed(ActionEvent ae) {
            this.m_baseAction.actionPerformed(ae);
        }
    }

    private class Listener
    extends MouseAdapter
    implements KeyListener,
    UndoableEditListener {
        private Listener() {
        }

        public void mouseReleased(final MouseEvent me) {
            JTextComponent component;
            if (me.isPopupTrigger() && me.getSource() instanceof JTextComponent && (component = (JTextComponent)me.getSource()).isEnabled()) {
                if (component.hasFocus()) {
                    TextComponentMenu.this.showPopupMenu(component, me);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            TextComponentMenu.this.showPopupMenu(component, me);
                        }
                    });
                }
            }
        }

        public void keyTyped(KeyEvent ke) {
        }

        public void keyPressed(KeyEvent ke) {
            if (ke.isShiftDown() && ke.getKeyCode() == 121) {
                int x = TextComponentMenu.this.m_component.getWidth() / 2;
                int y = TextComponentMenu.this.m_component.getHeight() / 2;
                TextComponentMenu.this.showPopupMenu(TextComponentMenu.this.m_component, x, y);
            }
        }

        public void keyReleased(KeyEvent ke) {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            if (e.getEdit().canUndo()) {
                TextComponentMenu.this.m_lastUndoableEdit = e.getEdit();
            }
        }
    }
}

