/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.AlignSeq;
import jalview.DrawableSequence;
import jalview.Format;
import jalview.PairAlignFrame;
import jalview.Sequence;
import java.awt.Font;

public final class PairAlignThread
extends Thread {
    AlignFrame af;

    public PairAlignThread(AlignFrame alignFrame) {
        this.af = alignFrame;
    }

    public void run() {
        int n;
        float[][] fArray = new float[this.af.ap.seqPanel.align.size()][this.af.ap.seqPanel.align.size()];
        double d = 0.0;
        int n2 = this.af.ap.sel.size();
        if (n2 == 1) {
            this.af.status.setText("ERROR: only 1 sequence selected");
            return;
        }
        if (n2 == 0) {
            this.af.status.setText("ERROR: no sequences selected");
            return;
        }
        PairAlignFrame pairAlignFrame = new PairAlignFrame("Pairwise alignments", 25, 73, "");
        pairAlignFrame.setTextFont(new Font("Courier", 0, 12));
        pairAlignFrame.resize(550, 550);
        pairAlignFrame.show();
        int n3 = 0;
        int n4 = 1;
        while (n4 < n2) {
            n = 0;
            while (n < n4) {
                AlignSeq alignSeq = new AlignSeq((Sequence)this.af.ap.sel.elementAt(n4), (Sequence)this.af.ap.sel.elementAt(n), "pep");
                pairAlignFrame.status.setText("Aligning " + alignSeq.s1.getName() + " and " + alignSeq.s2.getName() + " (" + ++n3 + "/" + n2 * (n2 - 1) / 2 + ")");
                alignSeq.calcScoreMatrix();
                alignSeq.traceAlignment();
                alignSeq.printAlignment();
                fArray[n4][n] = (float)alignSeq.maxscore / (float)alignSeq.aseq1.length;
                d += (double)fArray[n4][n];
                pairAlignFrame.setText(String.valueOf(pairAlignFrame.getText()) + alignSeq.output);
                pairAlignFrame.ta.setCaretPosition(pairAlignFrame.ta.getText().length());
                pairAlignFrame.addSequence(new DrawableSequence(alignSeq.s1.getName(), alignSeq.astr1, 0, 0));
                pairAlignFrame.addSequence(new DrawableSequence(alignSeq.s2.getName(), alignSeq.astr2, 0, 0));
                ++n;
            }
            ++n4;
        }
        this.af.status.setText("done");
        System.out.println();
        if (n2 > 2) {
            System.out.print("      ");
            n = 0;
            while (n < n2) {
                int n5 = 0;
                while (n5 < n) {
                    Format.print(System.out, "%7.3f", (double)fArray[n][n5] / d);
                    ++n5;
                }
                System.out.println();
                ++n;
            }
        }
    }
}

