# NAME

App::Greple::xlate - модуль поддержки перевода для greple

# SYNOPSIS

    greple -Mxlate::deepl --xlate pattern target-file

    greple -Mxlate::gpt4 --xlate pattern target-file

    greple -Mxlate --xlate-engine gpt4 --xlate pattern target-file

# VERSION

Version 0.9910

# DESCRIPTION

**Greple** **xlate** модуль находит нужные текстовые блоки и заменяет их на переведённый текст. В настоящее время в качестве движка используются модули DeepL (`deepl.pm`) и ChatGPT 4.1 (`gpt4.pm`).

Если вы хотите перевести обычные текстовые блоки в документе, написанном в стиле pod Perl, используйте команду **greple** с модулями `xlate::deepl` и `perl` следующим образом:

    greple -Mxlate::deepl -Mperl --pod --re '^([\w\pP].*\n)+' --all foo.pm

В этой команде строка шаблона `^([\w\pP].*\n)+` означает последовательные строки, начинающиеся с буквенно-цифрового символа или знака препинания. Эта команда выделяет область для перевода. Опция **--all** используется для вывода всего текста.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/select-area.png">
    </p>
</div>

Затем добавьте опцию `--xlate` для перевода выбранной области. После этого будут найдены нужные секции и заменены на вывод команды **deepl**.

По умолчанию исходный и переведённый текст выводятся в формате "конфликтных маркеров", совместимом с [git(1)](http://man.he.net/man1/git). Используя формат `ifdef`, вы можете легко получить нужную часть с помощью команды [unifdef(1)](http://man.he.net/man1/unifdef). Формат вывода можно указать с помощью опции **--xlate-format**.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/format-conflict.png">
    </p>
</div>

Если вы хотите перевести весь текст, используйте опцию **--match-all**. Это сокращение для указания шаблона `(?s).+`, который соответствует всему тексту.

Данные в формате конфликтных маркеров можно просматривать в виде "бок о бок" с помощью команды `sdif` и опции `-V`. Поскольку сравнивать по отдельным строкам не имеет смысла, рекомендуется использовать опцию `--no-cdif`. Если вам не нужно раскрашивать текст, укажите `--no-textcolor` (или `--no-tc`).

    sdif -V --no-tc --no-cdif data_shishin.deepl-EN-US.cm

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/sdif-cm-view.png">
    </p>
</div>

# NORMALIZATION

Обработка выполняется в указанных единицах, но если имеется последовательность из нескольких строк непустого текста, они преобразуются вместе в одну строку. Эта операция выполняется следующим образом:

- Удаляется пробел в начале и конце каждой строки.
- Если строка заканчивается символом пунктуации во всю ширину, объединить с следующей строкой.
- Если строка заканчивается символом во всю ширину и следующая строка начинается с символа во всю ширину, объединить строки.
- Если либо конец, либо начало строки не является символом во всю ширину, объединить их, вставив пробел.

Данные кэша управляются на основе нормализованного текста, поэтому даже если были внесены изменения, не влияющие на результат нормализации, кэшированные данные перевода останутся актуальными.

Этот процесс нормализации выполняется только для первого (нулевого) и чётных шаблонов. Таким образом, если указаны два шаблона, как показано ниже, текст, соответствующий первому шаблону, будет обработан после нормализации, а для текста, соответствующего второму шаблону, нормализация не выполняется.

    greple -Mxlate -E normalized -E not-normalized

Поэтому используйте первый шаблон для текста, который должен быть обработан путём объединения нескольких строк в одну, а второй шаблон — для предварительно отформатированного текста. Если в первом шаблоне нет текста для сопоставления, используйте шаблон, который не совпадает ни с чем, например `(?!)`.

# MASKING

Иногда бывают части текста, которые вы не хотите переводить. Например, теги в markdown-файлах. DeepL предлагает в таких случаях преобразовать часть текста, которую нужно исключить, в XML-теги, перевести, а затем восстановить после завершения перевода. Для поддержки этого можно указать части, которые нужно скрыть от перевода.

    --xlate-setopt maskfile=MASKPATTERN

Каждая строка файла \`MASKPATTERN\` будет интерпретироваться как регулярное выражение, строки, соответствующие ему, будут переведены, а затем восстановлены после обработки. Строки, начинающиеся с `#`, игнорируются.

Сложный шаблон можно записать на нескольких строках с помощью экранированного обратного слэша.

Как текст преобразуется при маскировании, можно увидеть с помощью опции **--xlate-mask**.

Этот интерфейс является экспериментальным и может измениться в будущем.

# OPTIONS

- **--xlate**
- **--xlate-color**
- **--xlate-fold**
- **--xlate-fold-width**=_n_ (Default: 70)

    Запускайте процесс перевода для каждой совпадающей области.

    Без этой опции **greple** ведет себя как обычная команда поиска. Таким образом, вы можете проверить, какая часть файла будет подлежать переводу, прежде чем запускать фактическую работу.

    Результат команды выводится в стандартный вывод, поэтому при необходимости перенаправьте его в файл или рассмотрите возможность использования модуля [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate).

    Опция **--xlate** вызывает опцию **--xlate-color** с опцией **--color=never**.

    С опцией **--xlate-fold** преобразованный текст разбивается по указанной ширине. Ширина по умолчанию — 70 и может быть установлена с помощью опции **--xlate-fold-width**. Четыре столбца зарезервированы для работы run-in, поэтому каждая строка может содержать максимум 74 символа.

- **--xlate-engine**=_engine_

    Указывает, какой переводческий движок будет использоваться. Если вы указываете модуль движка напрямую, например `-Mxlate::deepl`, то эту опцию использовать не нужно.

    В настоящее время доступны следующие движки

    - **deepl**: DeepL API
    - **gpt3**: gpt-3.5-turbo
    - **gpt4**: gpt-4.1
    - **gpt4o**: gpt-4o-mini

        Интерфейс **gpt-4o** нестабилен и не гарантируется его корректная работа на данный момент.

- **--xlate-labor**
- **--xlabor**

    Вместо вызова переводческого движка предполагается, что вы будете работать вручную. После подготовки текста к переводу он копируется в буфер обмена. Ожидается, что вы вставите его в форму, скопируете результат в буфер обмена и нажмете Enter.

- **--xlate-to** (Default: `EN-US`)

    Укажите целевой язык. Доступные языки можно получить с помощью команды `deepl languages` при использовании движка **DeepL**.

- **--xlate-format**=_format_ (Default: `conflict`)

    Укажите формат вывода для исходного и переведенного текста.

    Следующие форматы, кроме `xtxt`, предполагают, что часть для перевода — это набор строк. На самом деле можно перевести только часть строки, но указание формата, отличного от `xtxt`, не даст осмысленных результатов.

    - **conflict**, **cm**

        Исходный и преобразованный текст выводятся в формате маркера конфликта [git(1)](http://man.he.net/man1/git).

            <<<<<<< ORIGINAL
            original text
            =======
            translated Japanese text
            >>>>>>> JA

        Вы можете восстановить исходный файл с помощью следующей команды [sed(1)](http://man.he.net/man1/sed).

            sed -e '/^<<<<<<< /d' -e '/^=======$/,/^>>>>>>> /d'

    - **colon**, _:::::::_

        Исходный и переведенный текст выводятся в стиле пользовательского контейнера markdown.

            ::::::: ORIGINAL
            original text
            :::::::
            ::::::: JA
            translated Japanese text
            :::::::

        Вышеприведённый текст будет переведён следующим образом в HTML.

            <div class="ORIGINAL">
            original text
            </div>
            <div class="JA">
            translated Japanese text
            </div>

        По умолчанию количество двоеточий — 7. Если вы укажете последовательность двоеточий, например `:::::`, она будет использоваться вместо 7 двоеточий.

    - **ifdef**

        Исходный и преобразованный текст выводятся в формате [cpp(1)](http://man.he.net/man1/cpp) `#ifdef`.

            #ifdef ORIGINAL
            original text
            #endif
            #ifdef JA
            translated Japanese text
            #endif

        Вы можете получить только японский текст с помощью команды **unifdef**:

            unifdef -UORIGINAL -DJA foo.ja.pm

    - **space**
    - **space+**

        Оригинальный и преобразованный текст печатаются, разделённые одной пустой строкой.

    - **xtxt**

        Для `space+` также выводится новая строка после преобразованного текста.

- **--xlate-maxlen**=_chars_ (Default: 0)

    Если формат `xtxt` (переведённый текст) или неизвестен, выводится только переведённый текст.

- **--xlate-maxline**=_n_ (Default: 0)

    Укажите максимальную длину текста, который можно отправить в API за один раз. Значение по умолчанию установлено как для бесплатного сервиса DeepL: 128K для API (**--xlate**) и 5000 для интерфейса буфера обмена (**--xlate-labor**). Вы можете изменить эти значения, если используете Pro-сервис.

    Укажите максимальное количество строк текста, которые можно отправить в API за один раз.

- **--**\[**no-**\]**xlate-progress** (Default: True)

    Установите это значение в 1, если хотите переводить по одной строке за раз. Эта опция имеет приоритет над опцией `--xlate-maxlen`.

- **--xlate-stripe**

    Смотрите результат перевода в реальном времени в выводе STDERR.

    Используйте модуль [App::Greple::stripe](https://metacpan.org/pod/App%3A%3AGreple%3A%3Astripe) для отображения совпадающих частей с помощью чередующихся полос. Это полезно, когда совпадающие части соединены вплотную.

- **--xlate-mask**

    Палитра цветов переключается в зависимости от цвета фона терминала. Если хотите указать явно, используйте **--xlate-stripe-light** или **--xlate-stripe-dark**.

- **--match-all**

    Выполнить функцию маскирования и отображать преобразованный текст как есть, без восстановления.

- **--lineify-cm**
- **--lineify-colon**

    В случае форматов `cm` и `colon` вывод разбивается и форматируется построчно.

    Поэтому, если требуется перевести только часть строки, ожидаемый результат получить невозможно.

# CACHE OPTIONS

Установить весь текст файла как целевую область.

Модуль **xlate** может сохранять кэшированный текст перевода для каждого файла и читать его перед выполнением, чтобы устранить задержки при обращении к серверу. С использованием стратегии кэширования по умолчанию `auto`, данные кэша поддерживаются только при наличии кэш-файла для целевого файла.

- --xlate-cache=_strategy_
    - `auto` (Default)

        Используйте **--xlate-cache=clear** для инициализации управления кэшем или для очистки всех существующих данных кэша. После выполнения с этой опцией будет создан новый кэш-файл, если он отсутствует, и далее поддерживаться автоматически.

    - `create`

        Поддерживать кэш-файл, если он существует.

    - `always`, `yes`, `1`

        Создать пустой кэш-файл и выйти.

    - `clear`

        Поддерживать кэш в любом случае, если целевой файл является обычным файлом.

    - `never`, `no`, `0`

        Сначала очистить данные кэша.

    - `accumulate`

        Никогда не использовать кэш-файл, даже если он существует.
- **--xlate-update**

    По умолчанию неиспользуемые данные удаляются из кэш-файла. Если вы не хотите их удалять и сохранять в файле, используйте `accumulate`.

# COMMAND LINE INTERFACE

Эта опция принудительно обновляет кэш-файл, даже если это не требуется.

Вы можете легко использовать этот модуль из командной строки с помощью команды `xlate`, включённой в дистрибутив. Смотрите страницу руководства `xlate` для использования.

Команда `xlate` работает совместно с окружением Docker, поэтому даже если у вас ничего не установлено, вы можете использовать её, если доступен Docker. Используйте опцию `-D` или `-C`.

Также, поскольку предоставляются make-файлы для различных стилей документов, перевод на другие языки возможен без специальных указаний. Используйте опцию `-M`.

Вы также можете комбинировать Docker и опции `make`, чтобы запускать `make` в окружении Docker.

Запуск в виде `xlate -C` откроет оболочку с примонтированным текущим рабочим git-репозиторием.

# EMACS

Загрузите файл `xlate.el`, включенный в репозиторий, чтобы использовать команду `xlate` из редактора Emacs. 

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/emacs.png">
    </p>
</div>

# ENVIRONMENT

- DEEPL\_AUTH\_KEY

    Функция `xlate-region` переводит выделенный регион. Язык по умолчанию — `EN-US`, и вы можете указать язык, вызвав её с префиксным аргументом.

- OPENAI\_API\_KEY

    Установите ваш ключ аутентификации для сервиса DeepL.

# INSTALL

## CPANMINUS

    $ cpanm App::Greple::xlate

## TOOLS

Ключ аутентификации OpenAI.

Вам необходимо установить инструменты командной строки для DeepL и ChatGPT.

[https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

# SEE ALSO

[https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

[App::Greple::xlate](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate)

[App::Greple::xlate::gpt4](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Agpt4)

- [https://hub.docker.com/r/tecolicom/xlate](https://hub.docker.com/r/tecolicom/xlate)

    [App::Greple::xlate::gpt3](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Agpt3)

- [https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

    Образ контейнера Docker.

- [https://github.com/openai/openai-python](https://github.com/openai/openai-python)

    Библиотека DeepL для Python и команда CLI.

- [https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

    Библиотека OpenAI для Python

- [App::Greple](https://metacpan.org/pod/App%3A%3AGreple)

    Интерфейс командной строки OpenAI

- [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate)

    Смотрите руководство **greple** для подробностей о целевом шаблоне текста. Используйте опции **--inside**, **--outside**, **--include**, **--exclude** для ограничения области поиска.

- [App::sdif](https://metacpan.org/pod/App%3A%3Asdif)

    Вы можете использовать модуль `-Mupdate` для изменения файлов по результату команды **greple**.

- [App::Greple::stripe](https://metacpan.org/pod/App%3A%3AGreple%3A%3Astripe)

    Используйте **sdif** для отображения формата маркера конфликта рядом с опцией **-V**.

## ARTICLES

- [https://qiita.com/kaz-utashiro/items/1c1a51a4591922e18250](https://qiita.com/kaz-utashiro/items/1c1a51a4591922e18250)

    Модуль Greple **stripe** используется с опцией **--xlate-stripe**.

- [https://qiita.com/kaz-utashiro/items/a5e19736416ca183ecf6](https://qiita.com/kaz-utashiro/items/a5e19736416ca183ecf6)

    Модуль Greple для перевода и замены только необходимых частей с помощью DeepL API (на японском языке)

- [https://qiita.com/kaz-utashiro/items/1b9e155d6ae0620ab4dd](https://qiita.com/kaz-utashiro/items/1b9e155d6ae0620ab4dd)

    Генерация документов на 15 языках с помощью модуля DeepL API (на японском языке)

# AUTHOR

Kazumasa Utashiro

# LICENSE

Copyright © 2023-2025 Kazumasa Utashiro.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
