package WWW::Hetzner::Robot::CLI::Cmd::Server;
our $VERSION = '0.001';
our $AUTHORITY = 'cpan:GETTY';

# ABSTRACT: Robot server commands

use Moo;
use MooX::Cmd;
use MooX::Options usage_string => 'USAGE: hrobot.pl server [list|describe] [options]';


sub execute {
    my ($self, $args, $chain) = @_;
    my $root = $chain->[0];
    my $robot = $root->robot;

    # Default: list servers
    my $servers = $robot->servers->list;

    if ($root->output eq 'json') {
        require JSON::MaybeXS;
        print JSON::MaybeXS::encode_json([map { +{
            server_number => $_->server_number,
            server_name   => $_->server_name,
            server_ip     => $_->server_ip,
            product       => $_->product,
            dc            => $_->dc,
            status        => $_->status,
        } } @$servers]);
        print "\n";
    } else {
        printf "%-12s %-20s %-15s %-20s %s\n",
            'NUMBER', 'NAME', 'IP', 'PRODUCT', 'DC';
        for my $s (@$servers) {
            printf "%-12s %-20s %-15s %-20s %s\n",
                $s->server_number // '',
                $s->server_name // '',
                $s->server_ip // '',
                $s->product // '',
                $s->dc // '';
        }
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Hetzner::Robot::CLI::Cmd::Server - Robot server commands

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    hrobot.pl server                    # List all servers (default)
    hrobot.pl server list               # List all servers
    hrobot.pl server describe <number>  # Show server details

=head1 DESCRIPTION

Commands for managing Hetzner dedicated servers.
Without a subcommand, lists all servers.

=head1 NAME

hrobot.pl server - Manage dedicated servers

=head1 SUBCOMMANDS

=over 4

=item B<list>

List all dedicated servers.

=item B<describe> <server-number>

Show detailed information about a specific server.

=back

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/Getty/p5-www-hetzner>

  git clone https://github.com/Getty/p5-www-hetzner.git

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
