package WWW::Bund::CLI::Cmd::DashboardDeutschland;
our $VERSION = '0.001';
# ABSTRACT: Dashboard Deutschland API command

use Moo;
use MooX::Cmd;
use MooX::Options protect_argv => 0;


with 'WWW::Bund::CLI::Role::APICommand';

sub api_id { 'dashboard_deutschland' }

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Bund::CLI::Cmd::DashboardDeutschland - Dashboard Deutschland API command

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    bund dashboard-deutschland indicators   # List indicators
    bund dashboard-deutschland data         # Get indicator data

=head1 DESCRIPTION

CLI commands for Dashboard Deutschland API (government statistics dashboard). Uses L<WWW::Bund::CLI::Role::APICommand>.

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/Getty/p5-www-bund/issues>.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
