package # L - logging
	L;  # Hide from PAUSE

use strict;
use warnings;


our $logger =  sub{ CORE::state $l =  bless {}, 'L::Logger' };
sub log    { $logger->()         }

sub debug  { L::log->debug( @_ ) }
sub info   { L::log->info(  @_ ) }
sub warn   { L::log->warn(  @_ ) }
sub error  { L::log->error( @_ ) }
sub fatal  { L::log->fatal( @_ ) }


package L::Logger;
sub AUTOLOAD { shift; print STDERR @_ }

1;

=encoding utf8

=head1 NAME

C<L> - logging


=head1 SYNOPSIS

  use L;

  L::info "Hello\n";
  L::warn "Something happened\n";

  # Replace logger implementation
  $L::logger =  sub { My::Logger->new };


=head1 DESCRIPTION

C<L> provides a minimal logging facade. By default all log levels delegate to
a singleton C<L::Logger> instance which prints to STDERR.


=head1 FUNCTIONS

=head2 log

  my $logger =  L::log;

Return the current logger object (created lazily).


=head2 debug

  L::debug @msg;


=head2 info

  L::info @msg;


=head2 warn

  L::warn @msg;


=head2 error

  L::error @msg;


=head2 fatal

  L::fatal @msg;

All level functions forward to the corresponding method on the logger object.


=head1 SEE ALSO

L<A>, L<C>, L<I>, L<L>, L<M>, L<S>, L<T>, L<U>.

=cut
