/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.PrintWriter;
import java.util.Map;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RenderUnit;

public class SightlyCompiledScript
extends CompiledScript {
    private final SightlyScriptEngine scriptEngine;
    private final RenderUnit renderUnit;

    public SightlyCompiledScript(SightlyScriptEngine scriptEngine, RenderUnit renderUnit) {
        this.scriptEngine = scriptEngine;
        this.renderUnit = renderUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(ScriptContext context) {
        Bindings bindings = context.getBindings(100);
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        SlingHttpServletRequest request = slingBindings.getRequest();
        if (request == null) {
            throw new SightlyException("Missing SlingHttpServletRequest from ScriptContext.");
        }
        Object oldBindings = request.getAttribute(SlingBindings.class.getName());
        try {
            request.setAttribute(SlingBindings.class.getName(), (Object)slingBindings);
            RenderContextImpl renderContext = new RenderContextImpl(this.scriptEngine.getConfiguration(), this.scriptEngine.getExtensionRegistryService(), context);
            PrintWriter out = new PrintWriter(context.getWriter());
            this.renderUnit.render(out, (RenderContext)renderContext, (Bindings)new LazyBindings());
        }
        finally {
            request.setAttribute(SlingBindings.class.getName(), oldBindings);
        }
        return null;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.scriptEngine;
    }

    public RenderUnit getRenderUnit() {
        return this.renderUnit;
    }
}

