/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.filter;

import relocated_for_contentpackage.javax.jcr.Item;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.Property;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.DumpContext;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.filter.DepthItemFilter;

public class IsMandatoryFilter
extends DepthItemFilter {
    private boolean isMandatory = true;

    public IsMandatoryFilter() {
    }

    public IsMandatoryFilter(boolean isMandatory, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.isMandatory = isMandatory;
    }

    public IsMandatoryFilter(boolean isMandatory) {
        this(isMandatory, 0, Integer.MAX_VALUE);
    }

    public void setCondition(String node) {
        this.isMandatory = Boolean.valueOf(node);
    }

    public void setIsMandatory(String node) {
        this.isMandatory = Boolean.valueOf(node);
    }

    @Override
    public boolean matches(Item item) throws RepositoryException {
        if (item.isNode()) {
            return ((Node)item).getDefinition().isMandatory() == this.isMandatory;
        }
        return ((Property)item).getDefinition().isMandatory() == this.isMandatory;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(true, "isMandatory: %b", this.isMandatory);
        ctx.outdent();
    }
}

