/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.avg;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.meter.function.PercentileArgument;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MeterFunction(functionName="avgHistogramPercentile")
public abstract class AvgHistogramPercentileFunction
extends Meter
implements AcceptableValue<PercentileArgument>,
LabeledValueHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvgHistogramPercentileFunction.class);
    public static final String DATASET = "dataset";
    public static final String RANKS = "ranks";
    public static final String VALUE = "datatable_value";
    protected static final String SUMMATION = "datatable_summation";
    protected static final String COUNT = "datatable_count";
    @ElasticSearch.EnableDocValues
    @Column(name="entity_id")
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @ElasticSearch.Column(legacyName="value")
    @BanyanDB.MeasureField
    private DataTable percentileValues = new DataTable(10);
    @Column(name="datatable_summation", storageOnly=true)
    @ElasticSearch.Column(legacyName="summation")
    @BanyanDB.MeasureField
    protected DataTable summation = new DataTable(30);
    @Column(name="datatable_count", storageOnly=true)
    @ElasticSearch.Column(legacyName="count")
    @BanyanDB.MeasureField
    protected DataTable count = new DataTable(30);
    @Column(name="dataset", storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable dataset = new DataTable(30);
    @Column(name="ranks", storageOnly=true)
    @BanyanDB.MeasureField
    private IntList ranks = new IntList(10);
    private boolean isCalculated = false;

    @Override
    public void accept(MeterEntity entity, PercentileArgument value) {
        if (this.dataset.size() > 0 && !value.getBucketedValues().isCompatible(this.dataset)) {
            throw new IllegalArgumentException("Incompatible BucketedValues [" + value + "] for current PercentileFunction[" + this.dataset + "]");
        }
        for (int rank : value.getRanks()) {
            if (rank > 0) continue;
            throw new IllegalArgumentException("Illegal rank value " + rank + ", must be positive");
        }
        if (this.ranks.size() > 0) {
            if (this.ranks.size() != value.getRanks().length) {
                throw new IllegalArgumentException("Incompatible ranks size = [" + value.getRanks().length + "] for current PercentileFunction[" + this.ranks.size() + "]");
            }
            for (int rank : value.getRanks()) {
                if (this.ranks.include(rank)) continue;
                throw new IllegalArgumentException("Rank " + rank + " doesn't exist in the previous ranks " + this.ranks);
            }
        } else {
            for (int rank : value.getRanks()) {
                this.ranks.add(rank);
            }
        }
        this.entityId = entity.id();
        Object template = "%s";
        if (CollectionUtils.isNotEmpty((Map)value.getBucketedValues().getLabels())) {
            template = value.getBucketedValues().getLabels() + ":%s";
        }
        long[] values = value.getBucketedValues().getValues();
        for (int i = 0; i < values.length; ++i) {
            long bucket = value.getBucketedValues().getBuckets()[i];
            String bucketName = bucket == Long.MIN_VALUE ? "infinite-" : String.valueOf(bucket);
            String key = String.format((String)template, bucketName);
            this.summation.valueAccumulation(key, values[i]);
            this.count.valueAccumulation(key, 1L);
        }
        this.isCalculated = false;
    }

    @Override
    public boolean combine(Metrics metrics) {
        AvgHistogramPercentileFunction percentile = (AvgHistogramPercentileFunction)metrics;
        if (this.ranks.size() > 0) {
            IntList ranksOfThat = percentile.getRanks();
            if (this.ranks.size() != ranksOfThat.size()) {
                log.warn("Incompatible ranks size = [{}}] for current PercentileFunction[{}]", (Object)ranksOfThat.size(), (Object)this.ranks.size());
                return true;
            }
            if (!this.ranks.equals(ranksOfThat)) {
                log.warn("Rank {} doesn't exist in the previous ranks {}", (Object)ranksOfThat, (Object)this.ranks);
                return true;
            }
        }
        this.summation.append(percentile.summation);
        this.count.append(percentile.count);
        this.isCalculated = false;
        return true;
    }

    @Override
    public void calculate() {
        if (!this.isCalculated) {
            Set<String> keys = this.summation.keys();
            for (String key2 : keys) {
                long value = 0L;
                if (this.count.get(key2) != 0L && (value = this.summation.get(key2) / this.count.get(key2)) == 0L && this.summation.get(key2) > 0L) {
                    value = 1L;
                }
                this.dataset.put(key2, (Long)value);
            }
            this.dataset.keys().stream().map(key -> {
                DataLabel dataLabel = new DataLabel();
                if (key.contains(":")) {
                    int index = key.lastIndexOf(":");
                    dataLabel.put(key.substring(0, index));
                    return Tuple.of((Object)dataLabel, (Object)key);
                }
                return Tuple.of((Object)dataLabel, (Object)key);
            }).collect(Collectors.groupingBy(Tuple2::_1, Collectors.mapping(Tuple2::_2, Collector.of(DataTable::new, (dt, key) -> {
                String v;
                if (key.contains(":")) {
                    int index = key.lastIndexOf(":");
                    v = key.substring(index + 1);
                } else {
                    v = key;
                }
                dt.put(v, this.dataset.get((String)key));
            }, DataTable::append, new Collector.Characteristics[0])))).forEach((labels, subDataset) -> {
                long total = subDataset.sumOfValues();
                int[] roofs = new int[this.ranks.size()];
                for (int i = 0; i < this.ranks.size(); ++i) {
                    roofs[i] = Math.round((float)(total * (long)this.ranks.get(i)) * 1.0f / 100.0f);
                }
                int count = 0;
                List<String> sortedKeys = subDataset.sortedKeys(Comparator.comparingLong(Long::parseLong));
                int loopIndex = 0;
                for (String key : sortedKeys) {
                    int roof;
                    Long value = subDataset.get(key);
                    count = (int)((long)count + value);
                    for (int rankIdx = loopIndex; rankIdx < roofs.length && count >= (roof = roofs[rankIdx]); ++rankIdx) {
                        if (labels.isEmpty()) {
                            labels.put("p", String.valueOf(this.ranks.get(rankIdx)));
                            this.percentileValues.put((DataLabel)labels, (Long)Long.parseLong(key));
                        } else {
                            labels.put("p", String.valueOf(this.ranks.get(rankIdx)));
                            this.percentileValues.put((DataLabel)labels, (Long)Long.parseLong(key));
                        }
                        ++loopIndex;
                    }
                }
            });
        }
    }

    @Override
    public Metrics toHour() {
        AvgHistogramPercentileFunction metrics = (AvgHistogramPercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.getSummation().copyFrom(this.getSummation());
        metrics.getCount().copyFrom(this.getCount());
        metrics.getRanks().copyFrom(this.getRanks());
        metrics.getPercentileValues().copyFrom(this.getPercentileValues());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        AvgHistogramPercentileFunction metrics = (AvgHistogramPercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.getSummation().copyFrom(this.getSummation());
        metrics.getCount().copyFrom(this.getCount());
        metrics.getRanks().copyFrom(this.getRanks());
        metrics.getPercentileValues().copyFrom(this.getPercentileValues());
        return metrics;
    }

    @Override
    public DataTable getValue() {
        return this.percentileValues;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSummation(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setCount(new DataTable(remoteData.getDataObjectStrings(1)));
        this.setRanks(new IntList(remoteData.getDataObjectStrings(2)));
        this.setPercentileValues(new DataTable(remoteData.getDataObjectStrings(3)));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataObjectStrings(this.summation.toStorageData());
        remoteBuilder.addDataObjectStrings(this.count.toStorageData());
        remoteBuilder.addDataObjectStrings(this.ranks.toStorageData());
        remoteBuilder.addDataObjectStrings(this.percentileValues.toStorageData());
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public Class<? extends AvgPercentileFunctionBuilder> builder() {
        return AvgPercentileFunctionBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvgHistogramPercentileFunction)) {
            return false;
        }
        AvgHistogramPercentileFunction function = (AvgHistogramPercentileFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public DataTable getPercentileValues() {
        return this.percentileValues;
    }

    @Generated
    public void setPercentileValues(DataTable percentileValues) {
        this.percentileValues = percentileValues;
    }

    @Generated
    public DataTable getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(DataTable summation) {
        this.summation = summation;
    }

    @Generated
    public DataTable getCount() {
        return this.count;
    }

    @Generated
    public void setCount(DataTable count) {
        this.count = count;
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }

    @Generated
    public IntList getRanks() {
        return this.ranks;
    }

    @Generated
    public void setRanks(IntList ranks) {
        this.ranks = ranks;
    }

    public static class AvgPercentileFunctionBuilder
    implements StorageBuilder<AvgHistogramPercentileFunction> {
        @Override
        public AvgHistogramPercentileFunction storage2Entity(Convert2Entity converter) {
            AvgHistogramPercentileFunction metrics = new AvgHistogramPercentileFunction(){

                @Override
                public AcceptableValue<PercentileArgument> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setDataset(new DataTable((String)converter.get(AvgHistogramPercentileFunction.DATASET)));
            metrics.setSummation(new DataTable((String)converter.get(AvgHistogramPercentileFunction.SUMMATION)));
            metrics.setCount(new DataTable((String)converter.get(AvgHistogramPercentileFunction.COUNT)));
            metrics.setRanks(new IntList((String)converter.get(AvgHistogramPercentileFunction.RANKS)));
            metrics.setPercentileValues(new DataTable((String)converter.get(AvgHistogramPercentileFunction.VALUE)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(AvgHistogramPercentileFunction storageData, Convert2Storage converter) {
            converter.accept(AvgHistogramPercentileFunction.SUMMATION, storageData.getSummation());
            converter.accept(AvgHistogramPercentileFunction.COUNT, storageData.getCount());
            converter.accept(AvgHistogramPercentileFunction.DATASET, storageData.getDataset());
            converter.accept(AvgHistogramPercentileFunction.RANKS, storageData.getRanks());
            converter.accept(AvgHistogramPercentileFunction.VALUE, storageData.getPercentileValues());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

