/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v8.rest;

import com.linecorp.armeria.server.annotation.Post;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.ISegmentParserService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSegmentReportHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceSegmentReportHandler.class);
    private final ISegmentParserService segmentParserService;
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;

    public TraceSegmentReportHandler(ModuleManager moduleManager) {
        this.segmentParserService = (ISegmentParserService)moduleManager.find("agent-analyzer").provider().getService(ISegmentParserService.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("trace_in_latency", "The process latency of trace data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("trace_analysis_error_count", "The error number of trace analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}));
    }

    @Post(value="/v3/segment")
    public Commands collectSegment(SegmentObject segment) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            this.segmentParserService.send(segment);
        }
        catch (Exception e) {
            this.errorCounter.inc();
            throw e;
        }
        return Commands.newBuilder().build();
    }

    @Post(value="/v3/segments")
    public Commands collectSegments(List<SegmentObject> segments) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            segments.forEach(arg_0 -> ((ISegmentParserService)this.segmentParserService).send(arg_0));
        }
        catch (Exception e) {
            this.errorCounter.inc();
            throw e;
        }
        return Commands.newBuilder().build();
    }
}

